/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyseq.DungeonsWeaponry.entity.custom;

import com.jeremyseq.DungeonsWeaponry.entity.EntityUtil;
import com.jeremyseq.DungeonsWeaponry.entity.custom.FalseKingEntity;
import com.jeremyseq.DungeonsWeaponry.entity.custom.NamelessOneProjectileEntity;
import com.jeremyseq.DungeonsWeaponry.entity.custom.VanguardEntity;
import com.jeremyseq.DungeonsWeaponry.init.ModEntities;
import com.jeremyseq.DungeonsWeaponry.util.ModSoundEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class NamelessOneEntity
extends Monster
implements GeoEntity,
RangedAttackMob {
    public static final EntityDataAccessor<Boolean> SUMMON = SynchedEntityData.m_135353_(NamelessOneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> START_SUMMON = SynchedEntityData.m_135353_(NamelessOneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> ATTACK = SynchedEntityData.m_135353_(NamelessOneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> START_ATTACK = SynchedEntityData.m_135353_(NamelessOneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> HURT = SynchedEntityData.m_135353_(NamelessOneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> START_HURT = SynchedEntityData.m_135353_(NamelessOneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> ILLUSION = SynchedEntityData.m_135353_(NamelessOneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> START_ILLUSION = SynchedEntityData.m_135353_(NamelessOneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int tick;
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private List<LivingEntity> enemyList;
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);
    private AiState aiState = AiState.ATTACKING;
    private int serverTickCounter = 0;
    private int animateAttackTick = 0;
    private int animateSummonTick = 0;
    private int animateIllusionTick = 0;

    public NamelessOneEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 250.0).m_22268_(Attributes.f_22281_, 15.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.25, 40, 10.0f));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Creeper.class, true));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        if (this.getSummonState()) {
            if (this.getStartSummonState()) {
                tAnimationState.getController().forceAnimationReset();
                this.setStartSummonState(false);
            }
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.nameless_one.summon", Animation.LoopType.PLAY_ONCE));
            if (tAnimationState.getController().hasAnimationFinished()) {
                this.setSummonState(false);
            }
            return PlayState.CONTINUE;
        }
        if (((Boolean)this.f_19804_.m_135370_(ILLUSION)).booleanValue()) {
            if (((Boolean)this.f_19804_.m_135370_(START_ILLUSION)).booleanValue()) {
                tAnimationState.getController().forceAnimationReset();
                this.f_19804_.m_135381_(START_ILLUSION, (Object)false);
            }
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.nameless_one.summon", Animation.LoopType.PLAY_ONCE));
            if (tAnimationState.getController().hasAnimationFinished()) {
                this.f_19804_.m_135381_(ILLUSION, (Object)false);
            }
            return PlayState.CONTINUE;
        }
        if (this.getHurt()) {
            if (this.getStartHurt()) {
                tAnimationState.getController().forceAnimationReset();
                this.setStartHurt(false);
            }
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.nameless_one.hurt", Animation.LoopType.PLAY_ONCE));
            if (tAnimationState.getController().hasAnimationFinished()) {
                this.setHurt(false);
            }
            return PlayState.CONTINUE;
        }
        if (this.getAttack()) {
            if (this.getStartAttack()) {
                tAnimationState.getController().forceAnimationReset();
                this.setStartAttack(false);
            }
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.nameless_one.attack", Animation.LoopType.PLAY_ONCE));
            if (tAnimationState.getController().hasAnimationFinished()) {
                this.setAttack(false);
            }
            return PlayState.CONTINUE;
        }
        if (tAnimationState.isMoving()) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.nameless_one.walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.nameless_one.idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    private SoundEvent getStepSound() {
        return SoundEvents.f_12383_;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.NAMELESS_ONE_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSoundEvents.NAMELESS_ONE_HURT.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.NAMELESS_ONE_IDLE.get();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        this.setHurt(true);
        this.setStartHurt(true);
        return super.m_6469_(pSource, pAmount);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        this.m_19983_(new ItemStack((ItemLike)Items.f_42500_, 3 * new Random().nextInt(1, pLooting + 2)));
        EntityUtil.spawnWeaponLoot((Mob)this, 5, pLooting);
        EntityUtil.spawnWeaponLoot((Mob)this, 5, pLooting);
        EntityUtil.spawnWeaponLoot((Mob)this, 5, pLooting);
        EntityUtil.spawnEmeraldLoot((Mob)this, 10, 50, pLooting);
    }

    public int m_213860_() {
        return 2000;
    }

    public void m_6504_(LivingEntity target, float pVelocity) {
        if (this.aiState == AiState.ATTACKING && this.m_9236_() instanceof ServerLevel) {
            this.setAttack(true);
            this.setStartAttack(true);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SUMMON, (Object)false);
        this.f_19804_.m_135372_(START_SUMMON, (Object)false);
        this.f_19804_.m_135372_(HURT, (Object)false);
        this.f_19804_.m_135372_(START_HURT, (Object)false);
        this.f_19804_.m_135372_(ATTACK, (Object)false);
        this.f_19804_.m_135372_(START_ATTACK, (Object)false);
        this.f_19804_.m_135372_(ILLUSION, (Object)false);
        this.f_19804_.m_135372_(START_ILLUSION, (Object)false);
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.aiState == AiState.SUMMONING) {
            ++this.serverTickCounter;
            if (this.serverTickCounter >= 60) {
                this.aiState = AiState.ATTACKING;
                this.serverTickCounter = 0;
            }
        } else if (this.aiState == AiState.ILLUSION) {
            ++this.serverTickCounter;
            if (this.serverTickCounter >= 60) {
                this.aiState = AiState.ATTACKING;
                this.serverTickCounter = 0;
            }
        }
        if (this.getAttack()) {
            ++this.animateAttackTick;
            if (this.animateAttackTick == 15) {
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_247517_(null, this.m_20183_(), (SoundEvent)ModSoundEvents.NECROMANCER_ATTACK.get(), SoundSource.HOSTILE);
                }
                NamelessOneProjectileEntity projectile = new NamelessOneProjectileEntity(this.m_9236_(), (LivingEntity)this, 0.0, 0.0, 0.0);
                projectile.m_20219_(this.m_146892_().m_82549_(this.m_20156_().m_82541_().m_82490_(0.45)).m_82520_(0.0, -0.35, 0.0));
                projectile.m_6686_(this.m_20252_((float)1.0f).f_82479_, this.m_20252_((float)1.0f).f_82480_, this.m_20252_((float)1.0f).f_82481_, 0.5f, 0.0f);
                this.m_9236_().m_7967_((Entity)projectile);
            }
            if (this.animateAttackTick >= 30) {
                this.animateAttackTick = 0;
                this.setAttack(false);
                this.setStartAttack(false);
            }
        }
        if (this.getSummonState()) {
            ++this.animateSummonTick;
            if (this.animateSummonTick == 30) {
                this.summon();
            }
            if (this.animateSummonTick >= 60) {
                this.animateSummonTick = 0;
                this.setSummonState(false);
                this.setStartSummonState(false);
            }
        } else if (((Boolean)this.f_19804_.m_135370_(ILLUSION)).booleanValue()) {
            ++this.animateIllusionTick;
            if (this.animateIllusionTick == 30) {
                this.illusion();
            }
            if (this.animateIllusionTick >= 60) {
                this.animateIllusionTick = 0;
                this.f_19804_.m_135381_(ILLUSION, (Object)false);
                this.f_19804_.m_135381_(START_ILLUSION, (Object)false);
            }
        }
        Predicate<LivingEntity> ENEMY_SELECTOR = p_31504_ -> p_31504_ instanceof Player && p_31504_.m_5789_();
        TargetingConditions TARGETING_CONDITIONS = TargetingConditions.m_148352_().m_26883_(20.0).m_26888_(ENEMY_SELECTOR);
        this.enemyList = this.m_9236_().m_45971_(LivingEntity.class, TARGETING_CONDITIONS, (LivingEntity)this, this.m_20191_().m_82377_(20.0, 8.0, 20.0));
        if (!this.enemyList.isEmpty()) {
            ++this.tick;
            if (this.tick % 500 == 0) {
                this.aiState = AiState.SUMMONING;
                this.setStartSummonState(true);
                this.setSummonState(true);
            }
            if (this.tick % 900 == 0) {
                this.aiState = AiState.ILLUSION;
                this.f_19804_.m_135381_(ILLUSION, (Object)true);
                this.f_19804_.m_135381_(START_ILLUSION, (Object)true);
            }
        }
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    private void illusion() {
        int numOfFalseKings = 5;
        int radius = 7;
        for (int i = 1; i <= numOfFalseKings; ++i) {
            double pointX = this.m_20182_().f_82479_ + (double)radius * Math.cos((float)(360 * i) / (float)numOfFalseKings);
            double pointZ = this.m_20182_().f_82481_ - (double)radius * Math.sin((float)(360 * i) / (float)numOfFalseKings);
            FalseKingEntity falseKing = new FalseKingEntity((EntityType<? extends Monster>)((EntityType)ModEntities.FALSE_KING.get()), this.m_9236_());
            falseKing.m_20219_(new Vec3(pointX, this.m_20182_().f_82480_, pointZ));
            this.m_9236_().m_7967_((Entity)falseKing);
        }
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        this.bossEvent.m_6543_(pPlayer);
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossEvent.m_6539_(pPlayer);
    }

    public void summon() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.enemyList.isEmpty()) {
                LivingEntity target = this.enemyList.get(0);
                this.spawnVanguards(target.m_20182_(), this.m_20182_());
            }
        }
    }

    private void spawnVanguards(Vec3 targetPos, Vec3 nameless_one_pos) {
        ArrayList<Vec2> displacementPositions = new ArrayList<Vec2>();
        displacementPositions.add(new Vec2(-2.0f, 2.0f));
        displacementPositions.add(new Vec2(-1.0f, 2.0f));
        displacementPositions.add(new Vec2(0.0f, 2.0f));
        displacementPositions.add(new Vec2(1.0f, 2.0f));
        displacementPositions.add(new Vec2(2.0f, 2.0f));
        for (Vec2 pos : displacementPositions) {
            Vec2 wallPos = NamelessOneEntity.vanguardPosition(targetPos, nameless_one_pos, pos);
            BlockPos blockPos = new BlockPos((int)wallPos.f_82470_, (int)targetPos.f_82480_, (int)wallPos.f_82471_);
            while (this.m_9236_().m_8055_(blockPos.m_6625_(1)).m_60795_() || this.m_9236_().m_8055_(blockPos.m_6625_(1)).m_60734_() == Blocks.f_50034_ || this.m_9236_().m_8055_(blockPos.m_6625_(1)).m_60734_() == Blocks.f_50359_) {
                blockPos = blockPos.m_6625_(1);
            }
            while (!this.m_9236_().m_8055_(blockPos).m_60795_() && this.m_9236_().m_8055_(blockPos).m_60734_() != Blocks.f_50034_ && this.m_9236_().m_8055_(blockPos).m_60734_() != Blocks.f_50359_) {
                blockPos = blockPos.m_6630_(1);
            }
            VanguardEntity newVanguard = new VanguardEntity(this.m_9236_());
            newVanguard.m_6034_(blockPos.m_252807_().f_82479_, blockPos.m_252807_().f_82480_, blockPos.m_252807_().f_82481_);
            this.m_9236_().m_7967_((Entity)newVanguard);
        }
    }

    private static Vec2 vanguardPosition(Vec3 targetPos, Vec3 nameless_one_pos, Vec2 displacementPos) {
        Vec2 direction = new Vec2((float)targetPos.f_82479_, (float)targetPos.f_82481_).m_165910_(new Vec2((float)nameless_one_pos.f_82479_, (float)nameless_one_pos.f_82481_).m_165913_());
        double angle = Math.atan2(direction.f_82470_, direction.f_82471_);
        double displacementAngle = Math.atan2(displacementPos.f_82470_, displacementPos.f_82471_) * 180.0 / Math.PI;
        double dirAngle = Math.atan2(direction.f_82470_, direction.f_82471_) * 180.0 / Math.PI;
        double finalAngle = dirAngle + displacementAngle;
        double dist = Math.sqrt(Math.pow(displacementPos.f_82470_, 2.0) + Math.pow(displacementPos.f_82471_, 2.0));
        float x = (float)(dist * Math.cos(finalAngle * Math.PI / 180.0));
        float y = (float)(dist * Math.sin(finalAngle * Math.PI / 180.0));
        return new Vec2((float)((double)x + nameless_one_pos.f_82479_), (float)((double)y + nameless_one_pos.f_82481_));
    }

    public void setSummonState(boolean state) {
        this.f_19804_.m_135381_(SUMMON, (Object)state);
    }

    public boolean getSummonState() {
        return (Boolean)this.f_19804_.m_135370_(SUMMON);
    }

    public void setStartSummonState(boolean state) {
        this.f_19804_.m_135381_(START_SUMMON, (Object)state);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (state) {
                serverLevel.m_247517_(null, this.m_20183_(), (SoundEvent)ModSoundEvents.NECROMANCER_PREPARE_SUMMON.get(), SoundSource.HOSTILE);
            }
        }
    }

    public boolean getStartSummonState() {
        return (Boolean)this.f_19804_.m_135370_(START_SUMMON);
    }

    public void setHurt(boolean state) {
        this.f_19804_.m_135381_(HURT, (Object)state);
    }

    public boolean getHurt() {
        return (Boolean)this.f_19804_.m_135370_(HURT);
    }

    public void setStartHurt(boolean state) {
        this.f_19804_.m_135381_(START_HURT, (Object)state);
    }

    public boolean getStartHurt() {
        return (Boolean)this.f_19804_.m_135370_(START_HURT);
    }

    public void setStartAttack(boolean state) {
        this.f_19804_.m_135381_(START_ATTACK, (Object)state);
    }

    public boolean getStartAttack() {
        return (Boolean)this.f_19804_.m_135370_(START_ATTACK);
    }

    public void setAttack(boolean state) {
        this.f_19804_.m_135381_(ATTACK, (Object)state);
    }

    public boolean getAttack() {
        return (Boolean)this.f_19804_.m_135370_(ATTACK);
    }

    public static enum AiState {
        ATTACKING,
        ILLUSION,
        SUMMONING;

    }
}

