/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyseq.DungeonsWeaponry.entity.custom;

import com.jeremyseq.DungeonsWeaponry.items.DungeonsWeapon;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class LootPigEntity
extends Animal
implements GeoEntity {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public final int SIGHT_RANGE = 8;
    public static final int CALM_DOWN_TIME = 40;
    private int calm_down_timer;
    public static final EntityDataAccessor<Boolean> ALERTED = SynchedEntityData.m_135353_(LootPigEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> ALERTED_ANIM = SynchedEntityData.m_135353_(LootPigEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> START_ALERTED_ANIM = SynchedEntityData.m_135353_(LootPigEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public LootPigEntity(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22283_, 2.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @NotNull
    protected PathNavigation m_6037_(Level pLevel) {
        GroundPathNavigation groundPathNavigation = new GroundPathNavigation((Mob)this, pLevel);
        groundPathNavigation.m_26477_(false);
        groundPathNavigation.m_7008_(false);
        groundPathNavigation.m_148214_(true);
        return groundPathNavigation;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        if (this.getAlertedAnim()) {
            if (this.getStartAlertedAnim()) {
                tAnimationState.getController().forceAnimationReset();
                this.setStartAlertedAnim(false);
            }
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.loot_pig.alerted", Animation.LoopType.PLAY_ONCE));
            if (tAnimationState.getController().hasAnimationFinished()) {
                this.setAlertedAnim(false);
            }
            return PlayState.CONTINUE;
        }
        if (tAnimationState.isMoving()) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.loot_pig.walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.loot_pig.idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void m_8107_() {
        Predicate<LivingEntity> PLAYER_SELECTOR = p_31504_ -> p_31504_ instanceof Player;
        TargetingConditions TARGETING_CONDITIONS = TargetingConditions.m_148353_().m_26883_(8.0).m_26888_(PLAYER_SELECTOR);
        List playerList = this.m_9236_().m_45971_(LivingEntity.class, TARGETING_CONDITIONS, (LivingEntity)this, this.m_20191_().m_82377_(8.0, 8.0, 8.0));
        if (!playerList.isEmpty() && !this.getAlerted()) {
            this.setAlerted(true);
            this.setAlertedAnim(true);
            this.setStartAlertedAnim(true);
        }
        if (playerList.isEmpty() && this.getAlerted()) {
            if (this.calm_down_timer <= 0) {
                this.calm_down_timer = 40;
            }
            if (this.calm_down_timer == 1) {
                this.setAlerted(false);
                this.calm_down_timer = 0;
            } else {
                --this.calm_down_timer;
            }
        }
        if (this.getAlerted() && !playerList.isEmpty()) {
            Vec3 pos = LootPigEntity.calculateNewPosition(this.m_20182_(), ((LivingEntity)playerList.get(0)).m_20182_(), 10.0);
            this.f_21344_.m_26519_(pos.f_82479_, pos.f_82480_, pos.f_82481_, 1.5);
        }
        super.m_8107_();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ALERTED, (Object)false);
        this.f_19804_.m_135372_(ALERTED_ANIM, (Object)false);
        this.f_19804_.m_135372_(START_ALERTED_ANIM, (Object)false);
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        ItemStack item = DungeonsWeapon.getWeaponDrop();
        this.m_19983_(item);
        int emeralds = new Random().nextInt(30, 100);
        this.m_19983_(new ItemStack((ItemLike)Items.f_42616_, emeralds));
        super.m_7472_(pSource, pLooting, pRecentlyHit);
    }

    public static Vec3 calculateNewPosition(Vec3 loot_pig_pos, Vec3 player_pos, double desiredDistance) {
        double distance = loot_pig_pos.m_82554_(player_pos);
        double directionX = (loot_pig_pos.f_82479_ - player_pos.f_82479_) / distance;
        double directionY = (loot_pig_pos.f_82480_ - player_pos.f_82480_) / distance;
        double newX = loot_pig_pos.f_82479_ + directionX * desiredDistance;
        double newY = loot_pig_pos.f_82480_ + directionY * desiredDistance;
        return new Vec3((double)((int)newX), (double)((int)newY), loot_pig_pos.f_82481_);
    }

    public void setAlerted(boolean state) {
        this.f_19804_.m_135381_(ALERTED, (Object)state);
    }

    public boolean getAlerted() {
        return (Boolean)this.f_19804_.m_135370_(ALERTED);
    }

    public void setAlertedAnim(boolean state) {
        this.f_19804_.m_135381_(ALERTED_ANIM, (Object)state);
    }

    public boolean getAlertedAnim() {
        return (Boolean)this.f_19804_.m_135370_(ALERTED_ANIM);
    }

    public void setStartAlertedAnim(boolean state) {
        this.f_19804_.m_135381_(START_ALERTED_ANIM, (Object)state);
    }

    public boolean getStartAlertedAnim() {
        return (Boolean)this.f_19804_.m_135370_(START_ALERTED_ANIM);
    }
}

