/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyseq.DungeonsWeaponry.entity.custom;

import com.jeremyseq.DungeonsWeaponry.block.GeomancerBomb;
import com.jeremyseq.DungeonsWeaponry.block.ModBlocks;
import com.jeremyseq.DungeonsWeaponry.entity.EntityUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class GeomancerEntity
extends Monster
implements GeoEntity {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private int aiTick = 0;
    public static final EntityDataAccessor<Boolean> WALL_ANIM = SynchedEntityData.m_135353_(GeomancerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> START_WALL_ANIM = SynchedEntityData.m_135353_(GeomancerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> BOMB_ANIM = SynchedEntityData.m_135353_(GeomancerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> START_BOMB_ANIM = SynchedEntityData.m_135353_(GeomancerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public GeomancerEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 35.0).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    @NotNull
    protected PathNavigation m_6037_(Level pLevel) {
        GroundPathNavigation groundPathNavigation = new GroundPathNavigation((Mob)this, pLevel);
        groundPathNavigation.m_26477_(false);
        groundPathNavigation.m_7008_(false);
        groundPathNavigation.m_148214_(true);
        return groundPathNavigation;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        if (((Boolean)this.f_19804_.m_135370_(BOMB_ANIM)).booleanValue()) {
            if (((Boolean)this.f_19804_.m_135370_(START_BOMB_ANIM)).booleanValue()) {
                tAnimationState.getController().forceAnimationReset();
                this.f_19804_.m_135381_(START_BOMB_ANIM, (Object)false);
            }
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.geomancer.bomb", Animation.LoopType.PLAY_ONCE));
            if (tAnimationState.getController().hasAnimationFinished()) {
                this.f_19804_.m_135381_(BOMB_ANIM, (Object)false);
            }
            return PlayState.CONTINUE;
        }
        if (((Boolean)this.f_19804_.m_135370_(WALL_ANIM)).booleanValue()) {
            if (((Boolean)this.f_19804_.m_135370_(START_WALL_ANIM)).booleanValue()) {
                tAnimationState.getController().forceAnimationReset();
                this.f_19804_.m_135381_(START_WALL_ANIM, (Object)false);
            }
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.geomancer.wall", Animation.LoopType.PLAY_ONCE));
            if (tAnimationState.getController().hasAnimationFinished()) {
                this.f_19804_.m_135381_(WALL_ANIM, (Object)false);
            }
            return PlayState.CONTINUE;
        }
        if (tAnimationState.isMoving()) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.geomancer.walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.geomancer.idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_8107_() {
        ++this.aiTick;
        Predicate<LivingEntity> ENEMY_SELECTOR = p_31504_ -> p_31504_ instanceof Player;
        TargetingConditions TARGETING_CONDITIONS = TargetingConditions.m_148352_().m_26883_(25.0).m_26888_(ENEMY_SELECTOR);
        List targets = this.m_9236_().m_45971_(LivingEntity.class, TARGETING_CONDITIONS, (LivingEntity)this, this.m_20191_().m_82377_(25.0, 25.0, 25.0));
        if (!targets.isEmpty()) {
            LivingEntity target = (LivingEntity)targets.get(0);
            double desiredDistance = 15.0;
            double distance = GeomancerEntity.calculateDistance(this.m_20185_(), this.m_20186_(), this.m_20189_(), target.m_20185_(), target.m_20186_(), target.m_20189_());
            if (distance <= desiredDistance) {
                int spawnBombInterval;
                int spawnWallInterval = 130;
                if (this.aiTick % spawnWallInterval == 0) {
                    this.f_19804_.m_135381_(START_WALL_ANIM, (Object)true);
                    this.f_19804_.m_135381_(WALL_ANIM, (Object)true);
                    if (this.m_9236_() instanceof ServerLevel) {
                        this.spawnGeomancerWalls(target.m_20182_(), this.m_20182_());
                    }
                }
                if (this.aiTick % (spawnBombInterval = 100) == 0) {
                    this.f_19804_.m_135381_(START_BOMB_ANIM, (Object)true);
                    this.f_19804_.m_135381_(BOMB_ANIM, (Object)true);
                    if (this.m_9236_() instanceof ServerLevel) {
                        this.spawnGeomancerBomb(target.m_20182_());
                    }
                }
                if (distance <= 5.0) {
                    Vec3 fleePos = GeomancerEntity.calculateFleePosition(this.m_20182_(), target.m_20182_(), 5.0);
                    this.f_21344_.m_26519_(fleePos.f_82479_, fleePos.f_82480_, fleePos.f_82481_, 1.0);
                }
            } else {
                Vec3 newPosition = GeomancerEntity.calculateNewPosition(this.m_20185_(), this.m_20186_(), this.m_20189_(), target.m_20185_(), target.m_20186_(), target.m_20189_(), desiredDistance);
                this.f_21344_.m_26519_(newPosition.f_82479_, newPosition.f_82480_, newPosition.f_82481_, 1.0);
            }
        }
        super.m_8107_();
    }

    private void spawnGeomancerBomb(Vec3 targetPos) {
        BlockPos randomPos = this.randomBlockPosWithinDist(targetPos, 5.0f);
        if (randomPos != null) {
            this.m_9236_().m_7731_(randomPos, (BlockState)((Block)ModBlocks.GEOMANCER_BOMB.get()).m_49966_().m_61124_((Property)GeomancerBomb.DAMAGE, (Comparable)Integer.valueOf((int)this.m_21133_(Attributes.f_22281_))), 2);
        }
    }

    private BlockPos randomBlockPosWithinDist(Vec3 origin, float max_dist) {
        return this.randomBlockPosWithinDist(origin, max_dist, 0);
    }

    private BlockPos randomBlockPosWithinDist(Vec3 origin, float max_dist, int call_number) {
        if (call_number > 10) {
            return null;
        }
        double theta = new Random().nextFloat(0.0f, (float)Math.PI * 2);
        double distance = new Random().nextFloat(0.0f, max_dist);
        double dx = distance * Math.cos(theta);
        double dy = distance * Math.sin(theta);
        double new_x = origin.f_82479_ + dx;
        double new_y = origin.f_82481_ + dy;
        BlockPos blockPos = new BlockPos((int)new_x, (int)origin.f_82480_, (int)new_y);
        if ((blockPos = this.adjustYLevelToGround(blockPos)) == null || Math.abs((double)blockPos.m_123342_() - origin.f_82480_) >= 3.0) {
            return this.randomBlockPosWithinDist(origin, max_dist, call_number + 1);
        }
        return blockPos;
    }

    private void spawnGeomancerWalls(Vec3 targetPos, Vec3 geomancerPos) {
        ArrayList<Vec2> displacementPositions = new ArrayList<Vec2>();
        displacementPositions.add(new Vec2(0.0f, 2.0f));
        displacementPositions.add(new Vec2(1.0f, 2.0f));
        displacementPositions.add(new Vec2(2.0f, 2.0f));
        displacementPositions.add(new Vec2(3.0f, 2.0f));
        displacementPositions.add(new Vec2(3.0f, 1.0f));
        displacementPositions.add(new Vec2(3.0f, 0.0f));
        displacementPositions.add(new Vec2(-1.0f, 2.0f));
        displacementPositions.add(new Vec2(-2.0f, 2.0f));
        displacementPositions.add(new Vec2(-3.0f, 2.0f));
        displacementPositions.add(new Vec2(-3.0f, 1.0f));
        displacementPositions.add(new Vec2(-3.0f, 0.0f));
        for (Vec2 pos : displacementPositions) {
            Vec2 wallPos = GeomancerEntity.geomancerWallPosition(targetPos, geomancerPos, pos);
            BlockPos blockPos = new BlockPos((int)wallPos.f_82470_, (int)targetPos.f_82480_, (int)wallPos.f_82471_);
            if ((blockPos = this.adjustYLevelToGround(blockPos)) == null) continue;
            this.m_9236_().m_7731_(blockPos, ((Block)ModBlocks.GEOMANCER_WALL.get()).m_49966_(), 2);
        }
    }

    private BlockPos adjustYLevelToGround(BlockPos blockPos) {
        SnowLayerBlock snowLayerBlock;
        boolean snowBlock = false;
        Block block = this.m_9236_().m_8055_(blockPos.m_6625_(1)).m_60734_();
        if (block instanceof SnowLayerBlock) {
            SnowLayerBlock snowLayerBlock2 = (SnowLayerBlock)block;
            if ((Integer)this.m_9236_().m_8055_(blockPos.m_6625_(1)).m_61143_((Property)SnowLayerBlock.f_56581_) < 8) {
                snowBlock = true;
            }
        }
        int number = 0;
        while (this.m_9236_().m_8055_(blockPos.m_6625_(1)).m_60795_() || this.m_9236_().m_8055_(blockPos.m_6625_(1)).m_60734_() == Blocks.f_50034_ || this.m_9236_().m_8055_(blockPos.m_6625_(1)).m_60734_() == Blocks.f_50359_ || snowBlock) {
            blockPos = blockPos.m_6625_(1);
            if (++number > 10) {
                return null;
            }
            Block block2 = this.m_9236_().m_8055_(blockPos.m_6625_(1)).m_60734_();
            if (block2 instanceof SnowLayerBlock) {
                SnowLayerBlock snowLayerBlock3 = (SnowLayerBlock)block2;
                if ((Integer)this.m_9236_().m_8055_(blockPos.m_6625_(1)).m_61143_((Property)SnowLayerBlock.f_56581_) >= 8) continue;
                snowBlock = true;
                continue;
            }
            snowBlock = false;
        }
        boolean snowBlock1 = false;
        Block block3 = this.m_9236_().m_8055_(blockPos).m_60734_();
        if (block3 instanceof SnowLayerBlock) {
            snowLayerBlock = (SnowLayerBlock)block3;
            if ((Integer)this.m_9236_().m_8055_(blockPos).m_61143_((Property)SnowLayerBlock.f_56581_) < 8) {
                snowBlock1 = true;
            }
        }
        number = 0;
        while (!this.m_9236_().m_8055_(blockPos).m_60795_() && this.m_9236_().m_8055_(blockPos).m_60734_() != Blocks.f_50034_ && this.m_9236_().m_8055_(blockPos).m_60734_() != Blocks.f_50359_ && !snowBlock1) {
            blockPos = blockPos.m_6630_(1);
            if (++number > 10) {
                return null;
            }
            block3 = this.m_9236_().m_8055_(blockPos).m_60734_();
            if (block3 instanceof SnowLayerBlock) {
                snowLayerBlock = (SnowLayerBlock)block3;
                if ((Integer)this.m_9236_().m_8055_(blockPos).m_61143_((Property)SnowLayerBlock.f_56581_) >= 8) continue;
                snowBlock1 = true;
                continue;
            }
            snowBlock1 = false;
        }
        return blockPos;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(WALL_ANIM, (Object)false);
        this.f_19804_.m_135372_(START_WALL_ANIM, (Object)false);
        this.f_19804_.m_135372_(BOMB_ANIM, (Object)false);
        this.f_19804_.m_135372_(START_BOMB_ANIM, (Object)false);
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12310_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12309_;
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        EntityUtil.spawnWeaponLoot((Mob)this, 30, pLooting);
        EntityUtil.spawnEmeraldLoot((Mob)this, 0, 3, pLooting);
    }

    private static Vec2 geomancerWallPosition(Vec3 targetPos, Vec3 geomancerPos, Vec2 displacementPos) {
        Vec2 direction = new Vec2((float)geomancerPos.f_82479_, (float)geomancerPos.f_82481_).m_165910_(new Vec2((float)targetPos.f_82479_, (float)targetPos.f_82481_).m_165913_());
        double angle = Math.atan2(direction.f_82470_, direction.f_82471_);
        double octant = Math.round(4.0 * angle / (Math.PI * 2) + 4.0) % 4L;
        if (octant == 0.0) {
            direction = new Vec2(0.0f, 1.0f);
        } else if (octant == 1.0) {
            direction = new Vec2(1.0f, 0.0f);
        } else if (octant == 2.0) {
            direction = new Vec2(0.0f, -1.0f);
        } else if (octant == 3.0) {
            direction = new Vec2(-1.0f, 0.0f);
        }
        double displacementAngle = Math.atan2(displacementPos.f_82470_, displacementPos.f_82471_) * 180.0 / Math.PI;
        double dirAngle = Math.atan2(direction.f_82470_, direction.f_82471_) * 180.0 / Math.PI;
        double finalAngle = dirAngle + displacementAngle;
        double dist = Math.sqrt(Math.pow(displacementPos.f_82470_, 2.0) + Math.pow(displacementPos.f_82471_, 2.0));
        float x = (float)(dist * Math.cos(finalAngle * Math.PI / 180.0));
        float y = (float)(dist * Math.sin(finalAngle * Math.PI / 180.0));
        return new Vec2((float)((double)x + targetPos.f_82479_), (float)((double)y + targetPos.f_82481_));
    }

    private static Vec3 calculateNewPosition(double x1, double y1, double z1, double x2, double y2, double z2, double desiredDistance) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double scale = desiredDistance / distance;
        double newX = x2 + dx * scale;
        double newY = y2 + dy * scale;
        double newZ = z2 + dz * scale;
        return new Vec3(newX, newY, newZ);
    }

    public static Vec3 calculateFleePosition(Vec3 geomancer_pos, Vec3 target_pos, double desiredDistance) {
        double distance = geomancer_pos.m_82554_(target_pos);
        double directionX = (geomancer_pos.f_82479_ - target_pos.f_82479_) / distance;
        double directionY = (geomancer_pos.f_82480_ - target_pos.f_82480_) / distance;
        double newX = geomancer_pos.f_82479_ + directionX * desiredDistance;
        double newY = geomancer_pos.f_82480_ + directionY * desiredDistance;
        return new Vec3((double)((int)newX), (double)((int)newY), geomancer_pos.f_82481_);
    }

    private static double calculateDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }
}

