/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyseq.DungeonsWeaponry.entity.custom;

import com.jeremyseq.DungeonsWeaponry.entity.EntityUtil;
import com.jeremyseq.DungeonsWeaponry.network.PacketHandler;
import com.jeremyseq.DungeonsWeaponry.network.S2CPackets.PlayEnchanterAttackAnimS2CPacket;
import com.jeremyseq.DungeonsWeaponry.util.ModSoundEvents;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class EnchanterEntity
extends Monster
implements GeoEntity {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public static final int ENCHANT_DISTANCE = 8;
    public static final EntityDataAccessor<Boolean> ENCHANT = SynchedEntityData.m_135353_(EnchanterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> START_ENCHANT = SynchedEntityData.m_135353_(EnchanterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> ATTACK = SynchedEntityData.m_135353_(EnchanterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> START_ATTACK = SynchedEntityData.m_135353_(EnchanterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private List<LivingEntity> enchantList;

    public EnchanterEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    @NotNull
    protected PathNavigation m_6037_(Level pLevel) {
        GroundPathNavigation groundPathNavigation = new GroundPathNavigation((Mob)this, pLevel);
        groundPathNavigation.m_26477_(false);
        groundPathNavigation.m_7008_(false);
        groundPathNavigation.m_148214_(true);
        return groundPathNavigation;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        if (this.getAttack()) {
            if (this.getStartAttack()) {
                tAnimationState.getController().forceAnimationReset();
                this.setStartAttack(false);
            }
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.enchanter.attack", Animation.LoopType.PLAY_ONCE));
            if (tAnimationState.getController().hasAnimationFinished()) {
                this.setAttack(false);
            }
            return PlayState.CONTINUE;
        }
        if (this.getEnchant()) {
            if (this.getStartEnchant()) {
                tAnimationState.getController().forceAnimationReset();
                this.setStartEnchant(false);
            }
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.enchanter.enchant", Animation.LoopType.PLAY_ONCE));
            if (tAnimationState.getController().hasAnimationFinished()) {
                this.setEnchant(false);
            }
            return PlayState.CONTINUE;
        }
        if (tAnimationState.isMoving()) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.enchanter.walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.enchanter.idle.breathing", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_8107_() {
        Predicate<LivingEntity> ENEMY_SELECTOR = p_31504_ -> p_31504_ instanceof Monster && !(p_31504_ instanceof EnchanterEntity);
        TargetingConditions TARGETING_CONDITIONS = TargetingConditions.m_148353_().m_26883_(8.0).m_26888_(ENEMY_SELECTOR);
        List newEnchantList = this.m_9236_().m_45971_(LivingEntity.class, TARGETING_CONDITIONS, (LivingEntity)this, this.m_20191_().m_82377_(8.0, 8.0, 8.0));
        if (newEnchantList.size() > 2) {
            newEnchantList = newEnchantList.subList(0, 2);
        }
        for (LivingEntity entity : newEnchantList) {
            if (this.enchantList == null || !this.enchantList.contains(entity)) {
                this.setEnchant(true);
                this.setStartEnchant(true);
                this.m_216990_((SoundEvent)ModSoundEvents.ENCHANTER_ENCHANT.get());
            }
            EnchanterEntity.beam(new BlockPos(entity.m_146903_(), entity.m_146904_() + 1, entity.m_146907_()), new BlockPos(this.m_146903_(), this.m_146904_() + 1, this.m_146907_()), this.m_9236_());
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 20, 1));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 20, 1));
        }
        this.enchantList = newEnchantList;
        if (!this.enchantList.isEmpty()) {
            LivingEntity entity = this.enchantList.get(0);
            double desiredDistance = 4.0;
            double distance = EnchanterEntity.calculateDistance(this.m_20185_(), this.m_20186_(), this.m_20189_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            if (!(distance <= desiredDistance)) {
                Vec3 newPosition = EnchanterEntity.calculateNewPosition(this.m_20185_(), this.m_20186_(), this.m_20189_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), desiredDistance);
                this.f_21344_.m_26519_(newPosition.f_82479_, newPosition.f_82480_, newPosition.f_82481_, 1.0);
            }
        }
        if (this.enchantList.isEmpty() && this.m_5448_() != null) {
            this.f_21344_.m_5624_((Entity)this.m_5448_(), 1.0);
        }
        if (this.m_5448_() != null && this.m_20270_((Entity)this.m_5448_()) <= 2.0f) {
            if (!this.getAttack()) {
                this.setAttack(true);
                this.setStartAttack(true);
                List nearbyEntities = this.m_9236_().m_45971_(Player.class, TargetingConditions.f_26872_, (LivingEntity)this, this.m_20191_().m_82377_(40.0, 40.0, 40.0));
                for (Player player : nearbyEntities) {
                    PacketHandler.sendToPlayer(new PlayEnchanterAttackAnimS2CPacket(this.m_19879_()), (ServerPlayer)player);
                }
            }
            this.m_5448_().m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21051_(Attributes.f_22281_).m_22115_());
        }
        super.m_8107_();
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        EntityUtil.spawnWeaponLoot((Mob)this, 40, pLooting);
        EntityUtil.spawnEmeraldLoot((Mob)this, 0, 2, pLooting);
    }

    private static Vec3 calculateNewPosition(double x1, double y1, double z1, double x2, double y2, double z2, double desiredDistance) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double scale = desiredDistance / distance;
        double newX = x2 + dx * scale;
        double newY = y2 + dy * scale;
        double newZ = z2 + dz * scale;
        return new Vec3(newX, newY, newZ);
    }

    private static double calculateDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ENCHANT, (Object)false);
        this.f_19804_.m_135372_(START_ENCHANT, (Object)false);
        this.f_19804_.m_135372_(ATTACK, (Object)false);
        this.f_19804_.m_135372_(START_ATTACK, (Object)false);
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.ENCHANTER_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSoundEvents.ENCHANTER_HURT.get();
    }

    public void setEnchant(boolean state) {
        this.f_19804_.m_135381_(ENCHANT, (Object)state);
    }

    public boolean getEnchant() {
        return (Boolean)this.f_19804_.m_135370_(ENCHANT);
    }

    public void setStartEnchant(boolean state) {
        this.f_19804_.m_135381_(START_ENCHANT, (Object)state);
    }

    public boolean getStartEnchant() {
        return (Boolean)this.f_19804_.m_135370_(START_ENCHANT);
    }

    public void setStartAttack(boolean state) {
        this.f_19804_.m_135381_(START_ATTACK, (Object)state);
    }

    public boolean getStartAttack() {
        return (Boolean)this.f_19804_.m_135370_(START_ATTACK);
    }

    public void setAttack(boolean state) {
        this.f_19804_.m_135381_(ATTACK, (Object)state);
    }

    public boolean getAttack() {
        return (Boolean)this.f_19804_.m_135370_(ATTACK);
    }

    public static void beam(BlockPos toThisBlock, BlockPos fromThisBlock, Level world) {
        double x2 = EnchanterEntity.getCenterOfBlock(toThisBlock.m_123341_());
        double z2 = EnchanterEntity.getCenterOfBlock(toThisBlock.m_123343_());
        double y2 = EnchanterEntity.getCenterOfBlock(toThisBlock.m_123342_());
        double x1 = EnchanterEntity.getCenterOfBlock(fromThisBlock.m_123341_());
        double z1 = EnchanterEntity.getCenterOfBlock(fromThisBlock.m_123343_());
        double y1 = EnchanterEntity.getCenterOfBlock(fromThisBlock.m_123342_());
        double d5 = 1.2;
        double d0 = x2 - x1;
        double d1 = y2 - y1;
        double d2 = z2 - z1;
        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
        d0 /= d3;
        d1 /= d3;
        d2 /= d3;
        double d4 = new Random().nextDouble();
        while (d4 + 0.65 < d3) {
            d4 += 1.8 - d5 + new Random().nextDouble() * (1.5 - d5);
            if (world.f_46443_) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123809_, x1 + d0 * d4, y1 + d1 * d4, z1 + d2 * d4, 0.0, 0.0, 0.0);
            }
            DustParticleOptions dustParticleOptions = new DustParticleOptions(new Vector3f(226.0f, 17.0f, 236.0f).normalize(), 1.0f);
            world.m_7106_((ParticleOptions)dustParticleOptions, x1 + d0 * d4, y1 + d1 * d4, z1 + d2 * d4, 0.0, 0.0, 0.0);
        }
    }

    public static double getCenterOfBlock(int a) {
        return (double)a + 0.5;
    }
}

