/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyseq.DungeonsWeaponry.entity.client;

import com.jeremyseq.DungeonsWeaponry.entity.custom.NamelessOneEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class NamelessOneModel
extends GeoModel<NamelessOneEntity> {
    private int callCountX = 0;
    private int callCountY = 0;
    private int callCount = 0;
    private static final int MAX_CALLS = 180;
    private static final int OFFSET = 2;

    public ResourceLocation getModelResource(NamelessOneEntity animatable) {
        return new ResourceLocation("dungeonsweaponry", "geo/nameless_one.geo.json");
    }

    public ResourceLocation getTextureResource(NamelessOneEntity animatable) {
        return new ResourceLocation("dungeonsweaponry", "textures/entity/nameless_one.png");
    }

    public ResourceLocation getAnimationResource(NamelessOneEntity animatable) {
        return new ResourceLocation("dungeonsweaponry", "animations/nameless_one.animation.json");
    }

    public void setCustomAnimations(NamelessOneEntity animatable, long instanceId, AnimationState<NamelessOneEntity> animationState) {
        CoreGeoBone outside_cube;
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        if (head != null && !animatable.getSummonState() && !animatable.getHurt()) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(-entityData.headPitch() * ((float)Math.PI / 180));
            head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
        }
        if ((outside_cube = this.getAnimationProcessor().getBone("staff_cube_outside")) != null) {
            double num = this.lerpFromZeroTo180();
            outside_cube.setRotX((float)(num * 0.01745329238474369));
            outside_cube.setRotY((float)(num * 0.01745329238474369));
        }
    }

    public double oscillatingX() {
        double angle = Math.toRadians(180.0 * (1.0 + Math.sin(Math.PI * 2 * (double)this.callCountX / 180.0)));
        ++this.callCountX;
        return Math.toDegrees(angle);
    }

    public double oscillatingY() {
        double angle = Math.toRadians(180.0 * (1.0 + Math.sin(Math.PI * 2 * (double)(this.callCountY + 2) / 180.0)));
        ++this.callCountY;
        return Math.toDegrees(angle);
    }

    public double lerpFromZeroTo180() {
        double lerpValue = (double)this.callCount / 180.0;
        double value = 180.0 * lerpValue;
        this.callCount = (this.callCount + 1) % 181;
        return value;
    }
}

