/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyseq.DungeonsWeaponry.block.block_entities;

import com.jeremyseq.DungeonsWeaponry.block.block_entities.ModBlockEntities;
import com.jeremyseq.DungeonsWeaponry.util.ModSoundEvents;
import com.jeremyseq.DungeonsWeaponry.util.ParticleShapes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GeomancerWallEntity
extends BlockEntity
implements GeoBlockEntity {
    private static final int DESPAWN_TIME = 80;
    private int timer = 80;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public GeomancerWallEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.GEOMANCER_WALL_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        if (this.timer <= 20) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.geomancer_wall.down", Animation.LoopType.HOLD_ON_LAST_FRAME));
            return PlayState.CONTINUE;
        }
        tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.geomancer_wall.up", Animation.LoopType.HOLD_ON_LAST_FRAME));
        return PlayState.CONTINUE;
    }

    public void tick() {
        Level level;
        if (this.timer == 80 && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemParticleOption particleOption = new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42329_));
            ParticleShapes.createCircle(serverLevel, 20, this.f_58858_.m_252807_().f_82479_, (double)this.f_58858_.m_123342_(), this.f_58858_.m_252807_().f_82481_, 1, particleOption);
            serverLevel.m_5594_(null, this.f_58858_, (SoundEvent)ModSoundEvents.GEOMANCER_WALL_SPAWN.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        }
        --this.timer;
        if (this.timer <= 0) {
            assert (this.f_58857_ != null);
            this.f_58857_.m_7471_(this.f_58858_, false);
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

