/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyseq.DungeonsWeaponry.block.block_entities;

import com.jeremyseq.DungeonsWeaponry.block.GeomancerBomb;
import com.jeremyseq.DungeonsWeaponry.block.block_entities.ModBlockEntities;
import com.jeremyseq.DungeonsWeaponry.entity.custom.GeomancerEntity;
import com.jeremyseq.DungeonsWeaponry.util.ModSoundEvents;
import com.jeremyseq.DungeonsWeaponry.util.ParticleShapes;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GeomancerBombEntity
extends BlockEntity
implements GeoBlockEntity {
    public static final int DESPAWN_TIME = 80;
    private final float damage;
    private int timer = 80;
    public static final float DAMAGE = 15.0f;
    public static final float BLAST_RADIUS = 5.0f;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public GeomancerBombEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.GEOMANCER_BOMB_BLOCK_ENTITY.get(), pPos, pBlockState);
        this.damage = ((Integer)pBlockState.m_61143_((Property)GeomancerBomb.DAMAGE)).intValue();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.geomancer_wall.up", Animation.LoopType.HOLD_ON_LAST_FRAME));
        return PlayState.CONTINUE;
    }

    public void tick() {
        Level level;
        if (this.timer == 80 && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemParticleOption particleOption = new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42329_));
            ParticleShapes.createCircle(serverLevel, 20, this.f_58858_.m_252807_().f_82479_, (double)this.f_58858_.m_123342_(), this.f_58858_.m_252807_().f_82481_, 1, particleOption);
            serverLevel.m_5594_(null, this.f_58858_, (SoundEvent)ModSoundEvents.GEOMANCER_BOMB_SPAWN.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            serverLevel.m_5594_(null, this.f_58858_, (SoundEvent)ModSoundEvents.GEOMANCER_BOMB_FUSE.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        }
        --this.timer;
        if (this.timer <= 0) {
            assert (this.f_58857_ != null);
            Vec3 center = new Vec3((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_());
            double x = this.f_58858_.m_123341_();
            double y = this.f_58858_.m_123342_();
            double z = this.f_58858_.m_123343_();
            Level level2 = this.f_58857_;
            if (level2 instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level2;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123812_, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
                serverLevel.m_5594_(null, this.f_58858_, SoundEvents.f_11913_, SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            List<Entity> entitiesFound = this.f_58857_.m_6443_(Entity.class, new AABB(center, center).m_82400_(5.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(center))).toList();
            for (Entity entityiterator : entitiesFound) {
                if (!(entityiterator instanceof LivingEntity)) continue;
                LivingEntity _entity = (LivingEntity)entityiterator;
                if (entityiterator instanceof GeomancerEntity) continue;
                _entity.m_6469_(_entity.m_269291_().m_269036_(null, null), this.damage);
            }
            this.f_58857_.m_7471_(this.f_58858_, false);
        }
    }

    public int getTimer() {
        return this.timer;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

