/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.okzoomer.mixin;

import com.matyrobbrt.okzoomer.APIImpl;
import com.matyrobbrt.okzoomer.api.ZoomInstance;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.GameRenderer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GameRenderer.class})
public class GameRendererMixin {
    @Inject(at={@At(value="HEAD")}, method={"tick()V"})
    private void okzoomer$tickInstances(CallbackInfo info) {
        boolean iterateZoom = false;
        boolean iterateTransitions = false;
        boolean iterateModifiers = false;
        boolean iterateOverlays = false;
        for (ZoomInstance instance : APIImpl.getZoomInstances()) {
            boolean zoom = instance.getZoom();
            if (zoom || instance.isTransitionActive() || instance.isOverlayActive()) {
                double divisor;
                double d = divisor = zoom ? instance.getZoomDivisor() : 1.0;
                if (instance.getZoomOverlay() != null) {
                    instance.getZoomOverlay().tick(zoom, divisor, instance.getTransitionMode().getInternalMultiplier());
                }
                instance.getTransitionMode().tick(zoom, divisor);
            }
            iterateZoom = iterateZoom || zoom;
            iterateTransitions = iterateTransitions || instance.isTransitionActive();
            iterateModifiers = iterateModifiers || instance.isModifierActive();
            iterateOverlays = iterateOverlays || instance.isOverlayActive();
        }
        APIImpl.setIterateZoom(iterateZoom);
        APIImpl.setIterateTransitions(iterateTransitions);
        APIImpl.setIterateModifiers(iterateModifiers);
        APIImpl.setIterateOverlays(iterateOverlays);
    }

    @Inject(at={@At(value="RETURN")}, method={"getFov(Lnet/minecraft/client/Camera;FZ)D"}, cancellable=true)
    private void okzoomer$getZoomedFov(Camera camera, float tickDelta, boolean changingFov, CallbackInfoReturnable<Double> cir) {
        double fov;
        double zoomedFov = fov = ((Double)cir.getReturnValue()).doubleValue();
        if (APIImpl.shouldIterateTransitions()) {
            for (ZoomInstance instance : APIImpl.getZoomInstances()) {
                if (!instance.isTransitionActive()) continue;
                zoomedFov = instance.getTransitionMode().applyZoom(zoomedFov, tickDelta);
            }
        }
        if (fov != zoomedFov) {
            cir.setReturnValue((Object)zoomedFov);
        }
    }
}

