/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.client.gui.components;

import com.google.common.collect.Lists;
import fuzs.easyanvils.client.gui.components.TypeActionManager;
import fuzs.easyanvils.util.ComponentDecomposer;
import fuzs.easyanvils.util.FormattedStringDecomposer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class OpenEditBox
extends EditBox {
    private final Font font;
    String value = "";
    private int maxLength = 32;
    private int frame;
    private boolean bordered = true;
    private boolean canLoseFocus = true;
    private boolean isEditable = true;
    private boolean shiftPressed;
    int displayPos;
    int cursorPos;
    int highlightPos;
    private int textColor = 0xE0E0E0;
    private int textColorUneditable = 0x707070;
    @Nullable
    private String suggestion;
    @Nullable
    private Consumer<String> responder;
    private Predicate<String> filter = Objects::nonNull;
    private BiFunction<String, Integer, FormattedCharSequence> formatter = (formatterValue, position) -> {
        ArrayList list = Lists.newArrayList();
        FormattedStringDecomposer.LengthLimitedCharSink sink = new FormattedStringDecomposer.LengthLimitedCharSink(formatterValue.length(), (int)position);
        FormattedStringDecomposer.iterateFormatted(this.value, Style.f_131099_, (index, style, j) -> {
            if (sink.m_6411_(index, style, j)) {
                list.add(formattedCharSink -> formattedCharSink.m_6411_(index, style, j));
            }
            return true;
        });
        return FormattedCharSequence.m_13722_((List)list);
    };
    private long lastClickTime;
    private int lastClickButton;
    private boolean doubleClick;
    public TypeActionManager typeActionManager = new TypeActionManager();

    public OpenEditBox(Font font, int i, int j, int k, int l, Component component) {
        this(font, i, j, k, l, null, component);
    }

    public OpenEditBox(Font font, int i, int j, int k, int l, @Nullable OpenEditBox editBox, Component component) {
        super(font, i, j, k, l, (EditBox)editBox, component);
        this.font = font;
        if (editBox != null) {
            this.m_94144_(editBox.m_94155_());
        }
    }

    public void m_94151_(Consumer<String> responder) {
        this.responder = responder;
    }

    public void m_94149_(BiFunction<String, Integer, FormattedCharSequence> textFormatter) {
        this.formatter = textFormatter;
    }

    public void m_94120_() {
        ++this.frame;
    }

    protected MutableComponent m_5646_() {
        Component component = this.m_6035_();
        return Component.m_237110_((String)"gui.narrate.editBox", (Object[])new Object[]{component, this.value});
    }

    public void m_94144_(String text) {
        if (this.filter.test(text)) {
            int aboveMaxLength = ComponentDecomposer.getStringLength(text) - this.maxLength;
            this.value = aboveMaxLength > 0 ? ComponentDecomposer.removeLast(text, aboveMaxLength) : text;
            this.m_94201_();
            this.m_94208_(this.cursorPos);
            this.m_94174_(text);
        }
    }

    public String m_94155_() {
        return this.value;
    }

    public String m_94173_() {
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        return this.value.substring(i, j);
    }

    public boolean hasHighlighted() {
        return this.highlightPos != this.cursorPos;
    }

    public void m_94153_(Predicate<String> validator) {
        this.filter = validator;
    }

    public void m_94164_(String textToWrite) {
        String string2;
        String string;
        int j;
        int i = Math.min(this.cursorPos, this.highlightPos);
        String string3 = new StringBuilder(this.value).replace(i, j = Math.max(this.cursorPos, this.highlightPos), string = FormattedStringDecomposer.filterText(textToWrite)).toString();
        int stringLength = ComponentDecomposer.getStringLength(string3) - this.maxLength;
        if (stringLength > 0) {
            string = ComponentDecomposer.removeLast(textToWrite, stringLength);
        }
        if (this.filter.test(string2 = new StringBuilder(this.value).replace(i, j, string).toString())) {
            this.value = string2;
            int l = string.length();
            this.m_94196_(i + l);
            this.m_94208_(this.cursorPos);
            this.m_94174_(this.value);
        }
    }

    private void m_94174_(String newText) {
        this.typeActionManager.trySave(this);
        if (this.responder != null) {
            this.responder.accept(newText);
        }
    }

    private void m_94217_(int count) {
        if (Screen.m_96637_()) {
            this.m_94180_(this.cursorPos);
        } else if (Screen.m_96639_()) {
            this.m_94176_(count);
        } else {
            this.m_94180_(count);
        }
    }

    public void m_94176_(int num) {
        if (!this.value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.m_94164_("");
            } else {
                this.m_94180_(this.m_94184_(num) - this.cursorPos);
            }
        }
    }

    public void m_94180_(int num) {
        if (!this.value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.m_94164_("");
            } else {
                String string;
                int k;
                int i = this.m_94220_(num);
                int j = Math.min(i, this.cursorPos);
                if (j != (k = Math.max(i, this.cursorPos)) && this.filter.test(string = new StringBuilder(this.value).delete(j, k).toString())) {
                    this.value = string;
                    this.m_94192_(j);
                }
            }
        }
    }

    public int m_94184_(int numWords) {
        return this.m_94128_(numWords, this.m_94207_());
    }

    private int m_94128_(int n, int pos) {
        return this.m_94140_(n, pos, true);
    }

    private int m_94140_(int n, int pos, boolean skipWs) {
        int i = pos;
        boolean backwards = n < 0;
        int skippedWords = Math.abs(n);
        for (int k = 0; k < skippedWords; ++k) {
            if (!backwards) {
                int l = this.value.length();
                while (skipWs && i == pos && i < l && this.value.charAt(i) == ' ') {
                    ++i;
                    ++pos;
                }
                while (i < l && this.value.charAt(i) != ' ') {
                    ++i;
                }
                continue;
            }
            while (skipWs && i == pos && i > 0 && this.value.charAt(i - 1) == ' ') {
                --i;
                --pos;
            }
            while (i > 0 && this.value.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void m_94188_(int delta) {
        this.m_94192_(this.m_94220_(delta));
    }

    private int m_94220_(int delta) {
        return Util.m_137479_((String)this.value, (int)this.cursorPos, (int)delta);
    }

    public void m_94192_(int pos) {
        this.m_94196_(pos);
        if (!this.shiftPressed) {
            this.m_94208_(this.cursorPos);
        }
        this.m_94174_(this.value);
    }

    public void m_94196_(int pos) {
        this.cursorPos = Mth.m_14045_((int)pos, (int)0, (int)this.value.length());
        this.setDisplayPosition(this.cursorPos);
    }

    public void m_94198_() {
        this.m_94192_(0);
    }

    public void m_94201_() {
        this.m_94192_(this.value.length());
    }

    public static boolean isUndo(int keyCode) {
        return keyCode == 89 && Screen.m_96637_() && !Screen.m_96638_() && !Screen.m_96639_();
    }

    public static boolean isRedo(int keyCode) {
        return keyCode == 89 && Screen.m_96637_() && Screen.m_96638_() && !Screen.m_96639_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.m_94204_()) {
            return false;
        }
        this.shiftPressed = Screen.m_96638_();
        if (Screen.m_96634_((int)keyCode)) {
            this.m_94201_();
            this.m_94208_(0);
            return true;
        }
        if (Screen.m_96632_((int)keyCode)) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.m_94173_());
            return true;
        }
        if (Screen.m_96630_((int)keyCode)) {
            if (this.isEditable) {
                this.m_94164_(Minecraft.m_91087_().f_91068_.m_90876_());
            }
            return true;
        }
        if (Screen.m_96628_((int)keyCode)) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.m_94173_());
            if (this.isEditable) {
                this.m_94164_("");
            }
            return true;
        }
        if (OpenEditBox.isUndo(keyCode)) {
            this.typeActionManager.undo(this);
            return true;
        }
        if (OpenEditBox.isRedo(keyCode)) {
            this.typeActionManager.redo(this);
            return true;
        }
        switch (keyCode) {
            case 259: {
                if (this.isEditable) {
                    this.shiftPressed = false;
                    this.m_94217_(-1);
                    this.shiftPressed = Screen.m_96638_();
                }
                return true;
            }
            default: {
                return false;
            }
            case 261: {
                if (this.isEditable) {
                    this.shiftPressed = false;
                    this.m_94217_(1);
                    this.shiftPressed = Screen.m_96638_();
                }
                return true;
            }
            case 262: {
                boolean canMove = true;
                if (!this.shiftPressed && this.hasHighlighted()) {
                    this.m_94196_(Math.max(this.m_94207_(), this.highlightPos));
                    this.m_94208_(this.m_94207_());
                    canMove = false;
                }
                if (Screen.m_96637_()) {
                    this.m_94201_();
                } else if (Screen.m_96639_()) {
                    this.m_94192_(this.m_94184_(1));
                } else if (canMove) {
                    this.m_94188_(1);
                }
                return true;
            }
            case 263: {
                boolean canMove = true;
                if (!this.shiftPressed && this.hasHighlighted()) {
                    this.m_94196_(Math.min(this.m_94207_(), this.highlightPos));
                    this.m_94208_(this.m_94207_());
                    canMove = false;
                }
                if (Screen.m_96637_()) {
                    this.m_94198_();
                } else if (Screen.m_96639_()) {
                    this.m_94192_(this.m_94184_(-1));
                } else if (canMove) {
                    this.m_94188_(-1);
                }
                return true;
            }
            case 268: {
                this.m_94198_();
                return true;
            }
            case 269: 
        }
        this.m_94201_();
        return true;
    }

    public boolean m_94204_() {
        return this.m_94213_() && this.m_93696_() && this.m_94222_();
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (!this.m_94204_()) {
            return false;
        }
        if (FormattedStringDecomposer.isAllowedChatCharacter(codePoint)) {
            if (this.isEditable) {
                this.m_94164_(Character.toString(codePoint));
            }
            return true;
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean bl;
        if (!this.m_94213_()) {
            return false;
        }
        boolean bl2 = bl = mouseX >= (double)this.m_252754_() && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY >= (double)this.m_252907_() && mouseY < (double)(this.m_252907_() + this.f_93619_);
        if (this.canLoseFocus) {
            this.m_93692_(bl);
        }
        if (this.m_93696_() && bl) {
            if (button == 0) {
                int i = Mth.m_14107_((double)mouseX) - this.m_252754_();
                if (this.bordered) {
                    i -= 4;
                }
                this.shiftPressed = Screen.m_96638_();
                String string = FormattedStringDecomposer.plainHeadByWidth(this.font, this.value, this.displayPos, this.m_94210_(), Style.f_131099_);
                this.m_94192_(FormattedStringDecomposer.plainHeadByWidth(this.font, string, 0, i, Style.f_131099_).length() + this.displayPos);
                long millis = Util.m_137550_();
                boolean tripleClick = this.doubleClick;
                boolean bl3 = this.doubleClick = millis - this.lastClickTime < 250L && this.lastClickButton == button;
                if (tripleClick &= this.doubleClick) {
                    this.m_94201_();
                    this.m_94208_(0);
                } else if (this.doubleClick) {
                    this.shiftPressed = false;
                    this.m_94192_(this.m_94140_(1, this.m_94207_(), false));
                    this.shiftPressed = true;
                    this.m_94192_(this.m_94140_(-1, this.m_94207_(), false));
                    this.shiftPressed = Screen.m_96638_();
                }
                this.lastClickTime = millis;
                this.lastClickButton = button;
                return true;
            }
            if (button == 1) {
                this.m_94144_("");
            }
            return false;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        boolean bl;
        if (!this.m_94213_()) {
            return false;
        }
        boolean bl2 = bl = mouseX >= (double)this.m_252754_() && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY >= (double)this.m_252907_() && mouseY < (double)(this.m_252907_() + this.f_93619_);
        if (this.m_93696_() && bl && button == 0) {
            int i = Mth.m_14107_((double)mouseX) - this.m_252754_();
            if (this.bordered) {
                i -= 4;
            }
            this.shiftPressed = true;
            String string = FormattedStringDecomposer.plainHeadByWidth(this.font, this.value, this.displayPos, this.m_94210_(), Style.f_131099_);
            this.m_94192_(FormattedStringDecomposer.plainHeadByWidth(this.font, string, 0, i, Style.f_131099_).length() + this.displayPos);
            this.shiftPressed = Screen.m_96638_();
            return true;
        }
        return false;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.m_94213_()) {
            int i;
            if (this.m_94219_()) {
                i = this.m_93696_() ? -1 : -6250336;
                guiGraphics.m_280509_(this.m_252754_() - 1, this.m_252907_() - 1, this.m_252754_() + this.f_93618_ + 1, this.m_252907_() + this.f_93619_ + 1, i);
                guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -16777216);
            }
            i = this.isEditable ? this.textColor : this.textColorUneditable;
            int j = this.cursorPos - this.displayPos;
            int k = this.highlightPos - this.displayPos;
            String string = FormattedStringDecomposer.plainHeadByWidth(this.font, this.value, this.displayPos, this.m_94210_(), Style.f_131099_);
            boolean bl = j >= 0 && j <= string.length();
            boolean bl2 = this.m_93696_() && this.frame / 6 % 2 == 0 && bl;
            int l = this.bordered ? this.m_252754_() + 4 : this.m_252754_();
            int m = this.bordered ? this.m_252907_() + (this.f_93619_ - 8) / 2 : this.m_252907_();
            int n = l;
            if (k > string.length()) {
                k = string.length();
            }
            if (!string.isEmpty()) {
                String string2 = bl ? string.substring(0, j) : string;
                n = guiGraphics.m_280648_(this.font, this.formatter.apply(string2, this.displayPos), l, m, i);
            }
            boolean bl3 = this.cursorPos < this.value.length() || ComponentDecomposer.getStringLength(this.value) >= this.m_94216_();
            int o = n;
            if (!bl) {
                o = j > 0 ? l + this.f_93618_ : l;
            } else if (!string.isEmpty()) {
                o = n - 1;
                --n;
            }
            if (!string.isEmpty() && bl && j < string.length()) {
                guiGraphics.m_280648_(this.font, this.formatter.apply(string.substring(j), this.cursorPos), n, m, i);
            }
            if (!bl3 && this.suggestion != null) {
                guiGraphics.m_280488_(this.font, this.suggestion, o - 1, m, -8355712);
            }
            if (bl2 && k == j) {
                if (!string.isEmpty()) {
                    guiGraphics.m_280509_(o, m - 1, o + 1, m + 1 + 9, -3092272);
                } else {
                    guiGraphics.m_280488_(this.font, "_", o, m, i);
                }
            }
            if (k != j) {
                int p = l + FormattedStringDecomposer.stringWidth(this.font, this.value.substring(0, this.highlightPos), this.displayPos);
                this.m_264315_(guiGraphics, o, m - 1, p - 1, m + 1 + 9);
            }
        }
    }

    private void m_264315_(GuiGraphics guiGraphics, int startX, int startY, int endX, int endY) {
        int i;
        if (startX < endX) {
            i = startX;
            startX = endX;
            endX = i;
        }
        if (startY < endY) {
            i = startY;
            startY = endY;
            endY = i;
        }
        if (endX > this.m_252754_() + this.f_93618_) {
            endX = this.m_252754_() + this.f_93618_;
        }
        if (startX > this.m_252754_() + this.f_93618_) {
            startX = this.m_252754_() + this.f_93618_;
        }
        guiGraphics.m_285944_(RenderType.m_285783_(), startX, startY, endX, endY, -16776961);
    }

    public void m_94199_(int length) {
        this.maxLength = length;
        if (this.value.length() > length) {
            this.value = this.value.substring(0, length);
            this.m_94174_(this.value);
        }
    }

    private int m_94216_() {
        return this.maxLength;
    }

    public int m_94207_() {
        return this.cursorPos;
    }

    private boolean m_94219_() {
        return this.bordered;
    }

    public void m_94182_(boolean enableBackgroundDrawing) {
        this.bordered = enableBackgroundDrawing;
    }

    public void m_94202_(int color) {
        this.textColor = color;
    }

    public void m_94205_(int color) {
        this.textColorUneditable = color;
    }

    @Nullable
    public ComponentPath m_264064_(FocusNavigationEvent focusNavigationEvent) {
        return this.f_93624_ && this.isEditable ? super.m_264064_(focusNavigationEvent) : null;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.f_93624_ && mouseX >= (double)this.m_252754_() && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY >= (double)this.m_252907_() && mouseY < (double)(this.m_252907_() + this.f_93619_);
    }

    public void m_93692_(boolean bl) {
        if (this.canLoseFocus || bl) {
            super.m_93692_(bl);
            if (bl) {
                this.frame = 0;
            }
        }
    }

    private boolean m_94222_() {
        return this.isEditable;
    }

    public void m_94186_(boolean enabled) {
        this.isEditable = enabled;
    }

    public int m_94210_() {
        return this.m_94219_() ? this.f_93618_ - 8 : this.f_93618_;
    }

    public void m_94208_(int position) {
        this.highlightPos = Mth.m_14045_((int)position, (int)0, (int)this.value.length());
    }

    public void setDisplayPosition(int position) {
        if (this.font != null) {
            int i = this.value.length();
            if (this.displayPos > i) {
                this.displayPos = i;
            }
            int j = this.m_94210_();
            String string = FormattedStringDecomposer.plainHeadByWidth(this.font, this.value, this.displayPos, j, Style.f_131099_);
            int k = string.length() + this.displayPos;
            if (position == this.displayPos) {
                this.displayPos -= FormattedStringDecomposer.plainTailByWidth(this.font, this.value, j, Style.f_131099_).length();
            }
            if (position > k) {
                this.displayPos += position - k;
            } else if (position <= this.displayPos) {
                this.displayPos -= this.displayPos - position;
            }
            this.displayPos = Mth.m_14045_((int)this.displayPos, (int)0, (int)i);
        }
    }

    public void m_94190_(boolean canLoseFocus) {
        this.canLoseFocus = canLoseFocus;
    }

    public boolean m_94213_() {
        return this.f_93624_;
    }

    public void m_94194_(boolean isVisible) {
        this.f_93624_ = isVisible;
    }

    public void m_94167_(@Nullable String suggestion) {
        this.suggestion = suggestion;
    }

    public int m_94211_(int charNum) {
        return charNum > this.value.length() ? this.m_252754_() : this.m_252754_() + FormattedStringDecomposer.stringWidth(this.font, this.value.substring(0, charNum), 0);
    }

    public void m_168797_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
    }
}

