/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.util;

import com.github.sculkhorde.common.effect.SculkInfectionEffect;
import com.github.sculkhorde.core.ModItems;
import com.github.sculkhorde.core.ModMobEffects;
import com.github.sculkhorde.core.ModSavedData;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.core.gravemind.Gravemind;
import com.github.sculkhorde.core.gravemind.RaidHandler;
import com.github.sculkhorde.core.gravemind.SculkNodesHandler;
import com.github.sculkhorde.core.gravemind.events.EventHandler;
import com.github.sculkhorde.util.AdvancementUtil;
import com.github.sculkhorde.util.ChunkLoading.BlockEntityChunkLoaderHelper;
import com.github.sculkhorde.util.ChunkLoading.EntityChunkLoaderHelper;
import com.github.sculkhorde.util.DeathAreaInvestigator;
import com.github.sculkhorde.util.EntityAlgorithms;
import com.github.sculkhorde.util.StatisticsData;
import com.github.sculkhorde.util.TickUnits;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="sculkhorde", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventSubscriber {
    private static long time_save_point;
    private static int sculkMassCheck;

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        if (!event.getLevel().m_5776_() && event.getLevel().equals(ServerLifecycleHooks.getCurrentServer().m_129783_())) {
            SculkHorde.savedData = (ModSavedData)ServerLifecycleHooks.getCurrentServer().m_129783_().m_8895_().m_164861_(ModSavedData::load, ModSavedData::new, "sculkhorde_gravemind_memory");
            SculkHorde.gravemind = new Gravemind();
            SculkHorde.deathAreaInvestigator = new DeathAreaInvestigator();
            SculkHorde.raidHandler = new RaidHandler((ServerLevel)event.getLevel());
            SculkHorde.sculkNodesHandler = new SculkNodesHandler();
            SculkHorde.entityChunkLoaderHelper = new EntityChunkLoaderHelper();
            SculkHorde.blockEntityChunkLoaderHelper = new BlockEntityChunkLoaderHelper();
            SculkHorde.eventHandler = new EventHandler();
            if (SculkHorde.statisticsData == null) {
                SculkHorde.statisticsData = new StatisticsData();
            }
            time_save_point = 0L;
            sculkMassCheck = 0;
            if (!event.getLevel().m_7726_().m_5563_(0, 0)) {
                BlockEntityChunkLoaderHelper.getChunkLoaderHelper().createChunkLoadRequestSquare((ServerLevel)event.getLevel(), BlockPos.f_121853_, 5, 0, TickUnits.convertMinutesToTicks(10));
            }
        }
    }

    @SubscribeEvent
    public static void WorldTickEvent(TickEvent.LevelTickEvent event) {
        if (event.level.m_5776_() || SculkHorde.gravemind == null || !event.level.equals(ServerLifecycleHooks.getCurrentServer().m_129783_())) {
            return;
        }
        SculkHorde.savedData.incrementNoNodeSpawningTicksElapsed();
        SculkHorde.raidHandler.raidTick();
        SculkHorde.deathAreaInvestigator.tick();
        SculkHorde.sculkNodesHandler.tick();
        SculkHorde.eventHandler.serverTick();
        SculkHorde.cursorHandler.serverTick();
        SculkHorde.blockEntityChunkLoaderHelper.processBlockChunkLoadRequests();
        SculkHorde.entityChunkLoaderHelper.processEntityChunkLoadRequests();
        if (event.level.m_46467_() - time_save_point < (long)TickUnits.convertMinutesToTicks(5)) {
            return;
        }
        time_save_point = event.level.m_46467_();
        SculkHorde.gravemind.enableAmountOfBeeHives(20);
        SculkHorde.savedData.validateNodeEntries();
        SculkHorde.savedData.validateBeeNestEntries();
        SculkHorde.savedData.validateNoRaidZoneEntries();
        SculkHorde.savedData.validateAreasOfInterest();
        SculkHorde.gravemind.calulateCurrentState();
        if (SculkHorde.isDebugMode()) {
            System.out.println("Accumulated Mass Since Last Check: " + (SculkHorde.savedData.getSculkAccumulatedMass() - sculkMassCheck));
        }
        sculkMassCheck = SculkHorde.savedData.getSculkAccumulatedMass();
    }

    @SubscribeEvent
    public static void onLivingEntityDeathEvent(LivingDeathEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        if (EntityAlgorithms.isSculkLivingEntity.test(event.getEntity())) {
            SculkHorde.savedData.reportDeath((ServerLevel)event.getEntity().m_9236_(), event.getEntity().m_20183_());
            SculkHorde.savedData.addHostileToMemory(event.getEntity().m_21188_());
        }
    }

    @SubscribeEvent
    public static void onPotionExpireEvent(MobEffectEvent.Expired event) {
        if (event.getEntity().m_9236_().m_5776_() || SculkHorde.gravemind == null) {
            return;
        }
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance == null) {
            return;
        }
        if (effectInstance.m_19544_() == ModMobEffects.SCULK_INFECTION.get()) {
            SculkInfectionEffect.onPotionExpire(event);
        }
    }

    @SubscribeEvent
    public static void OnLivingDamageEvent(LivingDamageEvent event) {
        ItemStack itemStack = ItemStack.f_41583_;
        Entity damageSourceEntity = event.getSource().m_7639_();
        LivingEntity targetEntity = event.getEntity();
        if (damageSourceEntity instanceof LivingEntity) {
            LivingEntity attackingEntity = (LivingEntity)damageSourceEntity;
            itemStack = attackingEntity.m_21205_();
            if (!itemStack.m_41720_().equals(ModItems.SCULK_SWEEPER_SWORD.get())) {
                return;
            }
            if (!EntityAlgorithms.isSculkLivingEntity.test(targetEntity)) {
                event.setAmount(event.getAmount() / 2.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.m_9236_().m_5776_()) {
            return;
        }
        if (event.player.f_19797_ % 20 == 0) {
            AdvancementUtil.advancementHandlingTick((ServerLevel)event.player.m_9236_());
        }
    }
}

