/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.util;

import com.github.sculkhorde.common.entity.ISculkSmartEntity;
import com.github.sculkhorde.core.ModConfig;
import com.github.sculkhorde.core.ModEntities;
import com.github.sculkhorde.core.ModMobEffects;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.BlockAlgorithms;
import com.github.sculkhorde.util.ModColaborationHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityAlgorithms {
    public static Predicate<LivingEntity> isSculkLivingEntity = e -> e.m_6095_().m_204039_(ModEntities.EntityTags.SCULK_ENTITY);

    public static boolean canApplyDebuffEffect(LivingEntity entity, MobEffect debuff) {
        boolean isEntityNull = entity == null;
        boolean isEntityDead = entity.m_21224_();
        if (isEntityNull || isEntityDead) {
            return false;
        }
        boolean isEntityInvulnerable = entity.m_20147_();
        boolean isEntityAttackable = entity.m_6097_();
        boolean doesEntityHaveDebuffAlready = entity.m_21023_(debuff);
        return !isEntityInvulnerable && isEntityAttackable && !doesEntityHaveDebuffAlready;
    }

    public static void applyDebuffEffect(LivingEntity entity, MobEffect debuff, int duration, int amplifier) {
        if (EntityAlgorithms.canApplyDebuffEffect(entity, debuff)) {
            entity.m_7292_(new MobEffectInstance(debuff, duration, amplifier));
        }
    }

    public static void reducePurityEffectDuration(LivingEntity entity, int amountInTicks) {
        if (entity.m_21023_((MobEffect)ModMobEffects.PURITY.get())) {
            MobEffectInstance purityEffect = entity.m_21124_((MobEffect)ModMobEffects.PURITY.get());
            int newDuration = Math.max(purityEffect.m_19557_() - amountInTicks, 0);
            entity.m_21195_((MobEffect)ModMobEffects.PURITY.get());
            entity.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.PURITY.get(), newDuration, purityEffect.m_19564_()));
        }
    }

    @Nullable
    public static BlockPos playerTargetBlockPos(Player player, boolean isFluid) {
        HitResult block = player.m_19907_(200.0, 0.0f, isFluid);
        if (block.m_6662_() == HitResult.Type.BLOCK) {
            return ((BlockHitResult)block).m_82425_();
        }
        return null;
    }

    public static AABB getSearchAreaRectangle(double originX, double originY, double originZ, double w, double h, double l) {
        double x1 = originX - w;
        double y1 = originY - h;
        double z1 = originZ - l;
        double x2 = originX + w;
        double y2 = originY + h;
        double z2 = originZ + l;
        return new AABB(x1, y1, z1, x2, y2, z2);
    }

    public static boolean isLivingEntityInfected(LivingEntity e) {
        return e.m_21023_((MobEffect)ModMobEffects.SCULK_INFECTION.get());
    }

    public static boolean isLivingEntityHostile(LivingEntity entity) {
        return SculkHorde.savedData.getHostileEntries().get(entity.m_6095_().toString()) != null;
    }

    public static boolean isLivingEntitySwimmer(LivingEntity entity) {
        return entity instanceof WaterAnimal;
    }

    public static boolean isLivingEntityInvulnerable(LivingEntity entity) {
        return entity.m_20147_() || !entity.m_6097_();
    }

    public static boolean isLivingEntityExplicitDenyTarget(LivingEntity entity) {
        if (entity == null) {
            return true;
        }
        if (!(entity instanceof Mob) && !(entity instanceof Player)) {
            return true;
        }
        if (!entity.m_6097_() || entity.m_20147_() || !entity.m_6084_()) {
            return true;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_7500_() || player.m_5833_()) {
                return true;
            }
            if (player.m_21023_((MobEffect)ModMobEffects.SCULK_VESSEL.get())) {
                return true;
            }
        }
        if (entity instanceof Creeper) {
            return true;
        }
        if (isSculkLivingEntity.test(entity)) {
            return true;
        }
        if (entity.m_6095_().m_204039_(ModEntities.EntityTags.SCULK_ENTITY)) {
            return true;
        }
        if (ModColaborationHelper.isThisAFromAnotherWorldEntity(entity) && !((Boolean)ModConfig.SERVER.target_faw_entities.get()).booleanValue()) {
            return true;
        }
        return ModColaborationHelper.isThisASporeEntity(entity) && (Boolean)ModConfig.SERVER.target_spore_entities.get() == false;
    }

    public static void spawnEntitiesOnCircumference(ServerLevel level, Vec3 origin, int radius, int amount, EntityType<?> type) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        ArrayList<Vec3> possibleSpawns = BlockAlgorithms.getPointsOnCircumferenceVec3(origin, radius, amount);
        for (int i = 0; i < possibleSpawns.size(); ++i) {
            Vec3 spawnPos = possibleSpawns.get(i);
            Entity entity = type.m_20615_((Level)level);
            entity.m_6034_(spawnPos.m_7096_(), spawnPos.m_7098_(), spawnPos.m_7094_());
            entities.add(entity);
        }
        for (Entity entity : entities) {
            level.m_7967_(entity);
        }
    }

    public static List<LivingEntity> getLivingEntitiesInBoundingBox(ServerLevel serverLevel, AABB boundingBox) {
        List livingEntitiesInRange = serverLevel.m_6443_(LivingEntity.class, boundingBox, (Predicate)new Predicate<LivingEntity>(){

            @Override
            public boolean test(LivingEntity livingEntity) {
                return true;
            }
        });
        return livingEntitiesInRange;
    }

    public static List<LivingEntity> getLivingEntitiesInBoundingBox(ServerLevel serverLevel, AABB boundingBox, Predicate<LivingEntity> predicate) {
        List livingEntitiesInRange = serverLevel.m_6443_(LivingEntity.class, boundingBox, predicate);
        return livingEntitiesInRange;
    }

    public static List<Entity> getEntitiesInBoundingBox(ServerLevel serverLevel, AABB boundingBox, Predicate<Entity> predicate) {
        List entities = serverLevel.m_6443_(Entity.class, boundingBox, predicate);
        return entities;
    }

    public static AABB createBoundingBoxCubeAtBlockPos(Vec3 origin, int squareLength) {
        double halfLength = squareLength / 2;
        AABB boundingBox = new AABB(origin.m_7096_() - halfLength, origin.m_7098_() - halfLength, origin.m_7094_() - halfLength, origin.m_7096_() + halfLength, origin.m_7098_() + halfLength, origin.m_7094_() + halfLength);
        return boundingBox;
    }

    public static AABB createBoundingBoxRectableAtBlockPos(Vec3 origin, int width, int height, int length) {
        double halfWidth = width / 2;
        double halfHeight = height / 2;
        double halfLength = length / 2;
        AABB boundingBox = new AABB(origin.m_7096_() - halfWidth, origin.m_7098_() - halfHeight, origin.m_7094_() - halfLength, origin.m_7096_() + halfWidth, origin.m_7098_() + halfHeight, origin.m_7094_() + halfLength);
        return boundingBox;
    }

    public static List<LivingEntity> getNonSculkEntitiesAtBlockPos(ServerLevel level, BlockPos origin, int squareLength) {
        AABB boundingBox = EntityAlgorithms.createBoundingBoxCubeAtBlockPos(origin.m_252807_(), squareLength);
        List livingEntitiesInRange = level.m_6443_(LivingEntity.class, boundingBox, (Predicate)new Predicate<LivingEntity>(){

            @Override
            public boolean test(LivingEntity livingEntity) {
                return !isSculkLivingEntity.test(livingEntity);
            }
        });
        return livingEntitiesInRange;
    }

    public static void announceToAllPlayers(ServerLevel level, Component message) {
        level.m_6907_().forEach(player -> player.m_5661_(message, false));
    }

    public static class DelayedHurtScheduler {
        private int ticksRemaining;
        private int delayInTicks;
        private Mob damageDealer;
        private boolean active = false;
        private double attackReach = 0.0;

        public DelayedHurtScheduler(Mob damageDealer, int delayInTicks) {
            this.damageDealer = damageDealer;
            this.delayInTicks = delayInTicks;
            this.ticksRemaining = delayInTicks;
        }

        private ISculkSmartEntity getDamageDealerAsISculkSmartEntity() {
            return (ISculkSmartEntity)this.damageDealer;
        }

        private Mob getDamageDealerAsMob() {
            return this.damageDealer;
        }

        public void tick() {
            if (!this.active) {
                return;
            }
            if (this.ticksRemaining > 0) {
                --this.ticksRemaining;
            } else {
                this.tryToDealDamage();
                this.reset();
            }
        }

        private boolean tryToDealDamage() {
            Optional<LivingEntity> target = Optional.ofNullable(this.getDamageDealerAsMob().m_5448_());
            if (this.damageDealer == null || !this.getDamageDealerAsMob().m_6084_()) {
                return false;
            }
            if (target.isEmpty()) {
                return false;
            }
            if (!((Entity)target.get()).m_6084_()) {
                return false;
            }
            if ((double)this.getDamageDealerAsMob().m_20270_((Entity)target.get()) > this.attackReach) {
                return false;
            }
            this.getDamageDealerAsMob().m_6674_(InteractionHand.MAIN_HAND);
            this.getDamageDealerAsMob().m_7327_((Entity)this.getDamageDealerAsMob().m_5448_());
            return true;
        }

        public void trigger(double attackReach) {
            this.attackReach = attackReach;
            this.active = true;
        }

        public void reset() {
            this.ticksRemaining = this.delayInTicks;
            this.active = false;
        }
    }
}

