/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.util.ChunkLoading;

import com.github.sculkhorde.core.ModConfig;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.ChunkLoading.EntityChunkLoadRequest;
import com.github.sculkhorde.util.TickUnits;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class EntityChunkLoaderHelper {
    private ArrayList<EntityChunkLoadRequest> entityChunkLoadRequests = new ArrayList();
    private int tickCooldownRemaining = 0;
    private final int TICKS_BETWEEN_PROCESSING = TickUnits.convertSecondsToTicks(10);

    public ArrayList<EntityChunkLoadRequest> getEntityChunkLoadRequests() {
        return this.entityChunkLoadRequests;
    }

    private boolean isTickCooldownFinished() {
        return this.tickCooldownRemaining <= 0;
    }

    private void resetTickCooldown() {
        this.tickCooldownRemaining = this.TICKS_BETWEEN_PROCESSING;
    }

    public static void load(CompoundTag tag) {
        if (EntityChunkLoaderHelper.getEntityChunkLoaderHelper() == null) {
            SculkHorde.LOGGER.error("EntityChunkLoaderHelper is null. Cannot Load");
            return;
        }
        EntityChunkLoaderHelper.getEntityChunkLoaderHelper().entityChunkLoadRequests.clear();
        ListTag entityChunkLoadRequestsTag = tag.m_128437_("entityChunkLoadRequests", 10);
        for (int i = 0; i < entityChunkLoadRequestsTag.size(); ++i) {
            CompoundTag requestTag = entityChunkLoadRequestsTag.m_128728_(i);
            EntityChunkLoadRequest request = EntityChunkLoadRequest.serialize(requestTag);
            EntityChunkLoaderHelper.getEntityChunkLoaderHelper().entityChunkLoadRequests.add(request);
        }
    }

    public static CompoundTag save(CompoundTag tag) {
        if (EntityChunkLoaderHelper.getEntityChunkLoaderHelper() == null) {
            SculkHorde.LOGGER.error("EntityChunkLoaderHelper is null. Cannot Save");
            return tag;
        }
        ListTag entityChunkLoadRequestsTag = new ListTag();
        for (EntityChunkLoadRequest request : EntityChunkLoaderHelper.getEntityChunkLoaderHelper().entityChunkLoadRequests) {
            entityChunkLoadRequestsTag.add((Object)request.deserialize());
        }
        tag.m_128365_("entityChunkLoadRequests", (Tag)entityChunkLoadRequestsTag);
        return tag;
    }

    public static EntityChunkLoaderHelper getEntityChunkLoaderHelper() {
        return SculkHorde.entityChunkLoaderHelper;
    }

    public void processEntityChunkLoadRequests() {
        if (!this.isTickCooldownFinished()) {
            --this.tickCooldownRemaining;
            return;
        }
        this.resetTickCooldown();
        for (int i = 0; i < this.entityChunkLoadRequests.size(); ++i) {
            EntityChunkLoadRequest request = this.entityChunkLoadRequests.get(i);
            request.decrementTicksUntilExpiration(this.TICKS_BETWEEN_PROCESSING);
            if (request.getDimension() == null) {
                if (SculkHorde.isDebugMode()) {
                    SculkHorde.LOGGER.error("EntityChunkLoader | Dimension is null, Removing");
                }
                this.entityChunkLoadRequests.remove(i);
                --i;
                continue;
            }
            if (request.isExpired()) {
                if (SculkHorde.isDebugMode()) {
                    SculkHorde.LOGGER.info("EntityChunkLoader | Chunk EXPIRED, Unloading and Removing");
                }
                this.unloadAndRemoveChunksWithOwner(request.getOwner(), request.getDimension());
                return;
            }
            this.loadChunksWithOwner(request.getOwner(), request.getDimension());
        }
    }

    private static void forceLoadChunk(ServerLevel world, int chunkX, int chunkZ) {
        if (world == null) {
            SculkHorde.LOGGER.error("World is null. Cannot Force Load Chunk");
            return;
        }
        world.m_8602_(chunkX, chunkZ, true);
    }

    public static void unloadChunk(ServerLevel world, int chunkX, int chunkZ) {
        if (world == null) {
            SculkHorde.LOGGER.error("World is null. Cannot Force Unload Chunk");
            return;
        }
        world.m_8602_(chunkX, chunkZ, false);
    }

    public void unloadAndRemoveChunksWithOwner(UUID owner, ServerLevel level) {
        Iterator<EntityChunkLoadRequest> iterator = this.entityChunkLoadRequests.iterator();
        while (iterator.hasNext()) {
            EntityChunkLoadRequest request = iterator.next();
            if (!request.isOwner(owner)) continue;
            for (ChunkPos chunkPos : request.getChunkPositionsToLoad()) {
                EntityChunkLoaderHelper.unloadChunk(level, chunkPos.f_45578_, chunkPos.f_45579_);
            }
            iterator.remove();
        }
    }

    public void loadChunksWithOwner(UUID owner, ServerLevel level) {
        for (EntityChunkLoadRequest request : this.entityChunkLoadRequests) {
            if (!request.isOwner(owner)) continue;
            for (ChunkPos chunkPos : request.getChunkPositionsToLoad()) {
                EntityChunkLoaderHelper.forceLoadChunk(level, chunkPos.f_45578_, chunkPos.f_45579_);
            }
        }
    }

    public boolean doesChunkLoadRequestAlreadyExist(String requestID) {
        for (EntityChunkLoadRequest request : this.entityChunkLoadRequests) {
            if (!request.isRequestID(requestID)) continue;
            return true;
        }
        return false;
    }

    private String generateRequestIDFromEntity(Entity owner) {
        ChunkPos centerChunkPos = new ChunkPos(owner.m_20183_());
        return String.valueOf(centerChunkPos.f_45578_) + String.valueOf(centerChunkPos.f_45579_);
    }

    public void createChunkLoadRequestSquareForEntityIfAbsent(Entity owner, int length, int priority, long ticksUnitExpiration) {
        if (length % 2 == 0) {
            ++length;
        }
        String requestID = this.generateRequestIDFromEntity(owner);
        int halfLength = length / 2;
        ChunkPos entityChunkPos = new ChunkPos(owner.m_20183_());
        ChunkPos[] chunkPositionsToLoad = new ChunkPos[length * length];
        int index = 0;
        for (int dx = -halfLength; dx <= halfLength; ++dx) {
            for (int dz = -halfLength; dz <= halfLength; ++dz) {
                chunkPositionsToLoad[index++] = new ChunkPos(entityChunkPos.f_45578_ + dx, entityChunkPos.f_45579_ + dz);
            }
        }
        this.createChunkLoadRequest(owner, chunkPositionsToLoad, priority, requestID, ticksUnitExpiration);
    }

    private void createChunkLoadRequest(Entity owner, ChunkPos[] chunkPositionsToLoad, int priority, String requestID, long ticksUntilExpiration) {
        if (this.doesChunkLoadRequestAlreadyExist(requestID) || !((Boolean)ModConfig.SERVER.chunk_loading_enabled.get()).booleanValue()) {
            return;
        }
        EntityChunkLoadRequest request = new EntityChunkLoadRequest((ResourceKey<Level>)owner.m_9236_().m_46472_(), owner.m_20148_(), chunkPositionsToLoad, priority, requestID, ticksUntilExpiration);
        this.entityChunkLoadRequests.add(request);
        this.loadChunksWithOwner(request.getOwner(), request.getDimension());
    }
}

