/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.util.ChunkLoading;

import com.github.sculkhorde.util.ChunkLoading.ChunkLoadRequest;
import java.util.UUID;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class EntityChunkLoadRequest
extends ChunkLoadRequest {
    protected UUID owner;

    public EntityChunkLoadRequest(ResourceKey<Level> dimension, UUID owner, ChunkPos[] chunkPositionsToLoad, int priority, String requestID, long ticksUntilExpiration) {
        super(dimension, chunkPositionsToLoad, priority, requestID, ticksUntilExpiration);
        this.owner = owner;
        this.dimension = dimension;
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public boolean isOwner(Object ownerObj) {
        if (!(ownerObj instanceof UUID)) {
            return false;
        }
        return this.owner.equals((UUID)ownerObj);
    }

    public CompoundTag deserialize() {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("priority", this.priority);
        compound.m_128362_("owner", this.owner);
        compound.m_128405_("chunkPositionsToLoadLength", this.chunkPositionsToLoad.length);
        compound.m_128359_("requestID", this.requestID);
        compound.m_128356_("ticksUntilExpiration", this.ticksUntilExpiration);
        compound.m_128359_("dimension", this.dimension.m_135782_().toString());
        for (int i = 0; i < this.chunkPositionsToLoad.length; ++i) {
            compound.m_128356_("chunkPositionsToLoad" + i, this.chunkPositionsToLoad[i].m_45588_());
        }
        return compound;
    }

    public static EntityChunkLoadRequest serialize(CompoundTag compound) {
        int priority = compound.m_128451_("priority");
        UUID owner = compound.m_128342_("owner");
        int chunkPositionsToLoadLength = compound.m_128451_("chunkPositionsToLoadLength");
        String requestID = compound.m_128461_("requestID");
        long ticksUntilExpiration = compound.m_128454_("ticksUntilExpiration");
        ChunkPos[] chunkPositionsToLoad = new ChunkPos[chunkPositionsToLoadLength];
        ResourceKey dimensionResourceKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(compound.m_128461_("dimension")));
        for (int i = 0; i < chunkPositionsToLoadLength; ++i) {
            chunkPositionsToLoad[i] = new ChunkPos(compound.m_128454_("chunkPositionsToLoad" + i));
        }
        return new EntityChunkLoadRequest((ResourceKey<Level>)dimensionResourceKey, owner, chunkPositionsToLoad, priority, requestID, ticksUntilExpiration);
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }
}

