/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.util;

import com.github.sculkhorde.util.BlockAlgorithms;
import com.github.sculkhorde.util.TickUnits;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class BlockSearcher {
    protected boolean debugMode = false;
    protected ArmorStand debugStand;
    public int searchIterationsPerTick = 20;
    public int DELAY_BETWEEN_SEARCH_TICKS;
    public int ticksSinceLastSearchTick = this.DELAY_BETWEEN_SEARCH_TICKS = TickUnits.convertSecondsToTicks(0);
    protected ServerLevel level;
    public BlockPos origin;
    public int MAX_TARGETS = 1;
    public ArrayList<BlockPos> foundTargets = new ArrayList();
    public boolean ignoreBlocksNearTargets = false;
    public int distanceToIgnoreBlocksNearTargets = 5;
    protected int MAX_DISTANCE;
    protected Predicate<BlockPos> isObstructed;
    protected Predicate<BlockPos> isValidTargetBlock;
    ArrayList<BlockPos> queue = new ArrayList();
    public boolean isSuccessful = false;
    public boolean isFinished = false;
    protected HashMap<Long, Boolean> visitedPositons = new HashMap();
    public BlockPos currentPosition;
    protected BlockPos positionToMoveAwayFrom;
    State state = State.IDLE;

    public BlockSearcher(ServerLevel level, BlockPos origin) {
        this.level = level;
        this.origin = origin;
        this.currentPosition = origin;
    }

    public ServerLevel getDimension() {
        return this.level;
    }

    public BlockSearcher setMaxDistance(int maxDistance) {
        this.MAX_DISTANCE = maxDistance;
        return this;
    }

    public BlockSearcher setMaxTargets(int maxTargets) {
        this.MAX_TARGETS = maxTargets;
        return this;
    }

    public BlockSearcher setObstructionPredicate(Predicate<BlockPos> isObstructed) {
        this.isObstructed = isObstructed;
        return this;
    }

    public BlockSearcher setTargetBlockPredicate(Predicate<BlockPos> isValidTargetBlock) {
        this.isValidTargetBlock = isValidTargetBlock;
        return this;
    }

    public void setPositionToMoveAwayFrom(BlockPos positionToMoveAwayFrom) {
        this.positionToMoveAwayFrom = positionToMoveAwayFrom;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    protected boolean isNearOtherTargets(BlockPos position) {
        for (BlockPos target : this.foundTargets) {
            if (!target.m_123314_((Vec3i)position, (double)this.distanceToIgnoreBlocksNearTargets)) continue;
            return true;
        }
        return false;
    }

    protected void searchTick() {
        boolean debugObstruction = false;
        for (int i = 0; i < this.searchIterationsPerTick; ++i) {
            if (this.debugStand == null && this.debugMode) {
                this.debugStand = new ArmorStand((Level)this.level, (double)this.origin.m_123341_(), (double)this.origin.m_123342_(), (double)this.origin.m_123343_());
                this.debugStand.m_6842_(true);
                this.debugStand.m_20242_(true);
                this.debugStand.m_7292_(new MobEffectInstance(MobEffects.f_19619_, TickUnits.convertHoursToTicks(1), 3));
                this.level.m_7967_((Entity)this.debugStand);
            }
            if (this.queue.isEmpty()) {
                this.state = State.FINISHED;
                return;
            }
            if (this.foundTargets.size() >= this.MAX_TARGETS) {
                this.state = State.FINISHED;
                return;
            }
            if (this.positionToMoveAwayFrom != null && !this.positionToMoveAwayFrom.equals((Object)BlockPos.f_121853_)) {
                this.queue.sort(Comparator.comparingInt(pos -> (int)BlockAlgorithms.getBlockDistance(pos, this.positionToMoveAwayFrom)).reversed());
            }
            BlockPos currentBlock = this.queue.get(0);
            this.queue.remove(0);
            if (debugObstruction) {
                this.level.m_46597_(currentBlock, Blocks.f_50213_.m_49966_());
            }
            if (this.debugMode) {
                this.debugStand.m_6021_((double)currentBlock.m_123341_() + 0.5, (double)currentBlock.m_123342_(), (double)currentBlock.m_123343_() + 0.5);
            }
            if (!this.ignoreBlocksNearTargets && this.isValidTargetBlock.test(currentBlock) || this.ignoreBlocksNearTargets && this.isValidTargetBlock.test(currentBlock) && !this.isNearOtherTargets(currentBlock)) {
                this.foundTargets.add(currentBlock);
            }
            ArrayList<BlockPos> possiblePaths = BlockAlgorithms.getNeighborsCube(currentBlock, false);
            for (BlockPos neighbor : possiblePaths) {
                if (this.visitedPositons.getOrDefault(neighbor.m_121878_(), false).booleanValue() || this.isObstructed.test(neighbor) || BlockAlgorithms.getBlockDistance(this.origin, neighbor) > (float)this.MAX_DISTANCE) continue;
                this.queue.add(neighbor);
                this.visitedPositons.put(neighbor.m_121878_(), true);
            }
        }
    }

    public void idleTick() {
        this.queue.add(this.currentPosition);
        this.state = State.SEARCHING;
    }

    public void finishedTick() {
        this.isSuccessful = this.foundTargets.size() > 0;
        this.isFinished = true;
    }

    public void tick() {
        ++this.ticksSinceLastSearchTick;
        if (this.ticksSinceLastSearchTick < this.DELAY_BETWEEN_SEARCH_TICKS) {
            return;
        }
        this.ticksSinceLastSearchTick = 0;
        switch (this.state) {
            case IDLE: {
                this.idleTick();
                break;
            }
            case SEARCHING: {
                this.searchTick();
                break;
            }
            case FINISHED: {
                this.finishedTick();
            }
        }
    }

    public boolean isAnyTargetCloserThan(BlockPos position, int distance) {
        for (BlockPos target : this.foundTargets) {
            if (!target.m_123314_((Vec3i)position, (double)distance)) continue;
            return true;
        }
        return false;
    }

    static enum State {
        IDLE,
        SEARCHING,
        FINISHED;

    }
}

