/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.util;

import com.github.sculkhorde.common.block.InfestationEntries.BlockInfestationTable;
import com.github.sculkhorde.common.block.InfestationEntries.ITagInfestedBlock;
import com.github.sculkhorde.common.block.SculkBeeNestBlock;
import com.github.sculkhorde.common.block.SculkNodeBlock;
import com.github.sculkhorde.common.blockentity.SculkBeeNestBlockEntity;
import com.github.sculkhorde.core.ModBlocks;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.BlockAlgorithms;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IPlantable;

public class BlockInfestationHelper {
    public static Predicate<BlockState> shouldBeRemovedFromAboveBlock = b -> {
        if (b.m_60713_((Block)ModBlocks.GRASS.get())) {
            return true;
        }
        if (b.m_60713_((Block)ModBlocks.GRASS_SHORT.get())) {
            return true;
        }
        if (b.m_60713_((Block)ModBlocks.SMALL_SHROOM.get())) {
            return true;
        }
        if (b.m_60713_((Block)ModBlocks.SCULK_SHROOM_CULTURE.get())) {
            return true;
        }
        if (b.m_60713_((Block)ModBlocks.SPIKE.get())) {
            return true;
        }
        if (b.m_60713_((Block)ModBlocks.SCULK_SUMMONER_BLOCK.get())) {
            return true;
        }
        if (b.m_60713_(Blocks.f_220857_)) {
            return true;
        }
        if (b.m_60713_(Blocks.f_220858_)) {
            return true;
        }
        if (b.m_60713_(Blocks.f_220856_)) {
            return true;
        }
        if (b.m_60713_(Blocks.f_152500_)) {
            return true;
        }
        return b.m_60713_((Block)ModBlocks.TENDRILS.get());
    };

    public static void initializeInfestationTables() {
        SculkHorde.explicitInfectableBlocks = new BlockInfestationTable(false);
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50493_, Blocks.f_220855_.m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50546_, Blocks.f_220855_.m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50440_, Blocks.f_220855_.m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_152481_, Blocks.f_220855_.m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50599_, Blocks.f_220855_.m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50129_, ((Block)ModBlocks.INFESTED_CLAY.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50069_, ((Block)ModBlocks.INFESTED_STONE.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50635_, ((StairBlock)ModBlocks.INFESTED_STONE_STAIRS.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_152550_, ((Block)ModBlocks.INFESTED_DEEPSLATE.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_152551_, ((Block)ModBlocks.INFESTED_COBBLED_DEEPSLATE.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_49992_, ((Block)ModBlocks.INFESTED_SAND.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50062_, ((Block)ModBlocks.INFESTED_SANDSTONE.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_49993_, ((Block)ModBlocks.INFESTED_RED_SAND.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50228_, ((Block)ModBlocks.INFESTED_DIORITE.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50122_, ((Block)ModBlocks.INFESTED_GRANITE.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50334_, ((Block)ModBlocks.INFESTED_ANDESITE.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_152496_, ((Block)ModBlocks.INFESTED_TUFF.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_152497_, ((Block)ModBlocks.INFESTED_CALCITE.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50652_, ((Block)ModBlocks.INFESTED_COBBLESTONE.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50157_, ((StairBlock)ModBlocks.INFESTED_COBBLESTONE_STAIRS.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50079_, ((Block)ModBlocks.INFESTED_MOSSY_COBBLESTONE.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50633_, ((StairBlock)ModBlocks.INFESTED_MOSSY_COBBLESTONE_STAIRS.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_49994_, ((Block)ModBlocks.INFESTED_GRAVEL.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_220864_, ((Block)ModBlocks.INFESTED_MUD.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_220843_, ((Block)ModBlocks.INFESTED_PACKED_MUD.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_220844_, ((Block)ModBlocks.INFESTED_MUD_BRICKS.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50127_, ((Block)ModBlocks.INFESTED_SNOW.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_152544_, ((Block)ModBlocks.INFESTED_MOSS.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50352_, ((Block)ModBlocks.INFESTED_TERRACOTTA.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50302_, ((Block)ModBlocks.INFESTED_BLACK_TERRACOTTA.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50298_, ((Block)ModBlocks.INFESTED_BLUE_TERRACOTTA.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50299_, ((Block)ModBlocks.INFESTED_BROWN_TERRACOTTA.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50296_, ((Block)ModBlocks.INFESTED_CYAN_TERRACOTTA.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50294_, ((Block)ModBlocks.INFESTED_GRAY_TERRACOTTA.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50300_, ((Block)ModBlocks.INFESTED_GREEN_TERRACOTTA.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50290_, ((Block)ModBlocks.INFESTED_LIGHT_BLUE_TERRACOTTA.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50295_, ((Block)ModBlocks.INFESTED_LIGHT_GRAY_TERRACOTTA.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50292_, ((Block)ModBlocks.INFESTED_LIME_TERRACOTTA.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50289_, ((Block)ModBlocks.INFESTED_MAGENTA_TERRACOTTA.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50288_, ((Block)ModBlocks.INFESTED_ORANGE_TERRACOTTA.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50293_, ((Block)ModBlocks.INFESTED_PINK_TERRACOTTA.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50297_, ((Block)ModBlocks.INFESTED_PURPLE_TERRACOTTA.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50301_, ((Block)ModBlocks.INFESTED_RED_TERRACOTTA.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50287_, ((Block)ModBlocks.INFESTED_WHITE_TERRACOTTA.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50291_, ((Block)ModBlocks.INFESTED_YELLOW_TERRACOTTA.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50723_, ((Block)ModBlocks.INFESTED_CRYING_OBSIDIAN.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50134_, ((Block)ModBlocks.INFESTED_NETHERRACK.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50699_, ((Block)ModBlocks.INFESTED_CRIMSON_NYLIUM.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50690_, ((Block)ModBlocks.INFESTED_WARPED_NYLIUM.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50730_, ((Block)ModBlocks.INFESTED_BLACKSTONE.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50137_, ((Block)ModBlocks.INFESTED_BASALT.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_152597_, ((Block)ModBlocks.INFESTED_SMOOTH_BASALT.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry(Blocks.f_50259_, ((Block)ModBlocks.INFESTED_ENDSTONE.get()).m_49966_());
        SculkHorde.explicitInfectableBlocks.addEntry("minecraft:deepslate", "deeperdarker:sculk_stone");
        SculkHorde.explicitInfectableBlocks.addEntry("minecraft:deepslate_coal_ore", "deeperdarker:sculk_stone_coal_ore");
        SculkHorde.explicitInfectableBlocks.addEntry("minecraft:deepslate_iron_ore", "deeperdarker:sculk_stone_iron_ore");
        SculkHorde.explicitInfectableBlocks.addEntry("minecraft:deepslate_gold_ore", "deeperdarker:sculk_stone_gold_ore");
        SculkHorde.explicitInfectableBlocks.addEntry("minecraft:deepslate_copper_ore", "deeperdarker:sculk_stone_copper_ore");
        SculkHorde.explicitInfectableBlocks.addEntry("minecraft:deepslate_lapis_ore", "deeperdarker:sculk_stone_lapis_ore");
        SculkHorde.explicitInfectableBlocks.addEntry("minecraft:deepslate_redstone_ore", "deeperdarker:sculk_stone_redstone_ore");
        SculkHorde.explicitInfectableBlocks.addEntry("minecraft:deepslate_emerald_ore", "deeperdarker:sculk_stone_emerald_ore");
        SculkHorde.explicitInfectableBlocks.addEntry("minecraft:deepslate_diamond_ore", "deeperdarker:sculk_stone_diamond_ore");
        SculkHorde.explicitInfectableBlocks.addEntry("minecraft:moss_block", "deeperdarker:echo_soil");
        SculkHorde.explicitInfectableBlocks.addEntry("minecraft:flowering_azalea_leaves", "deeperdarker:echo_leaves");
        SculkHorde.explicitInfectableBlocks.addEntry("minecraft:oak_log", "deeperdarker:echo_log");
        SculkHorde.explicitInfectableBlocks.addEntry("minecraft:pearlescent_froglight", "deeperdarker:sculk_gleam");
        SculkHorde.explicitInfectableBlocks.addEntry("minecraft:blackstone", "deeperdarker:gloomslate");
        SculkHorde.explicitInfectableBlocks.addEntry("minecraft:deepslate_coal_ore", "deeperdarker:gloomslate_coal_ore");
        SculkHorde.explicitInfectableBlocks.addEntry("minecraft:deepslate_iron_ore", "deeperdarker:gloomslate_iron_ore");
        SculkHorde.explicitInfectableBlocks.addEntry("minecraft:deepslate_gold_ore", "deeperdarker:gloomslate_gold_ore");
        SculkHorde.explicitInfectableBlocks.addEntry("minecraft:deepslate_copper_ore", "deeperdarker:gloomslate_copper_ore");
        SculkHorde.explicitInfectableBlocks.addEntry("minecraft:deepslate_lapis_ore", "deeperdarker:gloomslate_lapis_ore");
        SculkHorde.explicitInfectableBlocks.addEntry("minecraft:deepslate_redstone_ore", "deeperdarker:gloomslate_redstone_ore");
        SculkHorde.explicitInfectableBlocks.addEntry("minecraft:deepslate_emerald_ore", "deeperdarker:gloomslate_emerald_ore");
        SculkHorde.explicitInfectableBlocks.addEntry("minecraft:deepslate_diamond_ore", "deeperdarker:gloomslate_diamond_ore");
        SculkHorde.explicitInfectableBlocks.addEntry("minecraft:lava", "deeperdarker:gloomy_geyser");
        SculkHorde.explicitInfectableBlocks.addEntry("minecraft:smooth_basalt", "deeperdarker:gloomy_sculk");
        SculkHorde.explicitInfectableBlocks.addEntry("minecraft:ochre_froglight", "deeperdarker:crystallized_amber");
        SculkHorde.explicitInfectableBlocks.addEntry("minecraft:deepslate", "deeperdarker:sculk_grime");
        SculkHorde.explicitInfectableBlocks.addEntry("minecraft:air", "deeperdarker:sculk_tendrils");
        SculkHorde.explicitInfectableBlocks.addEntry("minecraft:cave_vines", "deeperdarker:sculk_vines");
        SculkHorde.explicitInfectableBlocks.addEntry("minecraft:mud", "deeperdarker:sculk_jaw");
        SculkHorde.tagInfectableStairsAndSlabsBlocks = new BlockInfestationTable(false);
        SculkHorde.tagInfectableStairsAndSlabsBlocks.addEntry((TagKey<Block>)BlockTags.f_13096_, (ITagInfestedBlock)ModBlocks.INFESTED_WOOD_STAIRS.get());
        SculkHorde.tagInfectableBlocks = new BlockInfestationTable(true);
        SculkHorde.tagInfectableBlocks.addEntry((TagKey<Block>)BlockTags.f_13106_, (ITagInfestedBlock)ModBlocks.INFESTED_LOG.get());
        SculkHorde.tagInfectableBlocks.addEntry((TagKey<Block>)BlockTags.f_144280_, (ITagInfestedBlock)ModBlocks.INFESTED_WOOD_MASS.get());
        SculkHorde.tagInfectableBlocks.addEntry((TagKey<Block>)BlockTags.f_144282_, (Tier)Tiers.IRON, (ITagInfestedBlock)ModBlocks.INFESTED_STURDY_MASS.get());
        SculkHorde.tagInfectableBlocks.addEntry((TagKey<Block>)BlockTags.f_144283_, (Tier)Tiers.IRON, (ITagInfestedBlock)ModBlocks.INFESTED_CRUMPLED_MASS.get());
        SculkHorde.tagInfectableBlocks.addEntry((TagKey<Block>)BlockTags.f_144281_, (Tier)Tiers.IRON, (ITagInfestedBlock)ModBlocks.INFESTED_COMPOST_MASS.get());
        SculkHorde.INFESTATION_TABLES = new BlockInfestationTable[]{SculkHorde.explicitInfectableBlocks, SculkHorde.tagInfectableStairsAndSlabsBlocks, SculkHorde.tagInfectableBlocks};
    }

    public static boolean isExplicitlyNotInfectable(BlockState blockState) {
        return blockState.m_204336_(ModBlocks.BlockTags.NOT_INFESTABLE) || blockState.m_204336_(ModBlocks.BlockTags.INFESTED_BLOCK) || blockState.m_60795_() || blockState.m_155947_();
    }

    public static boolean isInfectable(ServerLevel level, BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        if (BlockInfestationHelper.isExplicitlyNotInfectable(blockState)) {
            return false;
        }
        for (BlockInfestationTable table : SculkHorde.INFESTATION_TABLES) {
            if (!table.canBeInfectedByThisTable(level, pos)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCurable(ServerLevel level, BlockPos pos) {
        for (BlockInfestationTable table : SculkHorde.INFESTATION_TABLES) {
            if (table.getNormalVariant((Level)level, pos) == null) continue;
            return true;
        }
        return false;
    }

    public static void tryToInfestBlock(ServerLevel world, BlockPos targetPos) {
        BlockState victimBlockState = world.m_8055_(targetPos);
        boolean wasAbleToInfestBlock = false;
        if (BlockInfestationHelper.isExplicitlyNotInfectable(victimBlockState)) {
            return;
        }
        for (BlockInfestationTable table : SculkHorde.INFESTATION_TABLES) {
            if (!table.canBeInfectedByThisTable(world, targetPos)) continue;
            wasAbleToInfestBlock = table.infectBlock(world, targetPos);
            break;
        }
        if (!wasAbleToInfestBlock) {
            return;
        }
        world.m_8767_((ParticleOptions)ParticleTypes.f_235900_, (double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 1.15, (double)targetPos.m_123343_() + 0.5, 2, 0.2, 0.0, 0.2, 0.0);
        world.m_5594_(null, targetPos, SoundEvents.f_215753_, SoundSource.BLOCKS, 2.0f, 1.6f);
        BlockInfestationHelper.removeNearbyVein(world, targetPos);
        BlockInfestationHelper.placeSculkFlora(world, targetPos);
        SculkNodeBlock.tryPlaceSculkNode(world, targetPos, false);
        BlockInfestationHelper.tryPlaceSculkBeeHive(world, targetPos.m_7494_());
    }

    public static boolean tryToCureBlock(ServerLevel world, BlockPos targetPos) {
        boolean wasAbleToCureBlock = false;
        BlockState getNormalVariant = null;
        if (!BlockInfestationHelper.isCurable(world, targetPos)) {
            return false;
        }
        for (BlockInfestationTable table : SculkHorde.INFESTATION_TABLES) {
            getNormalVariant = table.getNormalVariant((Level)world, targetPos);
            if (getNormalVariant == null) continue;
            wasAbleToCureBlock = true;
            break;
        }
        if (!wasAbleToCureBlock) {
            return false;
        }
        world.m_46597_(targetPos, getNormalVariant);
        if (shouldBeRemovedFromAboveBlock.test(world.m_8055_(targetPos.m_7494_()))) {
            world.m_46597_(targetPos.m_7494_(), Blocks.f_50016_.m_49966_());
        }
        boolean canCuredBlockSustatinPlant = world.m_8055_(targetPos).canSustainPlant((BlockGetter)world, targetPos, Direction.UP, (IPlantable)Blocks.f_50112_);
        Random rand = new Random();
        if (rand.nextBoolean() && canCuredBlockSustatinPlant && world.m_8055_(targetPos.m_7494_()).m_60795_()) {
            world.m_46597_(targetPos.m_7494_(), Blocks.f_50034_.m_49966_());
        }
        return true;
    }

    public static void removeNearbyVein(ServerLevel world, BlockPos position) {
        ArrayList<BlockPos> adjacentBlockPos = BlockAlgorithms.getAdjacentNeighbors(position);
        for (BlockPos neighbors : adjacentBlockPos) {
            BlockState blockState = world.m_8055_(neighbors);
            if (blockState.m_60734_() != ModBlocks.TENDRILS.get() || blockState.m_60734_().m_7898_(blockState, (LevelReader)world, neighbors)) continue;
            world.m_46961_(neighbors, false);
        }
    }

    public static void placeSculkFlora(ServerLevel world, BlockPos position) {
        if (world.f_46441_.m_188503_(4) <= 0) {
            BlockAlgorithms.tryPlaceSculkFlora(position.m_7494_(), world);
        }
    }

    public static void tryPlaceSculkBeeHive(ServerLevel world, BlockPos targetPos) {
        if (new Random().nextInt(4000) <= 1 && world.m_8055_(targetPos).m_60795_() && world.m_8055_(targetPos.m_7494_()).m_60795_() && world.m_8055_(targetPos.m_7494_().m_7494_()).m_60795_()) {
            world.m_46597_(targetPos, ((SculkBeeNestBlock)((Object)ModBlocks.SCULK_BEE_NEST_BLOCK.get())).m_49966_());
            SculkBeeNestBlockEntity nest = (SculkBeeNestBlockEntity)world.m_7702_(targetPos);
            nest.addFreshInfectorOccupant();
            nest.addFreshInfectorOccupant();
            nest.addFreshHarvesterOccupant();
            nest.addFreshHarvesterOccupant();
        }
    }
}

