/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.core.gravemind.events;

import com.github.sculkhorde.common.entity.SculkPhantomEntity;
import com.github.sculkhorde.core.gravemind.events.Event;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class SpawnPhantomsEvent
extends Event {
    public SpawnPhantomsEvent(ResourceKey<Level> dimension) {
        super(dimension);
    }

    public static Event createEvent(ResourceKey<Level> dimension) {
        return new SpawnPhantomsEvent(dimension);
    }

    private void spawnScoutPhantomsAtTopOfWorld(int amount) {
        int spawnRange = 100;
        int minimumSpawnRange = 50;
        Random rng = new Random();
        for (int i = 0; i < amount; ++i) {
            int x = minimumSpawnRange + rng.nextInt(spawnRange) - spawnRange / 2;
            int z = minimumSpawnRange + rng.nextInt(spawnRange) - spawnRange / 2;
            int y = this.getDimension().m_151558_();
            BlockPos spawnPosition = new BlockPos(this.getEventLocation().m_123341_() + x, y, this.getEventLocation().m_123343_() + z);
            SculkPhantomEntity.spawnPhantom((Level)this.getDimension(), spawnPosition, true);
        }
    }

    @Override
    public void start() {
        super.start();
        this.spawnScoutPhantomsAtTopOfWorld(10);
    }
}

