/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.core.gravemind.events;

import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.core.gravemind.events.Event;
import com.github.sculkhorde.util.TickUnits;
import java.util.HashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.server.ServerLifecycleHooks;

public class EventHandler {
    private HashMap<Long, Event> events;
    private long lastGameTimeOfExecution;
    private final long EXECUTION_COOLDOWN_TICKS = TickUnits.convertMinutesToTicks(1);

    public EventHandler() {
        this.events = new HashMap();
    }

    public HashMap<Long, Event> getEvents() {
        return this.events;
    }

    public boolean canExecute() {
        return ServerLifecycleHooks.getCurrentServer().m_129783_().m_46467_() - this.lastGameTimeOfExecution > this.EXECUTION_COOLDOWN_TICKS;
    }

    public Event getEvent(long eventID) {
        return this.events.get(eventID);
    }

    public boolean doesEventExist(long eventID) {
        return this.events.containsKey(eventID);
    }

    public void addEvent(Event event) {
        if (!this.events.containsKey(event.getEventID())) {
            this.events.put(event.getEventID(), event);
            SculkHorde.LOGGER.info("Added event " + event.getClass() + " with ID: " + event.getEventID());
        }
    }

    public void removeEvent(long eventID) {
        this.events.remove(eventID);
    }

    public void serverTick() {
        if (!this.canExecute()) {
            return;
        }
        this.lastGameTimeOfExecution = ServerLifecycleHooks.getCurrentServer().m_129783_().m_46467_();
        for (Event event : this.events.values()) {
            if (event.isToBeRemoved()) {
                this.removeEvent(event.getEventID());
                SculkHorde.LOGGER.info("Removed event " + event.getClass() + " with ID: " + event.getEventID());
                return;
            }
            boolean isEventActive = event.isEventActive();
            boolean canEventStart = event.canStart();
            boolean canEventContinue = event.canContinue();
            if (!isEventActive && canEventStart) {
                event.start();
                continue;
            }
            if (isEventActive && canEventContinue) {
                event.serverTick();
                continue;
            }
            if (!isEventActive || canEventContinue) continue;
            event.end();
        }
    }

    public static void save(CompoundTag tag) {
        SculkHorde.LOGGER.info("Saving events");
        CompoundTag eventsTag = new CompoundTag();
        for (Event event : SculkHorde.eventHandler.getEvents().values()) {
            CompoundTag eventTag = new CompoundTag();
            event.save(eventTag);
            eventsTag.m_128365_(event.getClass().getName(), (Tag)eventTag);
        }
        tag.m_128365_("events", (Tag)eventsTag);
    }

    public static EventHandler load(CompoundTag tag) {
        SculkHorde.LOGGER.info("Loading events");
        EventHandler eventHandler = new EventHandler();
        CompoundTag eventsTag = tag.m_128469_("events");
        for (String key : eventsTag.m_128431_()) {
            CompoundTag eventTag = eventsTag.m_128469_(key);
            Event event = Event.load(eventTag);
            eventHandler.addEvent(event);
        }
        return eventHandler;
    }
}

