/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.core.gravemind.events;

import com.github.sculkhorde.core.SculkHorde;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class Event {
    protected long eventID;
    protected int eventCost;
    protected BlockPos eventLocation;
    protected long EXECUTION_COOLDOWN;
    protected long lastGameTimeOfEventExecution;
    protected ResourceKey<Level> dimension;
    protected boolean isEventReocurring = false;
    protected boolean isEventActive = false;
    protected boolean toBeRemoved = false;

    public Event(ResourceKey<Level> dimension) {
        this.dimension = dimension;
    }

    public static Event createEvent(ResourceKey<Level> dimension) {
        return new Event(dimension);
    }

    public long getEventID() {
        return this.eventID;
    }

    public boolean canStart() {
        return this.getDimension().m_46467_() - this.lastGameTimeOfEventExecution > this.EXECUTION_COOLDOWN;
    }

    public boolean canContinue() {
        return false;
    }

    public void start() {
        SculkHorde.savedData.subtractSculkAccumulatedMass(this.eventCost);
        this.setEventActive(true);
    }

    public void serverTick() {
    }

    public void end() {
        if (!this.isEventReocurring) {
            this.toBeRemoved = true;
        }
        this.setEventActive(false);
        this.setLastGameTimeOfEventExecution(this.getDimension().m_46467_());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!Event.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        return this.eventID == ((Event)obj).eventID;
    }

    public void setEventLocation(BlockPos eventLocation) {
        this.eventLocation = eventLocation;
    }

    public BlockPos getEventLocation() {
        return this.eventLocation;
    }

    public Event setEventID(long eventID) {
        this.eventID = eventID;
        return this;
    }

    public Event setEventCost(int eventCost) {
        this.eventCost = eventCost;
        return this;
    }

    public Event setEXECUTION_COOLDOWN(long EXECUTION_COOLDOWN) {
        this.EXECUTION_COOLDOWN = EXECUTION_COOLDOWN;
        return this;
    }

    public Event setLastGameTimeOfEventExecution(long lastGameTimeOfEventExecution) {
        this.lastGameTimeOfEventExecution = lastGameTimeOfEventExecution;
        return this;
    }

    public Event setDimension(ResourceKey<Level> dimension) {
        this.dimension = dimension;
        return this;
    }

    public Event setEventReocurring(boolean isEventReocurring) {
        this.isEventReocurring = isEventReocurring;
        return this;
    }

    public Event setToBeRemoved(boolean toBeRemoved) {
        this.toBeRemoved = toBeRemoved;
        return this;
    }

    public Event setEventActive(boolean eventActive) {
        this.isEventActive = eventActive;
        return this;
    }

    public boolean isEventActive() {
        return this.isEventActive;
    }

    public int getEventCost() {
        return this.eventCost;
    }

    public long getEXECUTION_COOLDOWN() {
        return this.EXECUTION_COOLDOWN;
    }

    public long getLastGameTimeOfEventExecution() {
        return this.lastGameTimeOfEventExecution;
    }

    public ServerLevel getDimension() {
        return SculkHorde.savedData.level.m_7654_().m_129880_(this.dimension);
    }

    public boolean isEventReocurring() {
        return this.isEventReocurring;
    }

    public boolean isToBeRemoved() {
        return this.toBeRemoved;
    }

    public void save(CompoundTag tag) {
        tag.m_128356_("eventID", this.getEventID());
        tag.m_128405_("eventCost", this.getEventCost());
        tag.m_128356_("EXECUTION_COOLDOWN", this.getEXECUTION_COOLDOWN());
        tag.m_128356_("lastGameTimeOfEventExecution", this.getLastGameTimeOfEventExecution());
        tag.m_128379_("isEventReocurring", this.isEventReocurring());
        tag.m_128379_("isEventActive", this.isEventActive());
        tag.m_128379_("toBeRemoved", this.isToBeRemoved());
        tag.m_128359_("dimension", this.dimension.m_135782_().toString());
        tag.m_128356_("eventLocation", this.eventLocation.m_121878_());
    }

    public static Event load(CompoundTag tag) {
        ResourceKey dimensionResourceKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tag.m_128461_("dimension")));
        Event event = Event.createEvent((ResourceKey<Level>)dimensionResourceKey);
        event.setEventID(tag.m_128451_("eventID"));
        event.setEventCost(tag.m_128451_("eventCost"));
        event.setEXECUTION_COOLDOWN(tag.m_128454_("EXECUTION_COOLDOWN"));
        event.setLastGameTimeOfEventExecution(tag.m_128454_("lastGameTimeOfEventExecution"));
        event.setEventReocurring(tag.m_128471_("isEventReocurring"));
        event.setEventActive(tag.m_128471_("isEventActive"));
        event.setToBeRemoved(tag.m_128471_("toBeRemoved"));
        event.setEventLocation(BlockPos.m_122022_((long)tag.m_128454_("eventLocation")));
        return event;
    }
}

