/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.core.gravemind.entity_factory;

import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.core.gravemind.Gravemind;
import com.github.sculkhorde.core.gravemind.entity_factory.ReinforcementRequest;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;

public class EntityFactoryEntry {
    private int orderCost = 0;
    private EntityType entity = null;
    private int limit = Integer.MAX_VALUE;
    private StrategicValues[] strategicValues = new StrategicValues[0];
    private ReinforcementRequest.senderType[] explicitDeniedSenders = new ReinforcementRequest.senderType[0];
    private Gravemind.evolution_states minEvolutionRequired = Gravemind.evolution_states.Undeveloped;

    public EntityFactoryEntry(EntityType entity) {
        this.entity = entity;
    }

    public EntityType<Mob> getEntity() {
        return this.entity;
    }

    public EntityFactoryEntry setCost(int cost) {
        this.orderCost = cost;
        return this;
    }

    public int getCost() {
        return this.orderCost;
    }

    public EntityFactoryEntry setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public EntityFactoryEntry addStrategicValues(StrategicValues ... values) {
        this.strategicValues = values;
        return this;
    }

    public StrategicValues[] getStrategicValues() {
        return this.strategicValues;
    }

    public StrategicValues getFirstStrategicValue() {
        return this.strategicValues[0];
    }

    public EntityFactoryEntry setExplicitlyDeniedSenders(ReinforcementRequest.senderType ... deniedSenders) {
        this.explicitDeniedSenders = deniedSenders;
        return this;
    }

    public ReinforcementRequest.senderType[] getExplicitDeniedSenders() {
        return this.explicitDeniedSenders;
    }

    public EntityFactoryEntry setMinEvolutionRequired(Gravemind.evolution_states minEvolutionRequired) {
        this.minEvolutionRequired = minEvolutionRequired;
        return this;
    }

    public Gravemind.evolution_states getMinEvolutionRequired() {
        return this.minEvolutionRequired;
    }

    public boolean isSenderExplicitlyDenied(ReinforcementRequest.senderType sender) {
        for (ReinforcementRequest.senderType deniedSender : this.explicitDeniedSenders) {
            if (deniedSender != sender) continue;
            return true;
        }
        return false;
    }

    public boolean isEntryAppropriateMinimalCheck() {
        if (this.getCost() > SculkHorde.savedData.getSculkAccumulatedMass()) {
            return false;
        }
        return SculkHorde.gravemind.isEvolutionStateEqualOrLessThanCurrent(this.minEvolutionRequired);
    }

    public boolean doesEntityContainAnyRequiredStrategicValues(StrategicValues[] requiredValues) {
        for (StrategicValues value : requiredValues) {
            for (StrategicValues entityValue : this.strategicValues) {
                if (entityValue != value) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEntryAppropriate(ReinforcementRequest context) {
        boolean doesRequestSpecifyAnyApprovedMobTypes;
        if (context == null) {
            return false;
        }
        boolean isOverBudget = this.getCost() > context.budget && context.budget != -1;
        boolean doesHordeNotHaveEnoughMass = this.getCost() >= SculkHorde.savedData.getSculkAccumulatedMass();
        boolean isSenderExplicitlyDenied = this.isSenderExplicitlyDenied(context.sender);
        boolean isEvolutionStateNotMet = !SculkHorde.gravemind.isEvolutionStateEqualOrLessThanCurrent(this.minEvolutionRequired);
        boolean doesEntityNotContainAnyRequiredStrategicValues = !this.doesEntityContainAnyRequiredStrategicValues(context.approvedMobTypes);
        boolean bl = doesRequestSpecifyAnyApprovedMobTypes = context.approvedMobTypes.length > 0;
        if (doesHordeNotHaveEnoughMass || isOverBudget) {
            return false;
        }
        if (doesEntityNotContainAnyRequiredStrategicValues && doesRequestSpecifyAnyApprovedMobTypes) {
            return false;
        }
        if (isEvolutionStateNotMet) {
            return false;
        }
        return !isSenderExplicitlyDenied;
    }

    public Mob spawnEntity(ServerLevel level, BlockPos pos) {
        SculkHorde.savedData.subtractSculkAccumulatedMass(this.getCost());
        SculkHorde.statisticsData.incrementTotalUnitsSpawned();
        return (Mob)this.getEntity().m_262496_(level, pos, MobSpawnType.EVENT);
    }

    public static enum StrategicValues {
        Combat,
        Infector,
        Melee,
        Ranged,
        Boss,
        Support,
        Tank,
        Flying,
        Swimming;

    }
}

