/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.core.gravemind;

import com.github.sculkhorde.core.ModSavedData;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.core.gravemind.events.Event;
import com.github.sculkhorde.core.gravemind.events.SpawnPhantomsEvent;
import com.github.sculkhorde.util.TickUnits;
import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class SculkNodesHandler {
    protected boolean isActive = true;
    protected long TICK_COOLDOWN = TickUnits.convertMinutesToTicks(5);
    protected long lastTimeSinceTick = 0L;

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public boolean isActive() {
        return this.isActive;
    }

    protected ServerLevel getLevel() {
        return this.getSavedData().level;
    }

    protected ModSavedData getSavedData() {
        return SculkHorde.savedData;
    }

    protected ArrayList<ModSavedData.NodeEntry> getNodes() {
        return this.getSavedData().getNodeEntries();
    }

    protected ModSavedData.NodeEntry getNodeWithLongestTimeOfInactivity() {
        ModSavedData.NodeEntry nodeWithLongestTimeOfInactivity = null;
        for (ModSavedData.NodeEntry node : this.getNodes()) {
            boolean hasCurrentNodeNeverBeenActive;
            ServerLevel dimension = node.getDimension();
            if (dimension == null) {
                ModSavedData.NodeEntry nodeToRemove = node;
                SculkHorde.LOGGER.warn("Removing Node at: " + nodeToRemove.getPosition().toString() + " due to it being in a null dimension.");
                this.getNodes().remove(nodeToRemove);
                continue;
            }
            long currentTime = node.getDimension().m_46467_();
            long currentNodeDurationOfInactivity = currentTime - node.getLastTimeWasActive();
            long nodeWithLongestTimeOfInactivityDuration = nodeWithLongestTimeOfInactivity == null ? 0L : currentTime - nodeWithLongestTimeOfInactivity.getLastTimeWasActive();
            boolean hasCurrentNodeBeenInactiveForLonger = currentNodeDurationOfInactivity > nodeWithLongestTimeOfInactivityDuration;
            boolean bl = hasCurrentNodeNeverBeenActive = node.getLastTimeWasActive() == 0L;
            if (nodeWithLongestTimeOfInactivity == null) {
                nodeWithLongestTimeOfInactivity = node;
                continue;
            }
            if (!hasCurrentNodeBeenInactiveForLonger && !hasCurrentNodeNeverBeenActive || node.isActive()) continue;
            nodeWithLongestTimeOfInactivity = node;
        }
        return nodeWithLongestTimeOfInactivity;
    }

    protected boolean hasAnyNodeBeenActiveForTooLong() {
        for (ModSavedData.NodeEntry node : this.getNodes()) {
            ServerLevel dimension = node.getDimension();
            if (dimension == null) {
                ModSavedData.NodeEntry nodeToRemove = node;
                SculkHorde.LOGGER.warn("Removing Node at: " + nodeToRemove.getPosition().toString() + " due to it being in a null dimension.");
                this.getNodes().remove(nodeToRemove);
                continue;
            }
            long currentNodeDurationOfInactivity = node.getDimension().m_46467_() - node.getActivationTimeStamp();
            if (currentNodeDurationOfInactivity <= (long)TickUnits.convertHoursToTicks(1) || !node.isActive()) continue;
            return true;
        }
        return false;
    }

    protected boolean areAllNodesInactive() {
        for (ModSavedData.NodeEntry node : this.getNodes()) {
            if (!node.isActive()) continue;
            return false;
        }
        return true;
    }

    protected void ActivateNodeWithLongestDurationOfInactivity() {
        ModSavedData.NodeEntry nodeWithLongestTimeOfInactivity = this.getNodeWithLongestTimeOfInactivity();
        if (!nodeWithLongestTimeOfInactivity.isEntryValid()) {
            return;
        }
        nodeWithLongestTimeOfInactivity.setActive(true);
        nodeWithLongestTimeOfInactivity.setActivationTimeStamp(nodeWithLongestTimeOfInactivity.getDimension().m_46467_());
        SculkHorde.LOGGER.info("Activating Node at: " + nodeWithLongestTimeOfInactivity.getPosition().toString());
        Event phantomEvent = SpawnPhantomsEvent.createEvent((ResourceKey<Level>)nodeWithLongestTimeOfInactivity.getDimension().m_46472_());
        phantomEvent.setEventID(nodeWithLongestTimeOfInactivity.getPosition().m_121878_());
        phantomEvent.setEventLocation(nodeWithLongestTimeOfInactivity.getPosition());
        SculkHorde.eventHandler.addEvent(phantomEvent);
    }

    protected void DeactivateAllNodes() {
        for (ModSavedData.NodeEntry node : this.getNodes()) {
            ServerLevel dimension = node.getDimension();
            if (dimension == null) {
                ModSavedData.NodeEntry nodeToRemove = node;
                SculkHorde.LOGGER.warn("Removing Node at: " + nodeToRemove.getPosition().toString() + " due to it being in a null dimension.");
                this.getNodes().remove(nodeToRemove);
                continue;
            }
            if (!node.isActive()) continue;
            node.setActive(false);
            node.setLastTimeWasActive(node.getDimension().m_46467_());
            SculkHorde.LOGGER.info("Deactivating Node at: " + node.getPosition().toString());
        }
    }

    public void tick() {
        boolean isHordeDeactivated;
        boolean isSculkNodeHandlerNotActive = !this.isActive();
        boolean isSaveDataNull = this.getSavedData() == null;
        long timeElapsedSinceLastTick = this.getLevel().m_46467_() - this.lastTimeSinceTick;
        boolean isCooldownStillActive = timeElapsedSinceLastTick < this.TICK_COOLDOWN;
        boolean areThereNoNodes = this.getNodes().isEmpty();
        boolean bl = isHordeDeactivated = !this.getSavedData().isHordeActive();
        if (isHordeDeactivated || isSculkNodeHandlerNotActive || isSaveDataNull || areThereNoNodes || isCooldownStillActive) {
            return;
        }
        this.lastTimeSinceTick = this.getLevel().m_46467_();
        int maxActiveNodes = 1;
        boolean isThereMoreNodesThanMaxActiveNodes = this.getNodes().size() > maxActiveNodes;
        boolean hasAnyNodeBeenActiveForTooLong = this.hasAnyNodeBeenActiveForTooLong();
        boolean areAllNodesInactive = this.areAllNodesInactive();
        if (hasAnyNodeBeenActiveForTooLong && isThereMoreNodesThanMaxActiveNodes || areAllNodesInactive) {
            for (int i = 0; i < maxActiveNodes; ++i) {
                this.DeactivateAllNodes();
                this.ActivateNodeWithLongestDurationOfInactivity();
            }
        }
    }
}

