/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.core.gravemind;

import com.github.sculkhorde.common.entity.ISculkSmartEntity;
import com.github.sculkhorde.common.entity.SculkCreeperEntity;
import com.github.sculkhorde.common.entity.SculkPhantomEntity;
import com.github.sculkhorde.common.entity.SculkSporeSpewerEntity;
import com.github.sculkhorde.common.entity.boss.sculk_enderman.SculkEndermanEntity;
import com.github.sculkhorde.core.ModBlocks;
import com.github.sculkhorde.core.ModConfig;
import com.github.sculkhorde.core.ModEntities;
import com.github.sculkhorde.core.ModSavedData;
import com.github.sculkhorde.core.ModSounds;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.core.gravemind.DefaultRaidWavePatterns;
import com.github.sculkhorde.core.gravemind.Gravemind;
import com.github.sculkhorde.core.gravemind.RaidData;
import com.github.sculkhorde.core.gravemind.entity_factory.EntityFactory;
import com.github.sculkhorde.core.gravemind.entity_factory.EntityFactoryEntry;
import com.github.sculkhorde.util.BlockAlgorithms;
import com.github.sculkhorde.util.BlockSearcher;
import com.github.sculkhorde.util.ChunkLoading.BlockEntityChunkLoaderHelper;
import com.github.sculkhorde.util.TickUnits;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.ServerLifecycleHooks;

public class RaidHandler {
    public static RaidData raidData;
    private BlockPos scoutingLocation;
    private long MINIMUM_WAVE_LENGTH_TICKS = TickUnits.convertMinutesToTicks(2);

    public RaidHandler(ServerLevel levelIn) {
        if (raidData == null) {
            raidData = new RaidData();
        }
        raidData.setDimension((ResourceKey<Level>)levelIn.m_46472_());
    }

    public boolean canRaidStart() {
        boolean areThereNoPlayersOnServer;
        boolean areRaidsDisabled = (Boolean)ModConfig.SERVER.sculk_raid_enabled.get() == false;
        boolean isTheHordeDefeated = SculkHorde.savedData.isHordeDefeated();
        boolean isRaidCooldownNotOver = !SculkHorde.savedData.isRaidCooldownOver();
        boolean isTheGravemindInUndevelopedState = SculkHorde.gravemind.getEvolutionState() == Gravemind.evolution_states.Undeveloped;
        boolean areThereNoAreasOfInterest = SculkHorde.savedData.getAreasOfInterestEntries().isEmpty();
        boolean areThereNoAreasOfInterestNotInNoRaidZone = SculkHorde.savedData.getAreaOfInterestEntryNotInNoRaidZone().isEmpty();
        boolean bl = areThereNoPlayersOnServer = ServerLifecycleHooks.getCurrentServer().m_7416_() <= 0;
        return !areRaidsDisabled && !isTheHordeDefeated && !isRaidCooldownNotOver && !isTheGravemindInUndevelopedState && !areThereNoAreasOfInterest && !areThereNoAreasOfInterestNotInNoRaidZone && !areThereNoPlayersOnServer;
    }

    public boolean isRaidInactive() {
        return raidData.getRaidState() == RaidState.INACTIVE;
    }

    private String getFormattedCoordinates(BlockPos pos) {
        return "(" + pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_() + ")";
    }

    private String getFormattedDimension(ResourceKey<Level> dimension) {
        String languageKey = dimension.m_135782_().m_214299_();
        return Component.m_237115_((String)languageKey).getString();
    }

    private void announceToPlayersInRange(Component message, int range) {
        raidData.getDimension().m_6907_().forEach(player -> {
            if (BlockAlgorithms.getBlockDistanceXZ(raidData.getRaidLocation(), player.m_20183_()) <= (float)range) {
                player.m_5661_(message, false);
            }
        });
    }

    public boolean isCurrentObjectiveCompleted() {
        if (raidData.getDimension().m_8055_(raidData.getObjectiveLocation()).m_204336_(ModBlocks.BlockTags.SCULK_RAID_TARGET_HIGH_PRIORITY)) {
            return false;
        }
        if (raidData.getDimension().m_8055_(raidData.getObjectiveLocation()).m_204336_(ModBlocks.BlockTags.SCULK_RAID_TARGET_MEDIUM_PRIORITY)) {
            return false;
        }
        return !raidData.getDimension().m_8055_(raidData.getObjectiveLocation()).m_204336_(ModBlocks.BlockTags.SCULK_RAID_TARGET_LOW_PRIORITY);
    }

    public boolean isScoutingLocationLoaded() {
        return raidData.getDimension().isAreaLoaded(this.scoutingLocation, 3);
    }

    public boolean isRaidCenterLocationLoaded() {
        return raidData.getDimension().isAreaLoaded(raidData.getRaidCenter(), 5);
    }

    public boolean isSpawningLocationLoaded() {
        return raidData.getDimension().isAreaLoaded(raidData.getSpawnLocation(), 1);
    }

    public void loadRaidChunksCenter() {
        int distanceXBetweenRaidCenterAndSpawnPos = Math.abs(RaidHandler.raidData.raidCenter.m_123341_() - RaidHandler.raidData.spawnLocation.m_123341_());
        int distanceZBetweenRaidCenterAndSpawnPos = Math.abs(RaidHandler.raidData.raidCenter.m_123343_() - RaidHandler.raidData.spawnLocation.m_123343_());
        int lengthInBlocks = Math.max(distanceXBetweenRaidCenterAndSpawnPos, distanceZBetweenRaidCenterAndSpawnPos) * 2;
        int chunkLength = BlockAlgorithms.convertBlockLengthToChunkLength(lengthInBlocks);
        BlockEntityChunkLoaderHelper.getChunkLoaderHelper().removeRequestsWithOwner(raidData.getRaidCenter(), raidData.getDimension());
        BlockEntityChunkLoaderHelper.getChunkLoaderHelper().createChunkLoadRequestSquare(raidData.getDimension(), raidData.getRaidCenter(), chunkLength, 2, TickUnits.convertHoursToTicks(1));
    }

    public void loadScoutingChunks() {
        BlockEntityChunkLoaderHelper.getChunkLoaderHelper().createChunkLoadRequestSquare(raidData.getDimension(), this.scoutingLocation, 3, 2, TickUnits.convertHoursToTicks(1));
    }

    public void loadSpawningChunks() {
        BlockEntityChunkLoaderHelper.getChunkLoaderHelper().createChunkLoadRequestSquare(raidData.getDimension(), raidData.getSpawnLocation(), 5, 2, TickUnits.convertHoursToTicks(1));
    }

    public void bossBarTick() {
        if (raidData.getRaidState() != RaidState.ACTIVE_WAVE && raidData.getRaidState() != RaidState.INITIALIZING_WAVE) {
            return;
        }
        if (raidData.getBossEvent() == null) {
            raidData.setBossEvent(new ServerBossEvent((Component)Component.m_237113_((String)("Sculk Raid Wave " + raidData.getCurrentWave() + " / " + raidData.getMaxWaves())), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS));
            raidData.getBossEvent().m_7006_(true);
            raidData.getBossEvent().m_7003_(true);
        }
        for (ServerPlayer player : raidData.getDimension().m_6907_()) {
            boolean isPlayerInRangeOfRaid;
            boolean isPlayerInListAlready = raidData.getBossEvent().m_8324_().contains(player);
            boolean bl = isPlayerInRangeOfRaid = BlockAlgorithms.getBlockDistanceXZ(raidData.getRaidLocation(), player.m_20183_()) <= (float)Math.max(100, raidData.getCurrentRaidRadius() * 2);
            if (isPlayerInListAlready || !isPlayerInRangeOfRaid) continue;
            raidData.getBossEvent().m_6543_(player);
        }
        for (ServerPlayer player : raidData.getBossEvent().m_8324_()) {
            boolean isPlayerInRangeOfRaid = BlockAlgorithms.getBlockDistanceXZ(raidData.getRaidLocation(), player.m_20183_()) <= (float)Math.max(100, raidData.getCurrentRaidRadius() * 2);
            if (isPlayerInRangeOfRaid) continue;
            raidData.getBossEvent().m_6539_(player);
            break;
        }
        if (raidData.getRaidState() == RaidState.INITIALIZING_WAVE) {
            raidData.getBossEvent().m_142711_(0.0f);
            raidData.getBossEvent().m_6456_((Component)Component.m_237113_((String)("Sculk Raid Wave " + raidData.getCurrentWave() + " / " + raidData.getMaxWaves())));
        } else {
            raidData.getBossEvent().m_142711_(raidData.getWaveProgress());
        }
    }

    public void raidTick() {
        if (raidData.getTicksSpentTryingToChunkLoad() > RaidHandler.raidData.MAX_TICKS_SPENT_TRYING_TO_CHUNK_LOAD) {
            raidData.setFailure(failureType.FAILED_TO_LOAD_CHUNKS);
            return;
        }
        this.bossBarTick();
        switch (raidData.getRaidState()) {
            case INACTIVE: {
                this.inactiveRaidTick();
                break;
            }
            case INVESTIGATING_LOCATION: {
                this.investigatingLocationTick();
                break;
            }
            case ENDERMAN_SCOUTING: {
                this.endermanScoutingTick();
                break;
            }
            case INITIALIZING_RAID: {
                this.initializingRaidTick();
                break;
            }
            case INITIALIZING_WAVE: {
                this.initializingWaveTick();
                break;
            }
            case ACTIVE_WAVE: {
                this.activeWaveTick();
                break;
            }
            case COMPLETE: {
                this.completeRaidTick();
                break;
            }
            case FAILED: {
                this.failureRaidTick();
            }
        }
    }

    private void inactiveRaidTick() {
        SculkHorde.savedData.incrementTicksSinceLastRaid();
        if (this.canRaidStart()) {
            raidData.setRaidState(RaidState.INVESTIGATING_LOCATION);
        }
    }

    private void initializeBlockSearcherForInvestigateLocation(int searchIterationsPerTick, int maxTargets) {
        if (raidData.getAreaOfInterestEntry() == null) {
            Optional<ModSavedData.AreaofInterestEntry> possibleEntry = SculkHorde.savedData.getAreaOfInterestEntryNotInNoRaidZone();
            if (possibleEntry.isEmpty()) {
                raidData.setFailure(failureType.FAILED_INITIALIZATION);
                return;
            }
            if (!possibleEntry.get().isEntryValid()) {
                raidData.setFailure(failureType.FAILED_INITIALIZATION);
                return;
            }
            raidData.setAreaOfInterestEntry(possibleEntry.get());
        }
        ModSavedData.AreaofInterestEntry areaOfInterestEntry = raidData.getAreaOfInterestEntry();
        ServerLevel dimension = areaOfInterestEntry.getDimension();
        ResourceKey dimensionResourceKey = dimension.m_46472_();
        raidData.setDimension((ResourceKey<Level>)dimensionResourceKey);
        SculkHorde.LOGGER.info("RaidHandler | Investigating Location at: " + this.getFormattedCoordinates(areaOfInterestEntry.getPosition()) + " in dimension " + this.getFormattedDimension((ResourceKey<Level>)dimensionResourceKey) + ".");
        raidData.setBlockSearcher(new BlockSearcher(dimension, areaOfInterestEntry.getPosition()));
        raidData.getBlockSearcher().setMaxDistance(raidData.getCurrentRaidRadius());
        RaidHandler.raidData.getBlockSearcher().searchIterationsPerTick = searchIterationsPerTick;
        RaidHandler.raidData.getBlockSearcher().ignoreBlocksNearTargets = true;
        raidData.getBlockSearcher().setTargetBlockPredicate(RaidHandler.raidData.isTargetInvestigateLocationState);
        raidData.getBlockSearcher().setObstructionPredicate(RaidHandler.raidData.isObstructedInvestigateLocationState);
        RaidHandler.raidData.getBlockSearcher().MAX_TARGETS = maxTargets;
    }

    private void initializeBlockSearcherForSpawnSearch(int searchIterationsPerTick, int maxTargets) {
        raidData.setBlockSearcher(new BlockSearcher(raidData.getDimension(), raidData.getRaidLocation()));
        raidData.getBlockSearcher().setMaxDistance(raidData.getCurrentRaidRadius());
        raidData.getBlockSearcher().setTargetBlockPredicate(RaidHandler.raidData.isSpawnTarget);
        raidData.getBlockSearcher().setObstructionPredicate(RaidHandler.raidData.isSpawnObstructed);
        raidData.getBlockSearcher().setMaxTargets(1);
        raidData.getBlockSearcher().setPositionToMoveAwayFrom(raidData.getRaidCenter());
        RaidHandler.raidData.getBlockSearcher().searchIterationsPerTick = searchIterationsPerTick;
        RaidHandler.raidData.getBlockSearcher().MAX_TARGETS = maxTargets;
    }

    private void investigatingLocationTick() {
        if (raidData.getBlockSearcher() == null) {
            this.initializeBlockSearcherForInvestigateLocation(100, 30);
        }
        raidData.getBlockSearcher().tick();
        if (!RaidHandler.raidData.getBlockSearcher().isFinished) {
            return;
        }
        if (RaidHandler.raidData.getBlockSearcher().isSuccessful) {
            raidData.getFoundTargetsFromBlockSearcher(RaidHandler.raidData.getBlockSearcher().foundTargets);
            raidData.setMaxWaves(10);
            raidData.setRaidLocation(raidData.getAreaOfInterestEntry().getPosition());
            SculkHorde.LOGGER.info("RaidHandler | Found " + (raidData.getHighPriorityTargets().size() + raidData.getMediumPriorityTargets().size()) + " objective targets in " + raidData.getAreaOfInterestEntry().getPosition() + " in dimension " + raidData.getDimension().m_46472_());
            raidData.setRaidState(RaidState.ENDERMAN_SCOUTING);
        } else {
            raidData.setFailure(failureType.FAILED_INITIALIZATION);
            SculkHorde.LOGGER.info("RaidHandler | Found no objective targets in dimension" + raidData.getDimensionResourceKey() + ". Not Initializing Raid.");
        }
        raidData.setBlockSearcher(null);
    }

    private static void spawnSculkPhantomsAtTopOfWorld(ServerLevel level, BlockPos origin, int amount) {
        int spawnRange = 100;
        int minimumSpawnRange = 50;
        Random rng = new Random();
        for (int i = 0; i < amount; ++i) {
            int x = minimumSpawnRange + rng.nextInt(spawnRange) - spawnRange / 2;
            int z = minimumSpawnRange + rng.nextInt(spawnRange) - spawnRange / 2;
            int y = level.m_151558_();
            BlockPos spawnPosition = new BlockPos(origin.m_123341_() + x, y, origin.m_123343_() + z);
            SculkPhantomEntity.spawnPhantom((Level)level, spawnPosition, true);
        }
    }

    private void endermanScoutingTick() {
        if (this.scoutingLocation == null) {
            this.scoutingLocation = raidData.getAreaOfInterestEntry().getPosition();
            this.loadScoutingChunks();
            SculkHorde.LOGGER.info("RaidHandler | Scouting Location: " + this.getFormattedCoordinates(this.scoutingLocation));
            SculkHorde.LOGGER.info("RaidHandler | Scouting Location Loaded: " + this.isScoutingLocationLoaded());
        }
        if (!this.isScoutingLocationLoaded()) {
            this.loadScoutingChunks();
            raidData.incrementTicksSpentTryingToChunkLoad();
            return;
        }
        raidData.incrementTimeElapsedScouting();
        if (raidData.getScoutEnderman() == null) {
            SculkHorde.LOGGER.info("RaidHandler | Scouting Location Is Loaded. Continuing.");
            raidData.setScoutEnderman(new SculkEndermanEntity((Level)raidData.getDimension(), this.scoutingLocation));
            raidData.getDimension().m_7967_((Entity)raidData.getScoutEnderman());
            raidData.getScoutEnderman().setScouting(true);
            SculkHorde.LOGGER.info("RaidHandler | Sculk Enderman Scouting at " + this.getFormattedCoordinates(RaidHandler.raidData.areaOfInterestEntry.getPosition()) + " in the " + raidData.getDimensionResourceKey() + " for " + ModConfig.SERVER.sculk_raid_enderman_scouting_duration_minutes.get() + " minutes");
            this.announceToPlayersInRange((Component)Component.m_237113_((String)("A Sculk Infested Enderman is scouting out a possible raid location at " + this.getFormattedCoordinates(RaidHandler.raidData.areaOfInterestEntry.getPosition()) + " in the " + this.getFormattedDimension(raidData.getDimensionResourceKey()) + ". Kill it to stop the raid from happening!")), raidData.getCurrentRaidRadius() * 8);
            raidData.getScoutEnderman().m_7292_(new MobEffectInstance(MobEffects.f_19619_, TickUnits.convertMinutesToTicks(15), 0));
            this.playSoundForEveryPlayer((SoundEvent)ModSounds.RAID_SCOUT_SOUND.get(), 1.0f, 1.0f);
            RaidHandler.spawnSculkPhantomsAtTopOfWorld(raidData.getDimension(), raidData.getAreaOfInterestEntry().getPosition(), 5);
        }
        if (!raidData.getScoutEnderman().m_6084_()) {
            raidData.setFailure(failureType.ENDERMAN_DEFEATED);
            return;
        }
        if (raidData.getTimeElapsedScouting() >= TickUnits.convertMinutesToTicks((Integer)ModConfig.SERVER.sculk_raid_enderman_scouting_duration_minutes.get())) {
            raidData.setRaidState(RaidState.INITIALIZING_RAID);
            raidData.getScoutEnderman().m_146870_();
            raidData.setScoutEnderman(null);
        }
    }

    private void setRaidCenterToCentroidOfAllTargets() {
        ArrayList<BlockPos> allTargets = new ArrayList<BlockPos>();
        allTargets.addAll(raidData.getHighPriorityTargets());
        allTargets.addAll(raidData.getMediumPriorityTargets());
        raidData.setRaidCenter(BlockAlgorithms.getCentroid(allTargets));
    }

    private void initializingRaidTick() {
        SculkHorde.savedData.setTicksSinceLastRaid(0);
        if (raidData.getBlockSearcher() == null) {
            SculkHorde.LOGGER.info("RaidHandler | Scouting Location Loaded: " + this.isScoutingLocationLoaded());
            if (raidData.getHighPriorityTargets().size() + raidData.getMediumPriorityTargets().size() <= 0) {
                raidData.setFailure(failureType.FAILED_INITIALIZATION);
                return;
            }
            this.setRaidCenterToCentroidOfAllTargets();
            this.initializeBlockSearcherForSpawnSearch(100, 1);
            SculkHorde.LOGGER.info("RaidHandler | Initializing Block Searcher");
        }
        this.scoutingLocation = raidData.getAreaOfInterestEntry().getPosition();
        if (!this.isScoutingLocationLoaded()) {
            this.loadScoutingChunks();
            raidData.incrementTicksSpentTryingToChunkLoad();
            return;
        }
        raidData.getBlockSearcher().tick();
        if (!RaidHandler.raidData.getBlockSearcher().isFinished) {
            return;
        }
        if (RaidHandler.raidData.getBlockSearcher().isSuccessful) {
            raidData.setRaidState(RaidState.INITIALIZING_WAVE);
            SculkHorde.LOGGER.info("RaidHandler | Found Spawn Location at " + this.getFormattedCoordinates(raidData.getSpawnLocation()) + " in " + raidData.getBlockSearcher().getDimension().m_46472_() + ". Initializing Raid.");
            raidData.setNextObjectiveLocation();
            raidData.setSpawnLocation(RaidHandler.raidData.getBlockSearcher().foundTargets.get(0));
            raidData.setCurrentRaidRadius(raidData.getDistanceOfFurthestObjective());
            SculkHorde.LOGGER.info("RaidHandler | Current Raid Radius: " + raidData.getCurrentRaidRadius());
            this.loadRaidChunksCenter();
            this.announceToPlayersInRange((Component)Component.m_237113_((String)("The Sculk Horde is Raiding " + this.getFormattedCoordinates(raidData.getRaidLocation()) + " in the " + this.getFormattedDimension(raidData.getDimensionResourceKey()) + "!")), raidData.getCurrentRaidRadius() * 8);
        } else {
            raidData.setRaidState(RaidState.FAILED);
            SculkHorde.LOGGER.info("RaidHandler | Unable to Find Spawn Location. Not Initializing Raid.");
        }
    }

    private void playSoundForEachPlayerInRange(SoundEvent soundEvent, float volume, float pitch, int range) {
        raidData.getDimension().m_6907_().forEach(player -> {
            if (BlockAlgorithms.getBlockDistanceXZ(raidData.getRaidLocation(), player.m_20183_()) <= (float)range || SculkHorde.isDebugMode()) {
                raidData.getDimension().m_5594_(null, player.m_20183_(), soundEvent, SoundSource.HOSTILE, volume, pitch);
            }
        });
    }

    private void playSoundForEveryPlayer(SoundEvent soundEvent, float volume, float pitch) {
        ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_().forEach(player -> raidData.getDimension().m_5594_(null, player.m_20183_(), soundEvent, SoundSource.HOSTILE, volume, pitch));
    }

    private void spawnWaveParticipants(BlockPos spawnLocation) {
        SculkSporeSpewerEntity sporeSpewer = new SculkSporeSpewerEntity((EntityType<? extends SculkSporeSpewerEntity>)((EntityType)ModEntities.SCULK_SPORE_SPEWER.get()), (Level)raidData.getDimension());
        sporeSpewer.m_6034_(spawnLocation.m_123341_(), spawnLocation.m_123342_() + 1, spawnLocation.m_123343_());
        raidData.getDimension().m_7967_((Entity)sporeSpewer);
        raidData.getWaveParticipants().forEach(raidParticipant -> {
            raidParticipant.setParticipatingInRaid(true);
            ((Mob)raidParticipant).m_6034_((double)spawnLocation.m_123341_(), (double)(spawnLocation.m_123342_() + 1), (double)spawnLocation.m_123343_());
            raidData.getDimension().m_7967_((Entity)raidParticipant);
            ((Mob)raidParticipant).m_7292_(new MobEffectInstance(MobEffects.f_19619_, TickUnits.convertMinutesToTicks(15), 0));
        });
    }

    private void initializingWaveTick() {
        raidData.setWaveDuration(0);
        raidData.setCurrentWavePattern(this.getWavePattern());
        if (!this.isSpawningLocationLoaded()) {
            this.loadSpawningChunks();
            raidData.incrementTicksSpentTryingToChunkLoad();
            return;
        }
        if (!this.isRaidCenterLocationLoaded()) {
            this.loadRaidChunksCenter();
            raidData.incrementTicksSpentTryingToChunkLoad();
            return;
        }
        this.populateRaidParticipants(raidData.getSpawnLocation());
        this.announceToPlayersInRange((Component)Component.m_237113_((String)(" Starting Wave " + raidData.getCurrentWave() + " out of " + raidData.getMaxWaves() + ".")), raidData.getCurrentRaidRadius() * 8);
        this.spawnWaveParticipants(raidData.getSpawnLocation());
        this.playSoundForEachPlayerInRange((SoundEvent)ModSounds.RAID_START_SOUND.get(), 1.0f, 1.0f, raidData.getCurrentRaidRadius() * 4);
        if (raidData.getObjectiveLocationAtStartOfWave().equals((Object)raidData.getObjectiveLocation())) {
            raidData.setNextObjectiveLocation();
        }
        raidData.setObjectiveLocationAtStartOfWave(raidData.getObjectiveLocation());
        SculkHorde.LOGGER.info("RaidHandler | Spawning mobs at: " + raidData.getSpawnLocation());
        raidData.setRaidState(RaidState.ACTIVE_WAVE);
    }

    protected boolean isLastWave(int offset) {
        return raidData.getCurrentWave() >= raidData.getMaxWaves() + offset;
    }

    protected void endWave() {
        raidData.incrementCurrentWave();
        if (this.isLastWave(1)) {
            raidData.setFailure(failureType.FAILED_OBJECTIVE_COMPLETION);
            this.announceToPlayersInRange((Component)Component.m_237113_((String)"Final Wave Complete."), raidData.getCurrentRaidRadius() * 8);
            return;
        }
        this.announceToPlayersInRange((Component)Component.m_237113_((String)("Wave " + raidData.getCurrentWave() + " complete.")), raidData.getCurrentRaidRadius() * 8);
        raidData.setRaidState(RaidState.INITIALIZING_WAVE);
    }

    protected void activeWaveTick() {
        if (!this.isSpawningLocationLoaded()) {
            this.loadSpawningChunks();
            raidData.incrementTicksSpentTryingToChunkLoad();
            return;
        }
        if (!this.isRaidCenterLocationLoaded()) {
            this.loadRaidChunksCenter();
            raidData.incrementTicksSpentTryingToChunkLoad();
            return;
        }
        raidData.updateRemainingWaveParticipantsAmount();
        raidData.incrementWaveDuration();
        if (raidData.getWaveDuration() >= raidData.getMAX_WAVE_DURATION() && (long)raidData.getWaveDuration() >= this.MINIMUM_WAVE_LENGTH_TICKS) {
            this.endWave();
            raidData.removeWaveParticipantsFromList();
        }
        if (raidData.areWaveParticipantsDead()) {
            this.endWave();
        }
        if (this.isCurrentObjectiveCompleted()) {
            raidData.setNextObjectiveLocation();
            raidData.getDimension().m_6907_().forEach(player -> raidData.getDimension().m_5594_(null, player.m_20183_(), SoundEvents.f_11700_, SoundSource.AMBIENT, 1.0f, 1.0f));
        }
    }

    private void completeRaidTick() {
        SculkHorde.savedData.addNoRaidZoneToMemory(raidData.getDimension(), raidData.getRaidLocation());
        SculkHorde.LOGGER.info("RaidHandler | Raid Complete.");
        this.announceToPlayersInRange((Component)Component.m_237113_((String)"The Sculk Horde's raid was successful!"), raidData.getCurrentRaidRadius() * 8);
        SculkSporeSpewerEntity sporeSpewer = new SculkSporeSpewerEntity((EntityType<? extends SculkSporeSpewerEntity>)((EntityType)ModEntities.SCULK_SPORE_SPEWER.get()), (Level)raidData.getDimension());
        sporeSpewer.m_6034_(raidData.getRaidLocation().m_123341_(), raidData.getRaidLocation().m_123342_(), raidData.getRaidLocation().m_123343_());
        raidData.getDimension().m_7967_((Entity)sporeSpewer);
        raidData.reset();
    }

    private void failureRaidTick() {
        switch (raidData.getFailure()) {
            case FAILED_OBJECTIVE_COMPLETION: {
                SculkHorde.LOGGER.info("RaidHandler | Raid Failed. Objectives Not Destroyed.");
                this.announceToPlayersInRange((Component)Component.m_237113_((String)"The Sculk Horde has failed to destroy all objectives!"), raidData.getCurrentRaidRadius() * 8);
                raidData.getDimension().m_6907_().forEach(player -> raidData.getDimension().m_5594_(null, player.m_20183_(), SoundEvents.f_12496_, SoundSource.AMBIENT, 1.0f, 7.0f));
                break;
            }
            case ENDERMAN_DEFEATED: {
                SculkHorde.LOGGER.info("RaidHandler | Raid Failed. Sculk Enderman Defeated.");
                this.announceToPlayersInRange((Component)Component.m_237113_((String)"The Sculk Horde has failed to scout out a potential raid location. Raid Prevented!"), raidData.getCurrentRaidRadius() * 8);
                raidData.getDimension().m_6907_().forEach(player -> raidData.getDimension().m_5594_(null, player.m_20183_(), SoundEvents.f_12496_, SoundSource.AMBIENT, 1.0f, 7.0f));
                break;
            }
            case FAILED_INITIALIZATION: {
                SculkHorde.LOGGER.info("RaidHandler | Raid Failed. Unable to Initialize.");
                this.announceToPlayersInRange((Component)Component.m_237113_((String)"The Sculk Horde has failed to find a suitable way to raid the location. Raid Prevented!"), raidData.getCurrentRaidRadius() * 8);
                raidData.getDimension().m_6907_().forEach(player -> raidData.getDimension().m_5594_(null, player.m_20183_(), SoundEvents.f_12496_, SoundSource.AMBIENT, 1.0f, 7.0f));
                break;
            }
            case FAILED_TO_LOAD_CHUNKS: {
                SculkHorde.LOGGER.info("RaidHandler | Raid Failed. Unable to Load Chunks.");
                this.announceToPlayersInRange((Component)Component.m_237113_((String)"The Sculk Horde has failed to load the chunks required to raid the location. Raid Prevented!"), raidData.getCurrentRaidRadius() * 8);
                raidData.getDimension().m_6907_().forEach(player -> raidData.getDimension().m_5594_(null, player.m_20183_(), SoundEvents.f_12496_, SoundSource.AMBIENT, 1.0f, 7.0f));
                break;
            }
            case NONE: {
                SculkHorde.LOGGER.error("RaidHandler | Raid Failed. Unknown Reason.");
            }
        }
        if (raidData.getRaidLocation() != null && raidData.getRaidLocation() != BlockPos.f_121853_ && raidData.getRaidLocation() != null) {
            SculkHorde.savedData.addNoRaidZoneToMemory(raidData.getDimension(), raidData.getRaidLocation());
        }
        raidData.reset();
    }

    private Predicate<EntityFactoryEntry> isValidRaidParticipant(EntityFactoryEntry.StrategicValues strategicValue) {
        return entityFactoryEntry -> entityFactoryEntry.doesEntityContainAnyRequiredStrategicValues(new EntityFactoryEntry.StrategicValues[]{strategicValue});
    }

    public EntityFactoryEntry.StrategicValues[] getWavePattern() {
        EntityFactoryEntry.StrategicValues[][] possibleWavePatterns = new EntityFactoryEntry.StrategicValues[][]{DefaultRaidWavePatterns.FIVE_RANGED_FIVE_MELEE, DefaultRaidWavePatterns.TEN_RANGED, DefaultRaidWavePatterns.TEN_MELEE};
        Random random = new Random();
        return possibleWavePatterns[random.nextInt(possibleWavePatterns.length)];
    }

    private void populateRaidParticipants(BlockPos spawnLocation) {
        int i;
        for (i = 0; i < this.getWavePattern().length; ++i) {
            Optional<EntityFactoryEntry> randomEntry = EntityFactory.getRandomEntry(this.isValidRaidParticipant(this.getWavePattern()[i]));
            if (randomEntry.isEmpty()) {
                SculkHorde.LOGGER.info("RaidHandler | Unable to find valid entity for raid.");
                raidData.setRaidState(RaidState.INITIALIZING_RAID);
                return;
            }
            raidData.getWaveParticipants().add((ISculkSmartEntity)randomEntry.get().spawnEntity(raidData.getDimension(), spawnLocation));
        }
        for (i = 0; i < 6; ++i) {
            SculkCreeperEntity creeper = (SculkCreeperEntity)((EntityType)ModEntities.SCULK_CREEPER.get()).m_20615_((Level)raidData.getDimension());
            creeper.m_6034_(spawnLocation.m_123341_(), spawnLocation.m_123342_() + 1, spawnLocation.m_123343_());
            raidData.getWaveParticipants().add(creeper);
        }
        if (this.isLastWave(0)) {
            Mob boss = (Mob)((EntityType)ModEntities.SCULK_ENDERMAN.get()).m_20615_((Level)raidData.getDimension());
            boss.m_6034_((double)spawnLocation.m_123341_(), (double)(spawnLocation.m_123342_() + 1), (double)spawnLocation.m_123343_());
            raidData.getWaveParticipants().add((ISculkSmartEntity)boss);
        }
    }

    public static enum RaidState {
        INACTIVE,
        INVESTIGATING_LOCATION,
        ENDERMAN_SCOUTING,
        INITIALIZING_RAID,
        INITIALIZING_WAVE,
        ACTIVE_WAVE,
        COMPLETE,
        FAILED;

    }

    protected static enum failureType {
        NONE,
        FAILED_INITIALIZATION,
        ENDERMAN_DEFEATED,
        FAILED_OBJECTIVE_COMPLETION,
        FAILED_TO_LOAD_CHUNKS;

    }
}

