/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.core.gravemind;

import com.github.sculkhorde.common.entity.ISculkSmartEntity;
import com.github.sculkhorde.common.entity.boss.sculk_enderman.SculkEndermanEntity;
import com.github.sculkhorde.core.ModBlocks;
import com.github.sculkhorde.core.ModConfig;
import com.github.sculkhorde.core.ModSavedData;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.core.gravemind.RaidHandler;
import com.github.sculkhorde.core.gravemind.entity_factory.EntityFactoryEntry;
import com.github.sculkhorde.util.BlockAlgorithms;
import com.github.sculkhorde.util.BlockSearcher;
import com.github.sculkhorde.util.ChunkLoading.BlockEntityChunkLoaderHelper;
import com.github.sculkhorde.util.TickUnits;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.server.ServerLifecycleHooks;

public class RaidData {
    protected int MAX_WAVE_DURATION = TickUnits.convertMinutesToTicks(5);
    protected int waveDuration = 0;
    private int timeElapsedScouting = 0;
    private ResourceKey<Level> dimension;
    protected BlockPos spawnLocation = BlockPos.f_121853_;
    protected BlockPos raidLocation = BlockPos.f_121853_;
    protected BlockPos objectiveLocation;
    protected BlockPos objectiveLocationAtStartOfWave = this.objectiveLocation = BlockPos.f_121853_;
    protected BlockPos raidCenter = BlockPos.f_121853_;
    protected static int MINIMUM_RAID_RADIUS = 200;
    protected int currentRaidRadius = MINIMUM_RAID_RADIUS;
    protected static int MAXIMUM_RAID_RADIUS = 500;
    protected ArrayList<ISculkSmartEntity> waveParticipants = new ArrayList();
    private RaidHandler.RaidState raidState = RaidHandler.RaidState.INACTIVE;
    protected RaidHandler.failureType failure = RaidHandler.failureType.NONE;
    private SculkEndermanEntity scoutEnderman = null;
    protected ServerBossEvent bossEvent;
    protected EntityFactoryEntry.StrategicValues[] currentWavePattern;
    private int maxWaves = 2;
    private int currentWave = 1;
    private int remainingWaveParticipants = 0;
    protected ModSavedData.AreaofInterestEntry areaOfInterestEntry;
    private static final ArrayList<BlockPos> high_priority_targets = new ArrayList();
    private static final ArrayList<BlockPos> medium_priority_targets = new ArrayList();
    private BlockSearcher blockSearcher;
    private int ticksSpentTryingToChunkLoad;
    public int MAX_TICKS_SPENT_TRYING_TO_CHUNK_LOAD = TickUnits.convertMinutesToTicks(15);
    public final Predicate<BlockPos> isSpawnObstructed = blockPos -> {
        if (Math.abs(blockPos.m_123342_() - this.raidLocation.m_123342_()) > 15) {
            return true;
        }
        if (this.getDimension().m_8055_(blockPos).m_60795_() || this.getDimension().m_8055_(blockPos).m_60713_(Blocks.f_49990_) || this.getDimension().m_8055_(blockPos).m_60713_(Blocks.f_49991_)) {
            return true;
        }
        if (!this.getDimension().m_8055_(blockPos.m_7494_()).m_247087_() || this.getDimension().m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_49990_) || this.getDimension().m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_49991_)) {
            return true;
        }
        if (!this.getDimension().m_8055_(blockPos.m_7494_()).m_247087_() || this.getDimension().m_8055_(blockPos.m_6630_(1)).m_60713_(Blocks.f_49990_) || this.getDimension().m_8055_(blockPos.m_6630_(1)).m_60713_(Blocks.f_49991_)) {
            return true;
        }
        return !this.getDimension().m_8055_(blockPos.m_7494_()).m_247087_() || this.getDimension().m_8055_(blockPos.m_6630_(2)).m_60713_(Blocks.f_49990_) || this.getDimension().m_8055_(blockPos.m_6630_(2)).m_60713_(Blocks.f_49991_);
    };
    public final Predicate<BlockPos> isSpawnTarget = blockPos -> (double)BlockAlgorithms.getBlockDistance(blockPos, this.raidLocation) > (double)this.getCurrentRaidRadius() * 0.75 && BlockAlgorithms.isAreaFlat(this.getDimension(), blockPos, 2);
    public final Predicate<BlockPos> isObstructedInvestigateLocationState = blockPos -> {
        if (this.blockSearcher.foundTargets.isEmpty() && BlockAlgorithms.getBlockDistance(this.areaOfInterestEntry.getPosition(), blockPos) > (float)MAXIMUM_RAID_RADIUS) {
            return true;
        }
        if (this.getDimension().m_8055_(blockPos).m_60713_(Blocks.f_50016_)) {
            return true;
        }
        if (!this.blockSearcher.foundTargets.isEmpty() && !this.blockSearcher.isAnyTargetCloserThan((BlockPos)blockPos, 25)) {
            return true;
        }
        return !BlockAlgorithms.isExposedToAir(this.getDimension(), blockPos);
    };
    public final Predicate<BlockPos> isTargetInvestigateLocationState = blockPos -> {
        boolean isTarget;
        boolean bl = isTarget = this.getDimension().m_8055_(blockPos).m_204336_(ModBlocks.BlockTags.SCULK_RAID_TARGET_HIGH_PRIORITY) || this.getDimension().m_8055_(blockPos).m_204336_(ModBlocks.BlockTags.SCULK_RAID_TARGET_LOW_PRIORITY) || this.getDimension().m_8055_(blockPos).m_204336_(ModBlocks.BlockTags.SCULK_RAID_TARGET_MEDIUM_PRIORITY);
        if (isTarget && BlockAlgorithms.getBlockDistance(this.getAreaOfInterestEntry().getPosition(), blockPos) > (float)this.getCurrentRaidRadius()) {
            this.setCurrentRaidRadius((int)BlockAlgorithms.getBlockDistance(this.getRaidLocation(), blockPos));
            SculkHorde.LOGGER.debug("Raid Radius is now " + this.getCurrentRaidRadius() + " blocks.");
        }
        if (isTarget && !this.blockSearcher.foundTargets.isEmpty() && this.blockSearcher.isAnyTargetCloserThan((BlockPos)blockPos, 5)) {
            return false;
        }
        return isTarget;
    };

    public ArrayList<BlockPos> getHighPriorityTargets() {
        return high_priority_targets;
    }

    public ArrayList<BlockPos> getMediumPriorityTargets() {
        return medium_priority_targets;
    }

    public ServerLevel getDimension() {
        return ServerLifecycleHooks.getCurrentServer().m_129880_(this.dimension);
    }

    public ResourceKey<Level> getDimensionResourceKey() {
        return this.dimension;
    }

    public void setDimension(ResourceKey<Level> dimension) {
        this.dimension = dimension;
        SculkHorde.savedData.m_77762_();
    }

    public void getFoundTargetsFromBlockSearcher(ArrayList<BlockPos> foundTargets) {
        high_priority_targets.clear();
        medium_priority_targets.clear();
        for (BlockPos blockPos2 : foundTargets) {
            if (this.getDimension().m_8055_(blockPos2).m_204336_(ModBlocks.BlockTags.SCULK_RAID_TARGET_HIGH_PRIORITY)) {
                high_priority_targets.add(blockPos2);
                continue;
            }
            if (!this.getDimension().m_8055_(blockPos2).m_204336_(ModBlocks.BlockTags.SCULK_RAID_TARGET_LOW_PRIORITY)) continue;
            medium_priority_targets.add(blockPos2);
        }
        high_priority_targets.sort((blockPos, t1) -> (int)(blockPos.m_123331_((Vec3i)this.blockSearcher.origin) - t1.m_123331_((Vec3i)this.getRaidLocation())));
        medium_priority_targets.sort((blockPos, t1) -> (int)(blockPos.m_123331_((Vec3i)this.blockSearcher.origin) - t1.m_123331_((Vec3i)this.getRaidLocation())));
    }

    public Optional<BlockPos> popObjectiveLocation() {
        Optional<BlockPos> objective = Optional.empty();
        if (!high_priority_targets.isEmpty()) {
            objective = Optional.of(high_priority_targets.get(0));
            high_priority_targets.remove(0);
        } else if (!medium_priority_targets.isEmpty()) {
            objective = Optional.of(medium_priority_targets.get(0));
            medium_priority_targets.remove(0);
        }
        return objective;
    }

    public void reset() {
        if (this.areaOfInterestEntry != null) {
            SculkHorde.savedData.removeAreaOfInterestFromMemory(this.areaOfInterestEntry.getPosition());
        }
        this.areaOfInterestEntry = null;
        if (this.getRaidLocation() != null) {
            BlockEntityChunkLoaderHelper.getChunkLoaderHelper().removeRequestsWithOwner(this.getRaidLocation(), this.getDimension());
        }
        if (this.getSpawnLocation() != null) {
            BlockEntityChunkLoaderHelper.getChunkLoaderHelper().removeRequestsWithOwner(this.getSpawnLocation(), this.getDimension());
        }
        this.setBlockSearcher(null);
        this.setRaidState(RaidHandler.RaidState.INACTIVE);
        this.setRaidLocation(BlockPos.f_121853_);
        this.setObjectiveLocation(BlockPos.f_121853_);
        this.setSpawnLocation(BlockPos.f_121853_);
        this.waveParticipants.clear();
        this.setRemainingWaveParticipants(0);
        this.setCurrentWave(1);
        this.setScoutEnderman(null);
        this.setTimeElapsedScouting(0);
        this.setCurrentRaidRadius(MINIMUM_RAID_RADIUS);
        SculkHorde.savedData.m_77762_();
        this.dimension = null;
        if (this.bossEvent != null) {
            this.bossEvent.m_7706_();
        }
        this.bossEvent = null;
        this.resetTicksSpentTryingToChunkLoad();
    }

    public void startRaidArtificially(ServerLevel level, BlockPos raidLocationIn) {
        if (SculkHorde.savedData.getSculkAccumulatedMass() < (Integer)ModConfig.SERVER.gravemind_mass_goal_for_immature_stage.get() + 1000) {
            SculkHorde.savedData.setSculkAccumulatedMass((Integer)ModConfig.SERVER.gravemind_mass_goal_for_immature_stage.get() + 1000);
            SculkHorde.gravemind.calulateCurrentState();
            SculkHorde.LOGGER.info("Artificially Starting Raid. Mass is now: " + SculkHorde.savedData.getSculkAccumulatedMass());
            SculkHorde.LOGGER.info("Artificially Starting Raid. Gravemind is now in state: " + SculkHorde.gravemind.getEvolutionState());
        }
        this.removeNoRaidZoneAtBlockPos(level, raidLocationIn);
        Optional<ModSavedData.AreaofInterestEntry> possibleAreaOfInterestEntry = SculkHorde.savedData.addAreaOfInterestToMemory(level, raidLocationIn);
        if (possibleAreaOfInterestEntry.isPresent()) {
            this.setAreaOfInterestEntry(possibleAreaOfInterestEntry.get());
            this.setRaidState(RaidHandler.RaidState.INVESTIGATING_LOCATION);
            SculkHorde.savedData.setTicksSinceLastRaid(TickUnits.convertMinutesToTicks((Integer)ModConfig.SERVER.sculk_raid_global_cooldown_between_raids_minutes.get()));
        } else {
            this.reset();
        }
    }

    public void removeNoRaidZoneAtBlockPos(ServerLevel level, BlockPos pos) {
        SculkHorde.savedData.getNoRaidZoneEntries().removeIf(entry -> entry.isBlockPosInRadius(level, pos));
    }

    public int getTicksSpentTryingToChunkLoad() {
        return this.ticksSpentTryingToChunkLoad;
    }

    public void incrementTicksSpentTryingToChunkLoad() {
        ++this.ticksSpentTryingToChunkLoad;
        SculkHorde.savedData.m_77762_();
    }

    public void resetTicksSpentTryingToChunkLoad() {
        this.ticksSpentTryingToChunkLoad = 0;
        SculkHorde.savedData.m_77762_();
    }

    public int getMAX_WAVE_DURATION() {
        return this.MAX_WAVE_DURATION;
    }

    public void setMAX_WAVE_DURATION(int MAX_WAVE_DURATION) {
        this.MAX_WAVE_DURATION = MAX_WAVE_DURATION;
        SculkHorde.savedData.m_77762_();
    }

    public int getWaveDuration() {
        return this.waveDuration;
    }

    public void setWaveDuration(int waveDuration) {
        this.waveDuration = waveDuration;
        SculkHorde.savedData.m_77762_();
    }

    public void incrementWaveDuration() {
        ++this.waveDuration;
        SculkHorde.savedData.m_77762_();
    }

    public int getTimeElapsedScouting() {
        return this.timeElapsedScouting;
    }

    public void incrementTimeElapsedScouting() {
        ++this.timeElapsedScouting;
        SculkHorde.savedData.m_77762_();
    }

    public void setTimeElapsedScouting(int timeElapsedScouting) {
        this.timeElapsedScouting = timeElapsedScouting;
        SculkHorde.savedData.m_77762_();
    }

    public BlockPos getSpawnLocation() {
        return this.spawnLocation;
    }

    public void setSpawnLocation(BlockPos spawnLocation) {
        this.spawnLocation = spawnLocation;
        SculkHorde.savedData.m_77762_();
    }

    public BlockPos getRaidLocation() {
        return this.raidLocation;
    }

    public void setRaidLocation(BlockPos raidLocation) {
        this.raidLocation = raidLocation;
        SculkHorde.savedData.m_77762_();
    }

    public Vec3 getObjectiveLocationVec3() {
        return new Vec3((double)this.objectiveLocation.m_123341_(), (double)this.objectiveLocation.m_123342_(), (double)this.objectiveLocation.m_123343_());
    }

    public BlockPos getObjectiveLocation() {
        return this.objectiveLocation;
    }

    public void setObjectiveLocation(BlockPos objectiveLocation) {
        this.objectiveLocation = objectiveLocation;
        SculkHorde.savedData.m_77762_();
    }

    public int getDistanceOfFurthestObjective() {
        int tempDistance;
        int distance = 0;
        for (BlockPos pos : high_priority_targets) {
            tempDistance = (int)BlockAlgorithms.getBlockDistanceXZ(this.getRaidLocation(), pos);
            if (tempDistance <= distance) continue;
            distance = tempDistance;
        }
        for (BlockPos pos : medium_priority_targets) {
            tempDistance = (int)BlockAlgorithms.getBlockDistanceXZ(this.getRaidLocation(), pos);
            if (tempDistance <= distance) continue;
            distance = tempDistance;
        }
        return distance;
    }

    public Optional<BlockPos> getNextObjectiveLocation() {
        Optional<BlockPos> objective = Optional.empty();
        if (!high_priority_targets.isEmpty()) {
            objective = Optional.of(high_priority_targets.get(0));
        } else if (!medium_priority_targets.isEmpty()) {
            objective = Optional.of(medium_priority_targets.get(0));
        }
        return objective;
    }

    public void setNextObjectiveLocation() {
        Optional<BlockPos> objectiveOptional = this.popObjectiveLocation();
        if (objectiveOptional.isPresent()) {
            this.setObjectiveLocation(objectiveOptional.get());
        } else {
            this.setRaidState(RaidHandler.RaidState.COMPLETE);
        }
    }

    public BlockPos getObjectiveLocationAtStartOfWave() {
        return this.objectiveLocationAtStartOfWave;
    }

    public void setObjectiveLocationAtStartOfWave(BlockPos objectiveLocationAtStartOfWave) {
        this.objectiveLocationAtStartOfWave = objectiveLocationAtStartOfWave;
        SculkHorde.savedData.m_77762_();
    }

    public BlockPos getRaidCenter() {
        return this.raidCenter;
    }

    public void setRaidCenter(BlockPos raidCenter) {
        this.raidCenter = raidCenter;
        SculkHorde.savedData.m_77762_();
    }

    public int getMINIMUM_RAID_RADIUS() {
        return MINIMUM_RAID_RADIUS;
    }

    public int getCurrentRaidRadius() {
        return this.currentRaidRadius;
    }

    public void setCurrentRaidRadius(int currentRaidRadius) {
        this.currentRaidRadius = currentRaidRadius;
        SculkHorde.savedData.m_77762_();
    }

    public int getMAXIMUM_RAID_RADIUS() {
        return MAXIMUM_RAID_RADIUS;
    }

    public ArrayList<ISculkSmartEntity> getWaveParticipants() {
        return this.waveParticipants;
    }

    public void setWaveParticipants(ArrayList<ISculkSmartEntity> waveParticipants) {
        this.waveParticipants = waveParticipants;
        SculkHorde.savedData.m_77762_();
    }

    public boolean isRaidActive() {
        return this.raidState == RaidHandler.RaidState.ACTIVE_WAVE;
    }

    public RaidHandler.RaidState getRaidState() {
        return this.raidState;
    }

    public void setRaidState(RaidHandler.RaidState raidState) {
        this.raidState = raidState;
        SculkHorde.savedData.m_77762_();
        SculkHorde.LOGGER.info("RaidHandler | Raid State is now: " + raidState.name() + ".");
    }

    public RaidHandler.failureType getFailure() {
        return this.failure;
    }

    public void setFailure(RaidHandler.failureType failure) {
        this.setRaidState(RaidHandler.RaidState.FAILED);
        this.failure = failure;
        SculkHorde.savedData.m_77762_();
    }

    public SculkEndermanEntity getScoutEnderman() {
        return this.scoutEnderman;
    }

    public void setScoutEnderman(SculkEndermanEntity scoutEnderman) {
        this.scoutEnderman = scoutEnderman;
        SculkHorde.savedData.m_77762_();
    }

    public ServerBossEvent getBossEvent() {
        return this.bossEvent;
    }

    public void setBossEvent(ServerBossEvent bossEvent) {
        this.bossEvent = bossEvent;
        SculkHorde.savedData.m_77762_();
    }

    public EntityFactoryEntry.StrategicValues[] getCurrentWavePattern() {
        return this.currentWavePattern;
    }

    public void setCurrentWavePattern(EntityFactoryEntry.StrategicValues[] currentWavePattern) {
        this.currentWavePattern = currentWavePattern;
        SculkHorde.savedData.m_77762_();
    }

    public int getMaxWaves() {
        return this.maxWaves;
    }

    public void setMaxWaves(int maxWaves) {
        this.maxWaves = maxWaves;
        SculkHorde.savedData.m_77762_();
    }

    public int getCurrentWave() {
        return this.currentWave;
    }

    public void setCurrentWave(int currentWave) {
        this.currentWave = currentWave;
        SculkHorde.savedData.m_77762_();
    }

    public void incrementCurrentWave() {
        ++this.currentWave;
        SculkHorde.savedData.m_77762_();
    }

    public boolean areWaveParticipantsDead() {
        return this.remainingWaveParticipants <= 0;
    }

    public int getRemainingWaveParticipants() {
        return this.remainingWaveParticipants;
    }

    public float getWaveProgress() {
        int aliveWaveParticipants = 0;
        for (ISculkSmartEntity entity : this.waveParticipants) {
            if (entity == null || !((Mob)entity).m_6084_()) continue;
            ++aliveWaveParticipants;
        }
        return (float)aliveWaveParticipants / (float)this.waveParticipants.size();
    }

    protected void updateRemainingWaveParticipantsAmount() {
        this.setRemainingWaveParticipants(0);
        for (ISculkSmartEntity entity : this.waveParticipants) {
            if (!((Mob)entity).m_6084_()) continue;
            this.setRemainingWaveParticipants(this.getRemainingWaveParticipants() + 1);
        }
        SculkHorde.savedData.m_77762_();
    }

    public void setRemainingWaveParticipants(int remainingWaveParticipants) {
        this.remainingWaveParticipants = remainingWaveParticipants;
        SculkHorde.savedData.m_77762_();
    }

    protected void removeWaveParticipantsFromList() {
        for (ISculkSmartEntity entity : this.waveParticipants) {
            if (((Mob)entity).m_6084_()) {
                ((Mob)entity).m_21219_();
                entity.setParticipatingInRaid(false);
                continue;
            }
            ((Mob)entity).m_146870_();
        }
        this.waveParticipants.clear();
        SculkHorde.savedData.m_77762_();
    }

    public ModSavedData.AreaofInterestEntry getAreaOfInterestEntry() {
        return this.areaOfInterestEntry;
    }

    public void setAreaOfInterestEntry(ModSavedData.AreaofInterestEntry areaOfInterestEntry) {
        this.areaOfInterestEntry = areaOfInterestEntry;
        SculkHorde.savedData.m_77762_();
    }

    public BlockSearcher getBlockSearcher() {
        return this.blockSearcher;
    }

    public void setBlockSearcher(BlockSearcher blockSearcher) {
        this.blockSearcher = blockSearcher;
        SculkHorde.savedData.m_77762_();
    }

    public static void save(CompoundTag tag) {
        tag.m_128405_("raidState", RaidData.raidStateToInt(RaidHandler.raidData.getRaidState()));
        tag.m_128405_("waveDuration", RaidHandler.raidData.getWaveDuration());
        tag.m_128405_("timeElapsedScouting", RaidHandler.raidData.getTimeElapsedScouting());
        tag.m_128356_("spawnLocation", RaidHandler.raidData.getSpawnLocation().m_121878_());
        tag.m_128356_("raidLocation", RaidHandler.raidData.getRaidLocation().m_121878_());
        tag.m_128356_("objectiveLocation", RaidHandler.raidData.getObjectiveLocation().m_121878_());
        tag.m_128356_("objectiveLocationAtStartOfWave", RaidHandler.raidData.getObjectiveLocationAtStartOfWave().m_121878_());
        tag.m_128356_("raidCenter", RaidHandler.raidData.getRaidCenter().m_121878_());
        tag.m_128356_("raidCenter", RaidHandler.raidData.getRaidCenter().m_121878_());
        tag.m_128405_("currentRaidRadius", RaidHandler.raidData.getCurrentRaidRadius());
        tag.m_128405_("maxWaves", RaidHandler.raidData.getMaxWaves());
        tag.m_128405_("currentWave", RaidHandler.raidData.getCurrentWave());
        if (RaidHandler.raidData.getDimensionResourceKey() != null) {
            tag.m_128359_("dimension", RaidHandler.raidData.getDimensionResourceKey().m_135782_().toString());
        }
        tag.m_128405_("remainingWaveParticipants", RaidHandler.raidData.getRemainingWaveParticipants());
        ListTag waveParticipantsTag = new ListTag();
        for (ISculkSmartEntity iSculkSmartEntity : RaidHandler.raidData.getWaveParticipants()) {
            if (!(iSculkSmartEntity instanceof Entity)) continue;
            UUID uuid = ((Entity)iSculkSmartEntity).m_20148_();
            waveParticipantsTag.add((Object)NbtUtils.m_129226_((UUID)uuid));
        }
        tag.m_128365_("waveParticipants", (Tag)waveParticipantsTag);
        if (RaidHandler.raidData.getScoutEnderman() != null) {
            tag.m_128362_("scoutEnderman", RaidHandler.raidData.getScoutEnderman().m_20148_());
        }
        if (RaidHandler.raidData.getCurrentWavePattern() != null) {
            ListTag currentWavePatternTag = new ListTag();
            for (EntityFactoryEntry.StrategicValues value : RaidHandler.raidData.getCurrentWavePattern()) {
                currentWavePatternTag.add((Object)StringTag.m_129297_((String)value.name()));
            }
            tag.m_128365_("currentWavePattern", (Tag)currentWavePatternTag);
        }
        if (RaidHandler.raidData.getAreaOfInterestEntry() != null) {
            CompoundTag areaOfInterestEntryTag = RaidHandler.raidData.getAreaOfInterestEntry().deserialize();
            tag.m_128365_("areaOfInterestEntry", (Tag)areaOfInterestEntryTag);
        }
        ListTag highPriorityTargetsTag = new ListTag();
        for (BlockPos pos : RaidHandler.raidData.getHighPriorityTargets()) {
            highPriorityTargetsTag.add((Object)LongTag.m_128882_((long)pos.m_121878_()));
        }
        tag.m_128365_("highPriorityTargets", (Tag)highPriorityTargetsTag);
        ListTag listTag = new ListTag();
        for (BlockPos pos : RaidHandler.raidData.getMediumPriorityTargets()) {
            listTag.add((Object)LongTag.m_128882_((long)pos.m_121878_()));
        }
        tag.m_128365_("mediumPriorityTargets", (Tag)listTag);
    }

    private static int raidStateToInt(RaidHandler.RaidState state2) {
        SculkHorde.LOGGER.debug("Saving Raid State: " + state2.name() + " as " + state2.ordinal() + ".");
        return state2.ordinal();
    }

    private static RaidHandler.RaidState intToRaidState(int state2) {
        SculkHorde.LOGGER.debug("Loading Raid State: " + state2 + " as " + RaidHandler.RaidState.values()[state2].name() + ".");
        return RaidHandler.RaidState.values()[state2];
    }

    public static void load(CompoundTag tag) {
        UUID uuid;
        Entity entity;
        RaidHandler.raidData.setRaidState(RaidData.intToRaidState(tag.m_128451_("raidState")));
        RaidHandler.raidData.setWaveDuration(tag.m_128451_("waveDuration"));
        RaidHandler.raidData.setTimeElapsedScouting(tag.m_128451_("timeElapsedScouting"));
        RaidHandler.raidData.setSpawnLocation(BlockPos.m_122022_((long)tag.m_128454_("spawnLocation")));
        RaidHandler.raidData.setRaidLocation(BlockPos.m_122022_((long)tag.m_128454_("raidLocation")));
        RaidHandler.raidData.setObjectiveLocation(BlockPos.m_122022_((long)tag.m_128454_("objectiveLocation")));
        RaidHandler.raidData.setObjectiveLocationAtStartOfWave(BlockPos.m_122022_((long)tag.m_128454_("objectiveLocationAtStartOfWave")));
        RaidHandler.raidData.setRaidCenter(BlockPos.m_122022_((long)tag.m_128454_("raidCenter")));
        RaidHandler.raidData.setMaxWaves(tag.m_128451_("maxWaves"));
        RaidHandler.raidData.setCurrentWave(tag.m_128451_("currentWave"));
        RaidHandler.raidData.setRemainingWaveParticipants(tag.m_128451_("remainingWaveParticipants"));
        ResourceKey dimensionResourceKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tag.m_128461_("dimension")));
        RaidHandler.raidData.setDimension((ResourceKey<Level>)dimensionResourceKey);
        RaidHandler.raidData.getWaveParticipants().clear();
        ListTag waveParticipantsTag = tag.m_128437_("waveParticipants", 11);
        for (Tag t : waveParticipantsTag) {
            UUID uuid2;
            Entity entity2;
            if (!(t instanceof IntArrayTag) || !((entity2 = SculkHorde.savedData.level.m_8791_(uuid2 = NbtUtils.m_129233_((Tag)((IntArrayTag)t)))) instanceof ISculkSmartEntity)) continue;
            RaidHandler.raidData.getWaveParticipants().add((ISculkSmartEntity)entity2);
            ((ISculkSmartEntity)entity2).setParticipatingInRaid(true);
        }
        if (tag.m_128403_("scoutEnderman") && (entity = SculkHorde.savedData.level.m_8791_(uuid = tag.m_128342_("scoutEnderman"))) instanceof SculkEndermanEntity) {
            RaidHandler.raidData.setScoutEnderman((SculkEndermanEntity)entity);
        }
        if (tag.m_128441_("currentWavePattern")) {
            ListTag currentWavePatternTag = tag.m_128437_("currentWavePattern", 8);
            RaidHandler.raidData.setCurrentWavePattern(new EntityFactoryEntry.StrategicValues[currentWavePatternTag.size()]);
            for (int i = 0; i < currentWavePatternTag.size(); ++i) {
                Tag t = currentWavePatternTag.get(i);
                if (!(t instanceof StringTag)) continue;
                String s = ((StringTag)t).m_7916_();
                RaidHandler.raidData.getCurrentWavePattern()[i] = EntityFactoryEntry.StrategicValues.valueOf(s);
            }
        }
        if (tag.m_128441_("areaOfInterestEntry")) {
            CompoundTag areaOfInterestEntryTag = tag.m_128469_("areaOfInterestEntry");
            RaidHandler.raidData.setAreaOfInterestEntry(ModSavedData.AreaofInterestEntry.serialize(areaOfInterestEntryTag));
        }
        RaidHandler.raidData.getHighPriorityTargets().clear();
        ListTag highPriorityTargetsTag = tag.m_128437_("highPriorityTargets", 4);
        for (Tag t : highPriorityTargetsTag) {
            if (!(t instanceof LongTag)) continue;
            long l = ((LongTag)t).m_7046_();
            RaidHandler.raidData.getHighPriorityTargets().add(BlockPos.m_122022_((long)l));
        }
        RaidHandler.raidData.getMediumPriorityTargets().clear();
        ListTag mediumPriorityTargetsTag = tag.m_128437_("mediumPriorityTargets", 4);
        for (Tag t : mediumPriorityTargetsTag) {
            if (!(t instanceof LongTag)) continue;
            long l = ((LongTag)t).m_7046_();
            RaidHandler.raidData.getMediumPriorityTargets().add(BlockPos.m_122022_((long)l));
        }
    }
}

