/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.core.gravemind;

import com.github.sculkhorde.common.entity.infection.CursorEntity;
import com.github.sculkhorde.core.ModConfig;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;

public class CursorHandler {
    SortedCursorList cursors = new SortedCursorList();
    private int index = 0;
    private int tickDelay = 3;
    private boolean manualControlOfTickingEnabled = false;

    public void setManualControlOfTickingEnabled(boolean value) {
        this.manualControlOfTickingEnabled = value;
    }

    public boolean isManualControlOfTickingEnabled() {
        return this.manualControlOfTickingEnabled;
    }

    public void addCursor(CursorEntity entity) {
        this.cursors.insertCursor(entity);
    }

    public void computeIfAbsent(CursorEntity entity) {
        if (this.cursors.getIndexOfCursor(entity).isEmpty()) {
            this.addCursor(entity);
        }
    }

    public int getSizeOfCursorList() {
        return this.cursors.list.size();
    }

    public void tickCursors() {
        ArrayList<CursorEntity> listOfCursors = this.cursors.getList();
        for (int i = 0; i < (Integer)ModConfig.SERVER.cursors_to_tick_per_tick.get(); ++i) {
            if (this.index >= listOfCursors.size()) {
                this.index = 0;
                continue;
            }
            CursorEntity cursorAtIndex = listOfCursors.get(this.index);
            cursorAtIndex.chanceToThanosSnapThisCursor();
            if (!cursorAtIndex.canBeManuallyTicked()) continue;
            cursorAtIndex.cursorTick();
            ++this.index;
        }
    }

    public void serverTick() {
        if (this.tickDelay < (Integer)ModConfig.SERVER.delay_between_cursor_tick_interval.get()) {
            ++this.tickDelay;
            return;
        }
        this.tickDelay = 0;
        this.cursors.clean();
        int cursorPopulationAmount = this.getSizeOfCursorList();
        int cursorPopulationThreshold = (Integer)ModConfig.SERVER.cursors_threshold_for_activation.get();
        if (cursorPopulationAmount >= cursorPopulationThreshold) {
            this.setManualControlOfTickingEnabled(true);
            this.tickCursors();
            return;
        }
        this.setManualControlOfTickingEnabled(false);
    }

    public class SortedCursorList {
        private ArrayList<CursorEntity> list = new ArrayList();

        public ArrayList<CursorEntity> getList() {
            return this.list;
        }

        public boolean shouldCursorBeDeleted(CursorEntity entity) {
            return entity == null || entity.m_213877_();
        }

        public void clean() {
            for (int i = 0; i < this.list.size(); ++i) {
                if (!this.shouldCursorBeDeleted(this.list.get(i))) continue;
                this.list.remove(i);
                --i;
            }
        }

        public void insertCursor(CursorEntity entity) {
            int positionToInsert = 0;
            int index = 0;
            while (index < this.list.size()) {
                CursorEntity cursorAtIndex = this.list.get(index);
                positionToInsert = index++;
                if (entity.m_20148_().compareTo(cursorAtIndex.m_20148_()) >= 0) break;
            }
            this.list.add(positionToInsert, entity);
        }

        public void removeCursor(CursorEntity entity) {
            Optional<Integer> position = this.getIndexOfCursor(entity);
            if (position.isEmpty()) {
                return;
            }
            this.list.remove(position.get());
        }

        public Optional<Integer> getIndexOfCursor(CursorEntity entity) {
            UUID uuid = entity.m_20148_();
            int left = 0;
            int right = this.list.size() - 1;
            while (left <= right) {
                int mid = left + (right - left) / 2;
                int res = this.list.get(mid).m_20148_().compareTo(uuid);
                if (res == 0) {
                    return Optional.of(mid);
                }
                if (res > 0) {
                    left = mid + 1;
                    continue;
                }
                right = mid - 1;
            }
            return Optional.empty();
        }
    }
}

