/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.structures.procedural;

import com.github.sculkhorde.common.block.SculkLivingRockBlock;
import com.github.sculkhorde.common.structures.procedural.PlannedBlock;
import com.github.sculkhorde.common.structures.procedural.ProceduralStructure;
import com.github.sculkhorde.core.ModBlocks;
import com.github.sculkhorde.util.BlockAlgorithms;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;

public class SculkLivingRockProceduralStructure
extends ProceduralStructure {
    public SculkLivingRockProceduralStructure(ServerLevel worldIn, BlockPos originIn) {
        super(worldIn, originIn);
    }

    @Override
    public void generatePlan() {
        this.plannedBlockQueue.clear();
        for (ProceduralStructure entry : this.childStructuresQueue) {
            entry.generatePlan();
        }
        int DIAMETER = (int)BlockAlgorithms.getSudoRNGFromPosition(this.origin, 5, 9);
        int pillarOffsetX = (int)BlockAlgorithms.getSudoRNGFromPosition(this.origin, (DIAMETER / 2 - 1) * -1, DIAMETER / 2 - 1);
        int pillarOffsetZ = (int)BlockAlgorithms.getSudoRNGFromPosition(this.origin, (DIAMETER / 2 - 1) * -1, DIAMETER / 2 - 1);
        BlockPos highestPillar = this.origin.m_7918_(pillarOffsetX, 0, pillarOffsetZ);
        int HEIGHT_DEGRADE_MULTIPLIER = DIAMETER / 2;
        int MAXIMUM_HEIGHT = Math.max(HEIGHT_DEGRADE_MULTIPLIER * DIAMETER, DIAMETER * 2);
        ArrayList<PlannedBlock> circleBase = BlockAlgorithms.generate2DCirclePlan(this.origin, DIAMETER, this.world, ((SculkLivingRockBlock)((Object)ModBlocks.SCULK_LIVING_ROCK_BLOCK.get())).m_49966_());
        ArrayList<PlannedBlock> pillarList = new ArrayList<PlannedBlock>();
        for (PlannedBlock plannedBlock : circleBase) {
            BlockPos newPos;
            int y;
            BlockPos pos = plannedBlock.getPosition();
            int distanceFromHighestPillar = (int)BlockAlgorithms.getBlockDistance(highestPillar, pos);
            int height = MAXIMUM_HEIGHT - distanceFromHighestPillar * HEIGHT_DEGRADE_MULTIPLIER - (int)BlockAlgorithms.getSudoRNGFromPosition(pos, 0, 2);
            for (y = pos.m_123342_(); y < pos.m_123342_() + height; ++y) {
                newPos = new BlockPos(pos.m_123341_(), y, pos.m_123343_());
                if (BlockAlgorithms.getSudoRNGFromPosition(newPos, 0, 10) == 0.0f) {
                    pillarList.add(new PlannedBlock(this.world, ((Block)ModBlocks.CALCITE_ORE.get()).m_49966_(), newPos));
                    continue;
                }
                pillarList.add(new PlannedBlock(this.world, ((SculkLivingRockBlock)((Object)ModBlocks.SCULK_LIVING_ROCK_BLOCK.get())).m_49966_(), newPos));
            }
            for (y = pos.m_123342_(); y > pos.m_123342_() - height; --y) {
                newPos = new BlockPos(pos.m_123341_(), y, pos.m_123343_());
                pillarList.add(new PlannedBlock(this.world, ((SculkLivingRockBlock)((Object)ModBlocks.SCULK_LIVING_ROCK_BLOCK.get())).m_49966_(), newPos));
            }
        }
        this.plannedBlockQueue.addAll(circleBase);
        this.plannedBlockQueue.addAll(pillarList);
    }
}

