/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SoulHarvestingRecipe
implements Recipe<SimpleContainer> {
    private final NonNullList<Ingredient> inputItems;
    private final ItemStack output;
    private final ResourceLocation id;

    public SoulHarvestingRecipe(NonNullList<Ingredient> inputItems, ItemStack outout, ResourceLocation id) {
        this.inputItems = inputItems;
        this.output = outout;
        this.id = id;
    }

    public boolean matches(SimpleContainer containerIn, Level levelIn) {
        if (levelIn.m_5776_()) {
            return false;
        }
        return ((Ingredient)this.inputItems.get(0)).test(containerIn.m_8020_(0));
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputItems;
    }

    public ItemStack assemble(SimpleContainer p_44001_, RegistryAccess p_267165_) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<SoulHarvestingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("sculkhorde", "soul_harvesting");

        public SoulHarvestingRecipe fromJson(ResourceLocation recipeIDIn, JsonObject serializedRecipeIn) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)serializedRecipeIn, (String)"output"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)serializedRecipeIn, (String)"ingredients");
            NonNullList inputItems = NonNullList.m_122780_((int)1, (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredients.size(); ++i) {
                inputItems.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            return new SoulHarvestingRecipe((NonNullList<Ingredient>)inputItems, output, recipeIDIn);
        }

        @Nullable
        public SoulHarvestingRecipe fromNetwork(ResourceLocation recipeIDIn, FriendlyByteBuf bufferIn) {
            NonNullList inputItems = NonNullList.m_122780_((int)bufferIn.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputItems.size(); ++i) {
                inputItems.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)bufferIn));
            }
            ItemStack output = bufferIn.m_130267_();
            System.out.println("SoulHarvesterRecipe | Data size being read: " + bufferIn.readableBytes());
            return new SoulHarvestingRecipe((NonNullList<Ingredient>)inputItems, output, recipeIDIn);
        }

        public void toNetwork(FriendlyByteBuf bufferIn, SoulHarvestingRecipe recipeIn) {
            bufferIn.writeInt(recipeIn.inputItems.size());
            for (Ingredient ingredient : recipeIn.m_7527_()) {
                ingredient.m_43923_(bufferIn);
            }
            bufferIn.writeItemStack(recipeIn.m_8043_(null), false);
            System.out.println("SoulHarvesterRecipe | Data size being written: " + bufferIn.writerIndex());
        }
    }

    public static class Type
    implements RecipeType<SoulHarvestingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "sculkhorde:soul_harvesting";
    }
}

