/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.projectile;

import com.github.sculkhorde.common.entity.infection.CursorSurfacePurifierEntity;
import com.github.sculkhorde.common.entity.projectile.CustomItemProjectileEntity;
import com.github.sculkhorde.core.ModEntities;
import com.github.sculkhorde.core.ModItems;
import com.github.sculkhorde.core.ModMobEffects;
import com.github.sculkhorde.util.BlockAlgorithms;
import com.github.sculkhorde.util.TickUnits;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public class PurificationFlaskProjectileEntity
extends CustomItemProjectileEntity {
    public PurificationFlaskProjectileEntity(EntityType<? extends CustomItemProjectileEntity> entityIn, Level worldIn) {
        super(entityIn, worldIn);
    }

    public PurificationFlaskProjectileEntity(Level worldIn, LivingEntity shooterIn, float damageIn) {
        this((EntityType<? extends CustomItemProjectileEntity>)((EntityType)ModEntities.PURIFICATION_FLASK_PROJECTILE_ENTITY.get()), worldIn);
        this.m_6034_(shooterIn.m_20185_(), shooterIn.m_20188_(), shooterIn.m_20189_());
        this.m_5602_((Entity)shooterIn);
        this.setDamage(damageIn);
    }

    @Override
    protected Item m_7881_() {
        return (Item)ModItems.PURITY_SPLASH_POTION.get();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123749_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (this.m_9236_().m_5776_()) {
            return;
        }
        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(4.0))) {
            entity.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.PURITY.get(), TickUnits.convertMinutesToTicks(15)));
        }
        this.m_5496_(SoundEvents.f_12436_, 1.0f, 1.0f + this.f_19796_.m_188501_() * 0.2f);
        this.m_142687_(Entity.RemovalReason.DISCARDED);
        ArrayList<BlockPos> list = BlockAlgorithms.getBlockPosInCircle(BlockPos.m_274446_((Position)result.m_82450_()), 3, true);
        Collections.shuffle(list);
        list.removeIf(pos -> BlockAlgorithms.isNotSolid((ServerLevel)this.m_9236_(), pos));
        for (int i = 0; i < 5 && i < list.size(); ++i) {
            CursorSurfacePurifierEntity cursor = new CursorSurfacePurifierEntity(this.m_9236_());
            cursor.m_6034_(list.get(i).m_123341_(), list.get(i).m_123342_(), list.get(i).m_123343_());
            cursor.setMaxTransformations(200);
            cursor.setMaxRange(100);
            cursor.setSearchIterationsPerTick(5);
            cursor.setMaxLifeTimeMillis(TimeUnit.MINUTES.toMillis(1L));
            cursor.setTickIntervalMilliseconds(150L);
            this.m_9236_().m_7967_((Entity)cursor);
        }
    }
}

