/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.infection;

import com.github.sculkhorde.common.entity.infection.InfectionTree;
import com.github.sculkhorde.core.ModConfig;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.BlockAlgorithms;
import com.github.sculkhorde.util.TickUnits;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SculkNodeInfectionHandler {
    private BlockEntity parent = null;
    private ServerLevel world = null;
    private BlockPos origin = null;
    public boolean spawnOnSurface = true;
    private final int CHECK_FOR_ACTIVATION_INTERVAL;
    private int timeRemainingUntilNextActivationCheck = this.CHECK_FOR_ACTIVATION_INTERVAL = TickUnits.convertMinutesToTicks(1);
    private boolean isActive = false;
    private InfectionTree northInfectionTree;
    private InfectionTree southInfectionTree;
    private InfectionTree eastInfectionTree;
    private InfectionTree westInfectionTree;
    private InfectionTree upInfectionTree;
    private InfectionTree downInfectionTree;
    protected int lastTimeSinceTick = 0;
    protected int TICK_COOLDOWN = TickUnits.convertSecondsToTicks(1);

    public SculkNodeInfectionHandler(BlockEntity parent, BlockPos origin) {
        this.parent = parent;
        this.world = (ServerLevel)parent.m_58904_();
        this.origin = origin;
        this.northInfectionTree = new InfectionTree(this.world, Direction.NORTH, origin);
        this.northInfectionTree.activate();
        this.southInfectionTree = new InfectionTree(this.world, Direction.SOUTH, origin);
        this.southInfectionTree.activate();
        this.eastInfectionTree = new InfectionTree(this.world, Direction.EAST, origin);
        this.eastInfectionTree.activate();
        this.westInfectionTree = new InfectionTree(this.world, Direction.WEST, origin);
        this.westInfectionTree.activate();
        this.upInfectionTree = new InfectionTree(this.world, Direction.UP, origin);
        this.upInfectionTree.activate();
        this.downInfectionTree = new InfectionTree(this.world, Direction.DOWN, origin);
        this.downInfectionTree.activate();
    }

    public BlockPos calculateSpawnPosition() {
        if (!this.spawnOnSurface) {
            return this.origin;
        }
        BlockPos.MutableBlockPos checkPosition = new BlockPos.MutableBlockPos(this.origin.m_123341_(), this.world.m_141937_(), this.origin.m_123343_());
        BlockPos lastKnownSolidBlock = null;
        while (checkPosition.m_123342_() < this.world.m_151558_()) {
            checkPosition.m_142448_(checkPosition.m_123342_() + 1);
            if (!BlockAlgorithms.isSolid(this.world, (BlockPos)checkPosition)) continue;
            lastKnownSolidBlock = checkPosition.m_7949_();
        }
        if (lastKnownSolidBlock != null) {
            this.origin = lastKnownSolidBlock;
        }
        return lastKnownSolidBlock;
    }

    public boolean canBeActivated() {
        if (this.timeRemainingUntilNextActivationCheck > 0) {
            --this.timeRemainingUntilNextActivationCheck;
            return false;
        }
        if (!SculkHorde.savedData.isHordeActive()) {
            this.timeRemainingUntilNextActivationCheck = this.CHECK_FOR_ACTIVATION_INTERVAL;
            return false;
        }
        if (this.parent == null || this.world == null || this.origin == null) {
            this.timeRemainingUntilNextActivationCheck = this.CHECK_FOR_ACTIVATION_INTERVAL;
            return false;
        }
        if (this.calculateSpawnPosition() != null) {
            this.timeRemainingUntilNextActivationCheck = this.CHECK_FOR_ACTIVATION_INTERVAL;
            return true;
        }
        SculkHorde.LOGGER.info("Sculk Node at " + this.parent.m_58899_() + " cannot be activated because it has no spawn position.");
        this.timeRemainingUntilNextActivationCheck = this.CHECK_FOR_ACTIVATION_INTERVAL;
        return false;
    }

    public void activate() {
        this.isActive = true;
        this.northInfectionTree.setOrigin(this.origin);
        this.southInfectionTree.setOrigin(this.origin);
        this.eastInfectionTree.setOrigin(this.origin);
        this.westInfectionTree.setOrigin(this.origin);
    }

    public void deactivate() {
        this.isActive = false;
    }

    public void tick() {
        if (!this.isActive || !((Boolean)ModConfig.SERVER.block_infestation_enabled.get()).booleanValue()) {
            return;
        }
        if (this.lastTimeSinceTick < this.TICK_COOLDOWN) {
            ++this.lastTimeSinceTick;
            return;
        }
        this.lastTimeSinceTick = 0;
        this.northInfectionTree.tick();
        this.southInfectionTree.tick();
        this.eastInfectionTree.tick();
        this.westInfectionTree.tick();
        this.upInfectionTree.tick();
        this.downInfectionTree.tick();
    }
}

