/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.infection;

import com.github.sculkhorde.common.entity.infection.CursorEntity;
import com.github.sculkhorde.common.entity.infection.CursorSurfaceInfectorEntity;
import com.github.sculkhorde.core.ModEntities;
import com.github.sculkhorde.util.BlockAlgorithms;
import com.github.sculkhorde.util.BlockInfestationHelper;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class CursorSurfacePurifierEntity
extends CursorEntity {
    public CursorSurfacePurifierEntity(Level worldIn) {
        this((EntityType)ModEntities.CURSOR_SURFACE_PURIFIER.get(), worldIn);
    }

    public CursorSurfacePurifierEntity(EntityType<?> pType, Level pLevel) {
        super(pType, pLevel);
    }

    @Override
    public boolean canBeManuallyTicked() {
        return false;
    }

    @Override
    protected boolean isTarget(BlockPos pos) {
        return BlockInfestationHelper.isCurable((ServerLevel)this.m_9236_(), pos);
    }

    @Override
    protected void transformBlock(BlockPos pos) {
        block0: {
            BlockInfestationHelper.tryToCureBlock((ServerLevel)this.m_9236_(), pos);
            Predicate<CursorSurfaceInfectorEntity> isCursor = Objects::nonNull;
            List Infectors = this.m_9236_().m_6443_(CursorSurfaceInfectorEntity.class, this.m_20191_().m_82400_(5.0), isCursor);
            Iterator iterator = Infectors.iterator();
            if (!iterator.hasNext()) break block0;
            CursorSurfaceInfectorEntity infector = (CursorSurfaceInfectorEntity)((Object)iterator.next());
            infector.m_146870_();
            this.m_146870_();
        }
    }

    @Override
    protected void spawnParticleEffects() {
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123767_, this.m_20208_(1.5), this.m_20187_(), this.m_20262_(1.5), 0.0, 0.0, 0.0);
    }

    @Override
    protected boolean isObstructed(BlockState state2, BlockPos pos) {
        if (BlockAlgorithms.getBlockDistance(this.origin, pos) > (float)this.MAX_RANGE) {
            return true;
        }
        if (state2.m_60795_()) {
            return true;
        }
        if (this.visitedPositons.containsKey(pos.m_121878_())) {
            return true;
        }
        return !BlockAlgorithms.isExposedToAir((ServerLevel)this.m_9236_(), pos);
    }
}

