/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.infection;

import com.github.sculkhorde.common.entity.infection.CursorEntity;
import com.github.sculkhorde.core.ModBlocks;
import com.github.sculkhorde.core.ModConfig;
import com.github.sculkhorde.core.ModEntities;
import com.github.sculkhorde.util.BlockAlgorithms;
import com.github.sculkhorde.util.BlockInfestationHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class CursorSurfaceInfectorEntity
extends CursorEntity {
    public CursorSurfaceInfectorEntity(Level worldIn) {
        this((EntityType)ModEntities.CURSOR_SURFACE_INFECTOR.get(), worldIn);
    }

    public CursorSurfaceInfectorEntity(EntityType<?> pType, Level pLevel) {
        super(pType, pLevel);
    }

    @Override
    protected boolean isTarget(BlockPos pos) {
        return BlockInfestationHelper.isInfectable((ServerLevel)this.m_9236_(), pos);
    }

    @Override
    protected void transformBlock(BlockPos pos) {
        BlockInfestationHelper.tryToInfestBlock((ServerLevel)this.m_9236_(), pos);
    }

    @Override
    protected boolean isObstructed(BlockState state2, BlockPos pos) {
        boolean isBlockNotSculkDuraMatter;
        if (!((Boolean)ModConfig.SERVER.block_infestation_enabled.get()).booleanValue()) {
            return true;
        }
        if (state2.m_60795_()) {
            return true;
        }
        if (BlockAlgorithms.isExposedToInfestationWardBlock((ServerLevel)this.m_9236_(), pos)) {
            return true;
        }
        if (BlockAlgorithms.getBlockDistance(this.origin, pos) > (float)this.MAX_RANGE) {
            return true;
        }
        if (!this.m_9236_().m_46739_(pos)) {
            return true;
        }
        if (this.visitedPositons.containsKey(pos.m_121878_())) {
            return true;
        }
        boolean isBlockNotExposedToAir = !BlockAlgorithms.isExposedToAir((ServerLevel)this.m_9236_(), pos);
        boolean isBlockNotSculkArachnoid = !state2.m_60713_((Block)ModBlocks.SCULK_ARACHNOID.get());
        boolean bl = isBlockNotSculkDuraMatter = !state2.m_60713_((Block)ModBlocks.SCULK_DURA_MATTER.get());
        return isBlockNotExposedToAir && isBlockNotSculkArachnoid && isBlockNotSculkDuraMatter;
    }

    @Override
    protected void spawnParticleEffects() {
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_235898_, this.m_20208_(2.0), this.m_20187_(), this.m_20262_(2.0), 0.0, 0.0, 0.0);
    }
}

