/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.infection;

import com.github.sculkhorde.common.entity.infection.CursorEntity;
import com.github.sculkhorde.common.entity.infection.CursorSurfaceInfectorEntity;
import com.github.sculkhorde.core.ModEntities;
import com.github.sculkhorde.util.BlockAlgorithms;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Stack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class CursorProberEntity
extends CursorSurfaceInfectorEntity {
    Direction preferedDirection = Direction.NORTH;
    Stack<BlockPos> stack = new Stack();

    public CursorProberEntity(Level worldIn) {
        super((EntityType)ModEntities.CURSOR_PROBER.get(), worldIn);
    }

    public CursorProberEntity(EntityType<?> pType, Level pLevel) {
        super(pType, pLevel);
    }

    protected void setPreferedDirection(Direction direction) {
        this.preferedDirection = direction;
    }

    @Override
    protected boolean searchTick() {
        for (int i = 0; i < this.searchIterationsPerTick; ++i) {
            if (this.stack.isEmpty()) {
                this.isSuccessful = false;
                this.target = BlockPos.f_121853_;
                return true;
            }
            BlockPos currentBlock = this.stack.pop();
            if (this.isTarget(currentBlock)) {
                this.isSuccessful = true;
                this.target = currentBlock;
                return true;
            }
            ArrayList<BlockPos> possiblePaths = BlockAlgorithms.getNeighborsCube(currentBlock, false);
            Collections.shuffle(possiblePaths);
            for (BlockPos neighbor : possiblePaths) {
                if (this.visitedPositons.containsKey(neighbor.m_121878_()) || this.isObstructed(this.m_9236_().m_8055_(neighbor), neighbor)) continue;
                this.stack.add(neighbor);
                this.visitedPositons.put(neighbor.m_121878_(), true);
            }
        }
        return false;
    }

    @Override
    public void m_8119_() {
        long currentLifeTimeMilliseconds;
        float timeElapsedMilliSeconds = System.currentTimeMillis() - this.lastTickTime;
        if (timeElapsedMilliSeconds < (float)this.tickIntervalMilliseconds) {
            return;
        }
        this.lastTickTime = System.currentTimeMillis();
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.spawnParticleEffects();
            }
            return;
        }
        if (this.origin == BlockPos.f_121853_) {
            this.origin = this.m_20183_();
        }
        if ((currentLifeTimeMilliseconds = System.currentTimeMillis() - this.creationTickTime) >= this.MAX_LIFETIME_MILLIS) {
            this.state = CursorEntity.State.FINISHED;
        } else if (this.currentTransformations >= this.MAX_TRANSFORMATIONS) {
            this.state = CursorEntity.State.FINISHED;
        }
        if (this.state == CursorEntity.State.IDLE) {
            this.stack.add(this.m_20183_());
            this.state = CursorEntity.State.SEARCHING;
        } else if (this.state == CursorEntity.State.SEARCHING) {
            if (!this.searchTick()) {
                return;
            }
            if (this.target.equals((Object)BlockPos.f_121853_)) {
                this.state = CursorEntity.State.FINISHED;
            } else {
                this.state = CursorEntity.State.EXPLORING;
                this.visitedPositons.clear();
            }
        } else if (this.state == CursorEntity.State.EXPLORING) {
            ArrayList<BlockPos> neighbors = BlockAlgorithms.getNeighborsCube(this.m_20183_(), false);
            ArrayList<BlockPos> unobstructedNeighbors = new ArrayList<BlockPos>();
            for (BlockPos neighbor : neighbors) {
                if (this.isObstructed(this.m_9236_().m_8055_(neighbor), neighbor)) continue;
                unobstructedNeighbors.add(neighbor);
            }
            if (neighbors.size() == 0) {
                return;
            }
            BlockPos closest = neighbors.get(0);
            for (BlockPos pos : neighbors) {
                if (!(BlockAlgorithms.getBlockDistance(pos, this.target) < BlockAlgorithms.getBlockDistance(closest, this.target))) continue;
                closest = pos;
            }
            this.m_6034_((double)closest.m_123341_() + 0.5, closest.m_123342_(), (double)closest.m_123343_() + 0.5);
            this.visitedPositons.put(closest.m_121878_(), true);
            if (this.m_20183_().equals((Object)this.target)) {
                this.target = BlockPos.f_121853_;
                this.transformBlock(this.m_20183_());
                ++this.currentTransformations;
                this.state = CursorEntity.State.SEARCHING;
                this.visitedPositons.clear();
                this.searchQueue.clear();
                this.searchQueue.add(this.m_20183_());
            }
        } else if (this.state == CursorEntity.State.FINISHED) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }
}

