/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.infection;

import com.github.sculkhorde.core.ModConfig;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.BlockAlgorithms;
import com.github.sculkhorde.util.TickUnits;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public abstract class CursorEntity
extends Entity {
    protected State state = State.IDLE;
    protected int MAX_TRANSFORMATIONS = 100;
    protected int currentTransformations = 0;
    protected int MAX_RANGE = 20;
    protected long MAX_LIFETIME_MILLIS = TimeUnit.SECONDS.toMillis(300L);
    protected long creationTickTime = System.currentTimeMillis();
    protected long lastTickTime = 0L;
    protected long ticksRemainingBeforeCheckingIfInCursorList = 0L;
    protected final long CHECK_DELAY_TICKS = TickUnits.convertSecondsToTicks(5);
    protected boolean canBeManuallyTicked = true;
    protected int searchIterationsPerTick = 20;
    protected long tickIntervalMilliseconds = 1000L;
    protected BlockPos origin = BlockPos.f_121853_;
    protected BlockPos target = BlockPos.f_121853_;
    protected HashMap<Long, Boolean> positionsSearched = new HashMap();
    Queue<BlockPos> searchQueue = new LinkedList<BlockPos>();
    public boolean isSuccessful = false;
    protected HashMap<Long, Boolean> visitedPositons = new HashMap();

    public CursorEntity(EntityType<?> pType, Level pLevel) {
        super(pType, pLevel);
        this.creationTickTime = System.currentTimeMillis();
    }

    public void setMaxTransformations(int MAX_INFECTIONS) {
        this.MAX_TRANSFORMATIONS = MAX_INFECTIONS;
    }

    public void setMaxRange(int MAX_RANGE) {
        this.MAX_RANGE = MAX_RANGE;
    }

    public void setMaxLifeTimeMillis(long MAX_LIFETIME) {
        this.MAX_LIFETIME_MILLIS = MAX_LIFETIME;
    }

    public void setSearchIterationsPerTick(int iterations) {
        this.searchIterationsPerTick = iterations;
    }

    public void setTickIntervalMilliseconds(long milliseconds) {
        this.tickIntervalMilliseconds = milliseconds;
    }

    public void setCanBeManuallyTicked(boolean value) {
        this.canBeManuallyTicked = value;
    }

    public boolean canBeManuallyTicked() {
        return this.canBeManuallyTicked;
    }

    public void setState(State state2) {
        this.state = state2;
    }

    protected boolean isObstructed(BlockState state2, BlockPos pos) {
        if (SculkHorde.savedData.getSculkAccumulatedMass() <= 0) {
            return false;
        }
        if (BlockAlgorithms.getBlockDistance(this.origin, pos) > (float)this.MAX_RANGE) {
            return true;
        }
        if (state2.m_60795_()) {
            return true;
        }
        return this.visitedPositons.containsKey(pos.m_121878_());
    }

    protected boolean isTarget(BlockPos pos) {
        return false;
    }

    protected void transformBlock(BlockPos pos) {
        this.m_9236_().m_46597_(pos, Blocks.f_50090_.m_49966_());
    }

    protected void spawnParticleEffects() {
    }

    protected void resetSearchTick() {
        this.searchQueue.clear();
        this.positionsSearched.clear();
    }

    protected void addPositionToQueueIfValid(BlockPos pos) {
        boolean isPositionNotObstructed;
        boolean isPositionNotVisited = !this.positionsSearched.containsKey(pos.m_121878_());
        BlockState neighborBlockState = this.m_9236_().m_8055_(pos);
        boolean bl = isPositionNotObstructed = !this.isObstructed(neighborBlockState, pos);
        if (isPositionNotVisited && isPositionNotObstructed) {
            this.searchQueue.add(pos);
            this.positionsSearched.put(pos.m_121878_(), true);
        }
    }

    protected boolean searchTick() {
        for (int i = 0; i < Math.max(this.searchIterationsPerTick, 1); ++i) {
            if (this.searchQueue.isEmpty()) {
                this.isSuccessful = false;
                this.target = BlockPos.f_121853_;
                return true;
            }
            BlockPos currentBlock = this.searchQueue.poll();
            if (this.isTarget(currentBlock)) {
                this.isSuccessful = true;
                this.target = currentBlock;
                return true;
            }
            ArrayList<BlockPos> possibleBlocksToVisit = BlockAlgorithms.getNeighborsCube(currentBlock, false);
            Collections.shuffle(possibleBlocksToVisit);
            for (BlockPos neighbor : possibleBlocksToVisit) {
                this.addPositionToQueueIfValid(neighbor);
            }
        }
        return false;
    }

    public void exploreTick() {
        ArrayList<BlockPos> neighbors = BlockAlgorithms.getNeighborsCube(this.m_20183_(), false);
        ArrayList<BlockPos> unobstructedNeighbors = new ArrayList<BlockPos>();
        for (BlockPos blockPos : neighbors) {
            if (this.isObstructed(this.m_9236_().m_8055_(blockPos), blockPos)) continue;
            unobstructedNeighbors.add(blockPos);
        }
        if (neighbors.size() == 0) {
            return;
        }
        BlockPos closest = neighbors.get(0);
        for (BlockPos pos : neighbors) {
            if (!(BlockAlgorithms.getBlockDistance(pos, this.target) < BlockAlgorithms.getBlockDistance(closest, this.target))) continue;
            closest = pos;
        }
        this.m_6034_((double)closest.m_123341_() + 0.5, closest.m_123342_(), (double)closest.m_123343_() + 0.5);
        if (this.m_20183_().equals((Object)this.target)) {
            boolean isNotObstructed;
            this.target = BlockPos.f_121853_;
            BlockState blockState = this.m_9236_().m_8055_(this.m_20183_());
            boolean isTarget = this.isTarget(this.m_20183_());
            boolean bl = isNotObstructed = !this.isObstructed(blockState, this.m_20183_());
            if (isTarget && isNotObstructed) {
                this.transformBlock(this.m_20183_());
                ++this.currentTransformations;
            }
            this.setState(State.SEARCHING);
            this.resetSearchTick();
            this.searchQueue.add(this.m_20183_());
        }
        this.visitedPositons.put(closest.m_121878_(), true);
    }

    public void cursorTick() {
        long currentLifeTimeMilliseconds;
        double tickIntervalMillisecondsAfterMultiplier;
        float timeElapsedMilliSeconds = System.currentTimeMillis() - this.lastTickTime;
        if ((double)timeElapsedMilliSeconds < Math.max(tickIntervalMillisecondsAfterMultiplier = (double)this.tickIntervalMilliseconds - (double)this.tickIntervalMilliseconds * (Double)ModConfig.SERVER.infestation_speed_multiplier.get(), 1.0)) {
            return;
        }
        this.lastTickTime = System.currentTimeMillis();
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.spawnParticleEffects();
            }
            return;
        }
        if (this.origin == BlockPos.f_121853_) {
            this.origin = this.m_20183_();
        }
        if ((currentLifeTimeMilliseconds = System.currentTimeMillis() - this.creationTickTime) >= this.MAX_LIFETIME_MILLIS) {
            this.setState(State.FINISHED);
        } else if (this.currentTransformations >= this.MAX_TRANSFORMATIONS) {
            this.setState(State.FINISHED);
        }
        if (this.state == State.IDLE) {
            this.searchQueue.add(this.m_20183_());
            this.setState(State.SEARCHING);
        } else if (this.state == State.SEARCHING) {
            if (!this.searchTick()) {
                return;
            }
            if (this.target.equals((Object)BlockPos.f_121853_)) {
                this.state = State.FINISHED;
                this.setState(this.state);
            } else {
                this.state = State.EXPLORING;
                this.setState(this.state);
                this.visitedPositons.clear();
            }
        } else if (this.state == State.EXPLORING) {
            this.exploreTick();
        } else if (this.state == State.FINISHED) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void m_8119_() {
        boolean shouldTick;
        super.m_8119_();
        if (this.canBeManuallyTicked()) {
            --this.ticksRemainingBeforeCheckingIfInCursorList;
            if (this.ticksRemainingBeforeCheckingIfInCursorList <= 0L) {
                SculkHorde.cursorHandler.computeIfAbsent(this);
                this.ticksRemainingBeforeCheckingIfInCursorList = this.CHECK_DELAY_TICKS;
            }
        }
        boolean canBeManuallyTickedAndManualControlIsNotOn = this.canBeManuallyTicked() && !SculkHorde.cursorHandler.isManualControlOfTickingEnabled();
        boolean cannotBeManuallyTicked = !this.canBeManuallyTicked();
        boolean bl = shouldTick = canBeManuallyTickedAndManualControlIsNotOn || cannotBeManuallyTicked;
        if (shouldTick) {
            this.cursorTick();
        }
    }

    protected void m_7378_(CompoundTag nbt) {
    }

    protected void m_7380_(CompoundTag nbt) {
    }

    protected void m_8097_() {
    }

    public void setTarget(BlockPos target) {
        this.target = target;
    }

    public void onRemovedFromWorld() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
    }

    public void chanceToThanosSnapThisCursor() {
        if (((Boolean)ModConfig.SERVER.thanos_snap_cursors_after_reaching_threshold.get()).booleanValue() && SculkHorde.cursorHandler.isManualControlOfTickingEnabled() && this.f_19796_.m_188499_()) {
            this.m_146870_();
        }
    }

    protected static enum State {
        IDLE,
        SEARCHING,
        EXPLORING,
        FINISHED;

    }
}

