/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.goal;

import com.github.sculkhorde.common.entity.ISculkSmartEntity;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.core.gravemind.Gravemind;
import com.github.sculkhorde.util.SquadHandler;
import com.github.sculkhorde.util.TickUnits;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.AABB;

public class SquadHandlingGoal
extends Goal {
    private final ISculkSmartEntity mob;
    private long timeOfLastSquadUpdate = 0L;
    private final long SQUAD_UPDATE_DELAY = TickUnits.convertSecondsToTicks(5);

    public SquadHandlingGoal(ISculkSmartEntity mob) {
        this.mob = mob;
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
    }

    public Mob getMob() {
        return (Mob)this.mob;
    }

    public boolean m_8036_() {
        return !SculkHorde.gravemind.getEvolutionState().equals((Object)Gravemind.evolution_states.Immature) || this.getMob().m_9236_().m_46467_() - this.timeOfLastSquadUpdate > this.SQUAD_UPDATE_DELAY;
    }

    public void m_8056_() {
        this.timeOfLastSquadUpdate = this.getMob().m_9236_().m_46467_();
    }

    public void m_8037_() {
        super.m_8037_();
        SquadHandler squad = this.mob.getSquad();
        if (SquadHandler.doesSquadExist(squad)) {
            if (squad.isSquadLeaderDead()) {
                ISculkSmartEntity mobWithMostHealth = squad.getMobMemberWithMostMaxHealth();
                if (mobWithMostHealth == null) {
                    squad.disbandSquad();
                    return;
                }
                SquadHandler.promoteToLeaderOfSquad(mobWithMostHealth, squad);
            }
            if (squad.isSquadLeader() && SculkHorde.isDebugMode()) {
                MobEffectInstance effect = new MobEffectInstance(MobEffects.f_19619_, TickUnits.convertSecondsToTicks(10), 0, false, false);
                this.getMob().m_7292_(effect);
            }
            return;
        }
        if (!this.tryToJoinNearBySquad()) {
            squad.createSquad();
        }
    }

    protected boolean tryToJoinNearBySquad() {
        AABB boundingBox = this.getMob().m_20191_().m_82377_(16.0, 8.0, 16.0);
        List list = this.getMob().m_9236_().m_45976_(Mob.class, boundingBox);
        if (list.isEmpty()) {
            return false;
        }
        Mob bestMob = list.stream().filter(mob -> mob instanceof ISculkSmartEntity && ((ISculkSmartEntity)mob).getSquad() != null && ((ISculkSmartEntity)mob).getSquad().isSquadLeader() && mob != this.getMob()).min(Comparator.comparingDouble(arg_0 -> ((Mob)this.getMob()).m_20280_(arg_0))).orElse(null);
        if (bestMob == null) {
            return false;
        }
        return ((ISculkSmartEntity)bestMob).getSquad().tryToAcceptMemberIntoSquad(this.mob);
    }

    public boolean m_8045_() {
        return false;
    }
}

