/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.goal;

import com.github.sculkhorde.common.entity.ISculkSmartEntity;
import com.github.sculkhorde.util.SquadHandler;
import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;

public class ImprovedRandomStrollGoal
extends Goal {
    public static final int DEFAULT_INTERVAL = 120;
    protected final PathfinderMob mob;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;
    protected final double speedModifier;
    protected int interval;
    protected boolean forceTrigger;
    public static final float PROBABILITY = 0.001f;
    protected float probability;
    protected boolean avoidWater;

    public ImprovedRandomStrollGoal(PathfinderMob mob, double speedModifier) {
        this(mob, speedModifier, 120);
    }

    public ImprovedRandomStrollGoal(PathfinderMob mob, double speedModifier, int interval) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.interval = interval;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.probability = 0.001f;
    }

    public ImprovedRandomStrollGoal setProbabilty(float probability) {
        this.probability = probability;
        return this;
    }

    public ImprovedRandomStrollGoal setToAvoidWater(boolean value) {
        this.avoidWater = value;
        return this;
    }

    public boolean m_8036_() {
        Optional<Vec3> position;
        if (this.mob.m_20160_() || ((ISculkSmartEntity)this.mob).isParticipatingInRaid()) {
            return false;
        }
        if (!this.forceTrigger && this.mob.m_217043_().m_188503_(ImprovedRandomStrollGoal.m_186073_((int)this.interval)) != 0) {
            return false;
        }
        Optional<Vec3> optional = position = this.avoidWater ? this.getPositionAvoidWater() : this.getPosition();
        if (position.isEmpty()) {
            return false;
        }
        this.wantedX = position.get().f_82479_;
        this.wantedY = position.get().f_82480_;
        this.wantedZ = position.get().f_82481_;
        this.forceTrigger = false;
        return true;
    }

    protected ISculkSmartEntity getSculkMob() {
        return (ISculkSmartEntity)this.mob;
    }

    @Nullable
    protected Optional<Vec3> getPosition() {
        Optional<Vec3> optional = Optional.ofNullable(DefaultRandomPos.m_148403_((PathfinderMob)this.mob, (int)10, (int)7));
        return optional;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    protected Optional<Vec3> getPositionAvoidWater() {
        Optional<Object> output = Optional.empty();
        boolean doesSquadExist = SquadHandler.doesSquadExist(this.getSculkMob().getSquad());
        boolean isInWater = this.mob.m_20072_();
        if (!doesSquadExist) {
            if (isInWater) {
                output = Optional.ofNullable(LandRandomPos.m_148488_((PathfinderMob)this.mob, (int)15, (int)7));
                if (!output.isPresent()) return this.getPosition();
                return output;
            }
            if (!(this.mob.m_217043_().m_188501_() >= this.probability)) return this.getPosition();
            return Optional.ofNullable(LandRandomPos.m_148488_((PathfinderMob)this.mob, (int)20, (int)7));
        }
        Vec3 squadLeaderPos = ((Mob)this.getSculkMob().getSquad().squadLeader.get()).m_20182_();
        if (isInWater) {
            output = Optional.ofNullable(LandRandomPos.m_148492_((PathfinderMob)this.mob, (int)15, (int)7, (Vec3)squadLeaderPos));
            if (!output.isPresent()) return this.getPosition();
            return output;
        }
        if (!(this.mob.m_217043_().m_188501_() >= this.probability)) return this.getPosition();
        return Optional.ofNullable(LandRandomPos.m_148492_((PathfinderMob)this.mob, (int)10, (int)7, (Vec3)squadLeaderPos));
    }

    public boolean m_8045_() {
        return !this.mob.m_21573_().m_26571_() && !this.mob.m_20160_();
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26519_(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
    }

    public void m_8041_() {
        this.mob.m_21573_().m_26573_();
        super.m_8041_();
    }

    public void trigger() {
        this.forceTrigger = true;
    }

    public void setInterval(int p_25747_) {
        this.interval = p_25747_;
    }
}

