/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.goal;

import com.github.sculkhorde.util.EntityAlgorithms;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public class CustomMeleeAttackGoal
extends Goal {
    protected final PathfinderMob mob;
    protected final double speedModifier;
    protected final boolean followingTargetEvenIfNotSeen;
    protected Path path;
    protected double pathedTargetX;
    protected double pathedTargetY;
    protected double pathedTargetZ;
    protected int ticksUntilNextPathRecalculation;
    protected int ticksUntilNextAttack;
    protected final int attackInterval = 60;
    protected long lastCanUseCheck;
    protected static final long COOLDOWN_BETWEEN_CAN_USE_CHECKS = 20L;
    protected int failedPathFindingPenalty = 0;
    protected boolean canPenalize = false;
    protected int ATTACK_ANIMATION_DELAY_TICKS;
    protected EntityAlgorithms.DelayedHurtScheduler delayedHurtScheduler;

    public CustomMeleeAttackGoal(PathfinderMob mob, double speedMod, boolean followTargetIfNotSeen, int attackAnimationDelayTicksIn) {
        this.mob = mob;
        this.speedModifier = speedMod;
        this.followingTargetEvenIfNotSeen = followTargetIfNotSeen;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.ATTACK_ANIMATION_DELAY_TICKS = attackAnimationDelayTicksIn;
        this.delayedHurtScheduler = new EntityAlgorithms.DelayedHurtScheduler((Mob)mob, this.ATTACK_ANIMATION_DELAY_TICKS);
    }

    protected float getMinimumDistanceToTarget() {
        return 1.0f;
    }

    public boolean m_8036_() {
        long i = this.mob.m_9236_().m_46467_();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (this.canPenalize) {
            if (--this.ticksUntilNextPathRecalculation <= 0) {
                this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
                this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                return this.path != null;
            }
            return true;
        }
        this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(livingentity) >= this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
    }

    public boolean m_8045_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.mob.m_21573_().m_26571_();
        }
        if (!this.mob.m_21444_(livingentity.m_20183_())) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
        this.mob.m_21561_(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void m_8041_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (!EntitySelector.f_20406_.test(livingentity)) {
            this.mob.m_6710_((LivingEntity)null);
        }
        this.mob.m_21561_(false);
        this.mob.m_21573_().m_26573_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        boolean randomChanceToRecalculatePath;
        this.delayedHurtScheduler.tick();
        LivingEntity target = this.mob.m_5448_();
        if (target == null) {
            return;
        }
        this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        double perceivedTargetDistanceSquareForMeleeAttack = this.mob.m_262793_(target);
        this.ticksUntilNextAttack = Math.max(this.getTicksUntilNextAttack() - 1, 0);
        this.checkAndPerformAttack(target, perceivedTargetDistanceSquareForMeleeAttack);
        float distanceToTarget = this.mob.m_20270_((Entity)target);
        if (distanceToTarget <= this.getMinimumDistanceToTarget()) {
            this.mob.m_21573_().m_26573_();
            return;
        }
        this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
        boolean canSeeTarget = this.mob.m_21574_().m_148306_((Entity)target);
        boolean canRecalculatePath = this.ticksUntilNextPathRecalculation <= 0;
        boolean isPathedTargetZERO = this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0;
        boolean isPathedTargetCloseEnough = target.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) < (double)this.getMinimumDistanceToTarget();
        boolean bl = randomChanceToRecalculatePath = this.mob.m_217043_().m_188501_() < 0.05f;
        if ((this.followingTargetEvenIfNotSeen || canSeeTarget) && canRecalculatePath && (isPathedTargetZERO || isPathedTargetCloseEnough || randomChanceToRecalculatePath)) {
            boolean cantReachTarget;
            this.pathedTargetX = target.m_20185_();
            this.pathedTargetY = target.m_20186_();
            this.pathedTargetZ = target.m_20189_();
            this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
            if (this.canPenalize) {
                Node finalPathPoint;
                this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                this.failedPathFindingPenalty = this.mob.m_21573_().m_26570_() != null ? ((finalPathPoint = this.mob.m_21573_().m_26570_().m_77395_()) != null && target.m_20275_((double)finalPathPoint.f_77271_, (double)finalPathPoint.f_77272_, (double)finalPathPoint.f_77273_) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
            }
            if (perceivedTargetDistanceSquareForMeleeAttack > 1024.0) {
                this.ticksUntilNextPathRecalculation += 10;
            } else if (perceivedTargetDistanceSquareForMeleeAttack > 256.0) {
                this.ticksUntilNextPathRecalculation += 5;
            }
            boolean bl2 = cantReachTarget = !this.mob.m_21573_().m_5624_((Entity)target, this.speedModifier);
            if (cantReachTarget) {
                this.ticksUntilNextPathRecalculation += 15;
            }
            this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
        }
    }

    protected void triggerAnimation() {
    }

    protected void checkAndPerformAttack(LivingEntity targetMob, double distanceFromTargetIn) {
        boolean isTargetNull;
        boolean bl = isTargetNull = targetMob == null;
        if (isTargetNull) {
            return;
        }
        double attackReach = this.getAttackReachSqr((LivingEntity)this.mob);
        boolean isTooFarFromTarget = distanceFromTargetIn > attackReach;
        boolean canSeeTarget = this.mob.m_21574_().m_148306_((Entity)targetMob);
        if (!this.isTimeToAttack() || isTooFarFromTarget || !canSeeTarget) {
            return;
        }
        this.triggerAnimation();
        this.delayedHurtScheduler.trigger(attackReach);
        this.resetAttackCooldown();
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.getAttackInterval();
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }

    protected int getAttackInterval() {
        return this.m_183277_(60);
    }

    protected double getAttackReachSqr(LivingEntity p_25556_) {
        return this.mob.m_20205_() * 2.0f * this.mob.m_20205_() * 2.0f + p_25556_.m_20205_();
    }
}

