/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.boss.sculk_enderman;

import com.github.sculkhorde.common.entity.boss.sculk_enderman.SculkEndermanEntity;
import com.github.sculkhorde.common.entity.boss.sculk_enderman.SculkSpineSpikeAttackEntity;
import com.github.sculkhorde.core.ModConfig;
import com.github.sculkhorde.core.ModEntities;
import com.github.sculkhorde.util.BlockAlgorithms;
import com.github.sculkhorde.util.TickUnits;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.phys.Vec3;

public class SculkSpineSpikeLineAttack
extends MeleeAttackGoal {
    protected int elapsedAttackDuration = 0;
    protected final int executionCooldown;
    protected int ticksElapsed = this.executionCooldown = TickUnits.convertSecondsToTicks(20);
    protected Vec3 origin;
    protected Vec3 lookVec;
    protected int DELAY_BEFORE_ATTACK;
    protected int delayRemaining = this.DELAY_BEFORE_ATTACK = 30;
    private Predicate<BlockPos> isValidSpawn = pos -> {
        if (this.f_25540_.m_9236_().m_8055_(pos).m_60795_() || this.f_25540_.m_9236_().m_8055_(pos).m_60819_().m_76170_()) {
            return false;
        }
        if (!this.f_25540_.m_9236_().m_8055_(pos.m_7494_()).m_247087_() || this.f_25540_.m_9236_().m_8055_(pos.m_7494_()).m_60819_().m_76170_()) {
            return false;
        }
        return this.f_25540_.m_9236_().m_8055_(pos.m_7494_().m_7494_()).m_247087_() && !this.f_25540_.m_9236_().m_8055_(pos.m_7494_().m_7494_()).m_60819_().m_76170_();
    };

    public SculkSpineSpikeLineAttack(PathfinderMob mob) {
        super(mob, 0.0, true);
    }

    private SculkEndermanEntity getSculkEnderman() {
        return (SculkEndermanEntity)this.f_25540_;
    }

    public boolean m_8036_() {
        ++this.ticksElapsed;
        if (this.getSculkEnderman().isSpecialAttackOnCooldown() || this.f_25540_.m_5448_() == null || !((Boolean)ModConfig.SERVER.experimental_features_enabled.get()).booleanValue()) {
            return false;
        }
        if (!this.f_25540_.m_19950_((Entity)this.f_25540_.m_5448_(), 13.0) || !this.f_25540_.m_5448_().m_20096_()) {
            return false;
        }
        return this.ticksElapsed >= this.executionCooldown;
    }

    public boolean m_8045_() {
        return this.elapsedAttackDuration <= 60;
    }

    public void m_8056_() {
        super.m_8056_();
        this.getSculkEnderman().canTeleport = false;
        this.getSculkEnderman().m_21573_().m_26573_();
        this.getSculkEnderman().triggerAnim("attack_controller", "spike_radial_animation");
        this.getSculkEnderman().triggerAnim("twitch_controller", "spike_radial_twitch_animation");
        this.origin = new Vec3(this.f_25540_.m_20185_(), this.f_25540_.m_20186_() + (double)this.f_25540_.m_20192_(), this.f_25540_.m_20189_());
        this.lookVec = this.f_25540_.m_20154_();
        this.f_25540_.m_21573_().m_26573_();
        this.getSculkEnderman().teleportAwayFromEntity((Entity)this.f_25540_.m_5448_());
    }

    public int getSpawnHeight(BlockPos startPos) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(startPos.m_123341_(), startPos.m_123342_(), startPos.m_123343_());
        int iterationsMax = 7;
        for (int iterationsElapsed = 0; iterationsElapsed < iterationsMax; ++iterationsElapsed) {
            if (!this.f_25540_.m_9236_().m_8055_((BlockPos)mutablePos).m_247087_()) continue;
            mutablePos.m_122184_(0, -1, 0);
        }
        return mutablePos.m_123342_() + 1;
    }

    public void spawnSpikesOnCircumference(int radius, int amount) {
        ArrayList<SculkSpineSpikeAttackEntity> entities = new ArrayList<SculkSpineSpikeAttackEntity>();
        ArrayList<Vec3> possibleSpawns = BlockAlgorithms.getPointsOnCircumferenceVec3(this.origin, radius, amount);
        for (int i = 0; i < possibleSpawns.size(); ++i) {
            Vec3 spawnPos = possibleSpawns.get(i);
            SculkSpineSpikeAttackEntity entity = (SculkSpineSpikeAttackEntity)((EntityType)ModEntities.SCULK_SPINE_SPIKE_ATTACK.get()).m_20615_(this.f_25540_.m_9236_());
            assert (entity != null);
            double spawnHeight = this.getSpawnHeight(BlockPos.m_274446_((Position)spawnPos));
            Vec3 possibleSpawnPosition = new Vec3(spawnPos.m_7096_(), spawnHeight, spawnPos.m_7094_());
            if (this.f_25540_.m_9236_().m_8055_(BlockPos.m_274446_((Position)possibleSpawnPosition).m_7495_()).m_247087_()) continue;
            entity.m_6034_(possibleSpawnPosition.m_7096_(), possibleSpawnPosition.m_7098_(), possibleSpawnPosition.m_7094_());
            entities.add(entity);
            entity.setOwner((LivingEntity)this.f_25540_);
        }
        for (SculkSpineSpikeAttackEntity entity : entities) {
            this.f_25540_.m_9236_().m_7967_((Entity)entity);
        }
    }

    public void spawnSpikesInPerpendicularLineInFrontOfEnderman(int offsetFromEnderman) {
        Vec3 middle = this.origin.m_82549_(this.lookVec.m_82490_((double)offsetFromEnderman));
        Vec3 left = new Vec3(this.origin.m_7094_(), 0.0, -this.origin.m_7096_());
        Vec3 right = new Vec3(-this.origin.m_7094_(), 0.0, this.origin.m_7096_());
        left = new Vec3(middle.m_7096_() + left.m_7096_(), (double)this.getSpawnHeight(BlockPos.m_274446_((Position)middle)), middle.m_7094_() + left.m_7094_());
        right = new Vec3(middle.m_7096_() + right.m_7096_(), (double)this.getSpawnHeight(BlockPos.m_274446_((Position)middle)), middle.m_7094_() + right.m_7094_());
        SculkSpineSpikeAttackEntity leftEntity = (SculkSpineSpikeAttackEntity)((EntityType)ModEntities.SCULK_SPINE_SPIKE_ATTACK.get()).m_20615_(this.f_25540_.m_9236_());
        assert (leftEntity != null);
        leftEntity.m_6034_(left.m_7096_(), left.m_7098_(), left.m_7094_());
        leftEntity.setOwner((LivingEntity)this.f_25540_);
        this.f_25540_.m_9236_().m_7967_((Entity)leftEntity);
        SculkSpineSpikeAttackEntity rightEntity = (SculkSpineSpikeAttackEntity)((EntityType)ModEntities.SCULK_SPINE_SPIKE_ATTACK.get()).m_20615_(this.f_25540_.m_9236_());
        assert (rightEntity != null);
        rightEntity.m_6034_(right.m_7096_(), right.m_7098_(), right.m_7094_());
        rightEntity.setOwner((LivingEntity)this.f_25540_);
        this.f_25540_.m_9236_().m_7967_((Entity)rightEntity);
        SculkSpineSpikeAttackEntity middleEntity = (SculkSpineSpikeAttackEntity)((EntityType)ModEntities.SCULK_SPINE_SPIKE_ATTACK.get()).m_20615_(this.f_25540_.m_9236_());
        assert (middleEntity != null);
        middleEntity.m_6034_(middle.m_7096_(), middle.m_7098_(), middle.m_7094_());
        middleEntity.setOwner((LivingEntity)this.f_25540_);
        this.f_25540_.m_9236_().m_7967_((Entity)middleEntity);
    }

    public void m_8037_() {
        super.m_8037_();
        this.delayRemaining = Math.max(0, this.delayRemaining - 1);
        if (this.delayRemaining != 0) {
            return;
        }
        this.spawnSpikesInPerpendicularLineInFrontOfEnderman(this.elapsedAttackDuration + 1);
        ++this.elapsedAttackDuration;
    }

    public void m_8041_() {
        super.m_8041_();
        this.getSculkEnderman().resetSpecialAttackCooldown();
        this.elapsedAttackDuration = 0;
        this.ticksElapsed = 0;
        this.getSculkEnderman().canTeleport = true;
        this.delayRemaining = this.DELAY_BEFORE_ATTACK;
    }

    public boolean m_183429_() {
        return true;
    }
}

