/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.boss.sculk_enderman;

import com.github.sculkhorde.common.entity.boss.SpecialEffectEntity;
import com.github.sculkhorde.core.ModEntities;
import com.github.sculkhorde.util.EntityAlgorithms;
import com.github.sculkhorde.util.TickUnits;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.CustomInstructionKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SculkSpineSpikeAttackEntity
extends SpecialEffectEntity
implements TraceableEntity,
GeoEntity {
    public static int LIFE_IN_TICKS = TickUnits.convertSecondsToTicks(2);
    public static int ATTACK_DELAY_TICKS = TickUnits.convertSecondsToTicks(0.5f);
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    private int lifeTicks = 0;
    private boolean clientSideAttackStarted;
    private static final RawAnimation ATTACK_ANIMATION = RawAnimation.begin().thenPlay("misc.living");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final AnimationController ATTACK_ANIMATION_CONTROLLER = new AnimationController((GeoAnimatable)this, "attack_controller", state2 -> PlayState.STOP).triggerableAnim("attack_animation", ATTACK_ANIMATION).setCustomInstructionKeyframeHandler(this::instructionListener);

    public SculkSpineSpikeAttackEntity(EntityType<? extends SculkSpineSpikeAttackEntity> entityType, Level level) {
        super(entityType, level);
        this.triggerAnim("attack_controller", "attack_animation");
        this.ATTACK_ANIMATION_CONTROLLER.setAnimationSpeed(0.0);
    }

    public SculkSpineSpikeAttackEntity(LivingEntity owner, double x, double y, double z) {
        super((EntityType)ModEntities.SCULK_SPINE_SPIKE_ATTACK.get(), owner.m_9236_());
        this.m_6034_(x, y, z);
        this.owner = owner;
        this.ownerUUID = owner.m_20148_();
    }

    public void setAppearanceDelay(int delay) {
        this.lifeTicks -= delay;
    }

    private void dealDamageTo(LivingEntity targetEntity) {
        LivingEntity livingentity = this.getOwner();
        if (targetEntity.m_6084_() && !targetEntity.m_20147_() && targetEntity != livingentity) {
            if (livingentity == null) {
                targetEntity.m_6469_(this.m_269291_().m_269264_(), 6.0f);
                return;
            }
            if (livingentity.m_7307_((Entity)targetEntity)) {
                return;
            }
            if (EntityAlgorithms.isSculkLivingEntity.test(targetEntity)) {
                return;
            }
            targetEntity.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)livingentity), 6.0f);
            targetEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, TickUnits.convertMinutesToTicks(1), 0));
            targetEntity.m_7292_(new MobEffectInstance(MobEffects.f_19620_, TickUnits.convertSecondsToTicks(20), 0));
        }
    }

    public void hurtTouchingEntities() {
        for (LivingEntity livingEntity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(0.5))) {
            if (livingEntity == this.getOwner()) continue;
            this.dealDamageTo(livingEntity);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.lifeTicks == 0) {
            this.ATTACK_ANIMATION_CONTROLLER.setAnimationSpeed(1.0);
        }
        ++this.lifeTicks;
        if (this.m_9236_().f_46443_) {
            if (!this.clientSideAttackStarted || this.lifeTicks == ATTACK_DELAY_TICKS) {
                // empty if block
            }
            return;
        }
        if (this.lifeTicks == ATTACK_DELAY_TICKS) {
            this.hurtTouchingEntities();
        }
        if (this.lifeTicks > LIFE_IN_TICKS || this.ATTACK_ANIMATION_CONTROLLER.hasAnimationFinished()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void m_7822_(byte b) {
        super.m_7822_(b);
        this.clientSideAttackStarted = true;
        if (!this.m_20067_()) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11865_, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.2f + 0.85f, false);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{this.ATTACK_ANIMATION_CONTROLLER});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private <ENTITY extends GeoEntity> void instructionListener(CustomInstructionKeyframeEvent<ENTITY> event) {
        if (event.getKeyframeData().getInstructions().contains("DoDamageInstruction") && this.m_9236_().m_5776_()) {
            for (int i = 0; i < 12; ++i) {
                double d0 = this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                double d1 = this.m_20186_() + 0.05 + this.f_19796_.m_188500_();
                double d2 = this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                double d3 = (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.3;
                double d4 = 0.3 + this.f_19796_.m_188500_() * 0.3;
                double d5 = (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.3;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, d0, d1 + 1.0, d2, d3, d4, d5);
            }
        }
    }
}

