/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.boss.sculk_enderman;

import com.github.sculkhorde.common.entity.ISculkSmartEntity;
import com.github.sculkhorde.common.entity.boss.sculk_enderman.ChaosRiftAttackGoal;
import com.github.sculkhorde.common.entity.boss.sculk_enderman.EnderBubbleAttackGoal;
import com.github.sculkhorde.common.entity.boss.sculk_enderman.RainDragonBallAttackGoal;
import com.github.sculkhorde.common.entity.boss.sculk_enderman.RangedSonicBoomAttackGoal;
import com.github.sculkhorde.common.entity.boss.sculk_enderman.SculkSpineSpikeRadialAttack;
import com.github.sculkhorde.common.entity.boss.sculk_enderman.SummonCreepersAttackUnits;
import com.github.sculkhorde.common.entity.boss.sculk_enderman.SummonMitesAttackUnits;
import com.github.sculkhorde.common.entity.boss.sculk_enderman.SummonRandomAttackUnits;
import com.github.sculkhorde.common.entity.boss.sculk_enderman.SummonSkeletonsAttackUnits;
import com.github.sculkhorde.common.entity.goal.CustomMeleeAttackGoal;
import com.github.sculkhorde.common.entity.goal.ImprovedRandomStrollGoal;
import com.github.sculkhorde.common.entity.goal.InvalidateTargetGoal;
import com.github.sculkhorde.common.entity.goal.NearestLivingEntityTargetGoal;
import com.github.sculkhorde.common.entity.goal.PathFindToRaidLocation;
import com.github.sculkhorde.common.entity.goal.TargetAttacker;
import com.github.sculkhorde.core.ModEntities;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.core.gravemind.RaidHandler;
import com.github.sculkhorde.util.BlockAlgorithms;
import com.github.sculkhorde.util.SquadHandler;
import com.github.sculkhorde.util.TargetParameters;
import com.github.sculkhorde.util.TickUnits;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SculkEndermanEntity
extends Monster
implements GeoEntity,
ISculkSmartEntity {
    public static final float MAX_HEALTH = 200.0f;
    public static final float ARMOR = 5.0f;
    public static final float ATTACK_DAMAGE = 20.0f;
    public static final float ATTACK_KNOCKBACK = 5.0f;
    public static final float FOLLOW_RANGE = 64.0f;
    public static final float MOVEMENT_SPEED = 0.4f;
    private final TargetParameters TARGET_PARAMETERS = new TargetParameters((Mob)this).enableTargetHostiles().enableTargetInfected().disableBlackListMobs();
    public boolean canTeleport = true;
    protected int TELEPORT_COOLDOWN = TickUnits.convertSecondsToTicks(8);
    protected int ticksSinceLastTeleport = 0;
    protected int SPECIAL_ATTACK_COOLDOWN = TickUnits.convertSecondsToTicks(5);
    protected int ticksSinceLastSpecialAttack = 0;
    protected ServerBossEvent bossEvent;
    public static final EntityDataAccessor<Boolean> DATA_AGGRO = SynchedEntityData.m_135353_(SculkEndermanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_SCOUTING = SynchedEntityData.m_135353_(SculkEndermanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean isParticipatingInRaid = false;
    String DATA_IS_SCOUTING_IDENTIFIER = "is_scouting";
    String DATA_IS_AGGRO_IDENTIFIER = "is_aggro";
    private static final RawAnimation IDLE_BODY_ANIMATION = RawAnimation.begin().thenPlay("idle");
    private static final RawAnimation IDLE_TWITCH_ANIMATION = RawAnimation.begin().thenPlay("idle.twitch");
    private static final RawAnimation IDLE_TENDRILS_ANIMATION = RawAnimation.begin().thenPlay("idle.tendrils");
    private static final RawAnimation WALK_ANIMATION = RawAnimation.begin().thenPlay("move.walk");
    private static final RawAnimation RUN_ANIMATION = RawAnimation.begin().thenPlay("move.run");
    private static final RawAnimation COMBAT_ATTACK_ANIMATION_1 = RawAnimation.begin().thenPlay("combat.attack1");
    private static final RawAnimation COMBAT_ATTACK_ANIMATION_2 = RawAnimation.begin().thenPlay("combat.attack2");
    private static final RawAnimation COMBAT_ATTACK_ANIMATION_3 = RawAnimation.begin().thenPlay("combat.attack3");
    private static final RawAnimation COMBAT_FIREBALL_SHOOT_ANIMATION = RawAnimation.begin().thenPlay("combat.fireball.face");
    private static final RawAnimation COMBAT_FIREBALL_SKY_SUMMON_ANIMATION = RawAnimation.begin().thenPlay("combat.fireball.sky.summon");
    private static final RawAnimation COMBAT_FIREBALL_SKY_TWITCH_ANIMATION = RawAnimation.begin().thenPlay("combat.fireball.sky.twitch");
    private static final RawAnimation COMBAT_SUMMON_ANIMATION = RawAnimation.begin().thenLoop("combat.summon");
    private static final RawAnimation COMBAT_SUMMON_TWITCH_ANIMATION = RawAnimation.begin().thenLoop("combat.summon.twitch");
    private static final RawAnimation COMBAT_RIFTS_SUMMON_ANIMATION = RawAnimation.begin().thenPlay("combat.rifts.summon");
    private static final RawAnimation COMBAT_SPIKE_LINE = RawAnimation.begin().thenPlay("combat.spike.line");
    private static final RawAnimation COMBAT_SPIKE_TWITCH = RawAnimation.begin().thenPlay("combat.spike.line.twitch");
    private static final RawAnimation COMBAT_SPIKE_RADIAL = RawAnimation.begin().thenPlay("combat.spike.around");
    private static final RawAnimation COMBAT_SPIKE_RADIAL_TWITCH = RawAnimation.begin().thenPlay("combat.spike.around.twitch");
    private static final RawAnimation COMBAT_BUBBLE = RawAnimation.begin().thenPlay("combat.forcefieldbubble.activate");
    private static final RawAnimation COMBAT_BUBBLE_TWITCH = RawAnimation.begin().thenPlay("combat.forcefieldbubble.twitch");
    private final AnimationController COMBAT_ATTACK_ANIMATION_CONTROLLER = new AnimationController((GeoAnimatable)this, "attack_controller", state2 -> PlayState.STOP).transitionLength(5).triggerableAnim("melee_attack_animation_1", COMBAT_ATTACK_ANIMATION_1).triggerableAnim("melee_attack_animation_2", COMBAT_ATTACK_ANIMATION_2).triggerableAnim("melee_attack_animation_3", COMBAT_ATTACK_ANIMATION_3).triggerableAnim("fireball_shoot_animation", COMBAT_FIREBALL_SHOOT_ANIMATION).triggerableAnim("fireball_sky_summon_animation", COMBAT_FIREBALL_SKY_SUMMON_ANIMATION).triggerableAnim("fireball_sky_twitch_animation", COMBAT_FIREBALL_SKY_TWITCH_ANIMATION).triggerableAnim("summon_animation", COMBAT_SUMMON_ANIMATION).triggerableAnim("rifts_summon_animation", COMBAT_RIFTS_SUMMON_ANIMATION).triggerableAnim("spike_line_animation", COMBAT_SPIKE_LINE).triggerableAnim("spike_radial_animation", COMBAT_SPIKE_RADIAL).triggerableAnim("bubble_animation", COMBAT_BUBBLE);
    private final AnimationController COMBAT_TWITCH_ANIMATION_CONTROLLER = new AnimationController((GeoAnimatable)this, "twitch_controller", state2 -> PlayState.STOP).transitionLength(5).triggerableAnim("fireball_sky_twitch_animation", COMBAT_FIREBALL_SKY_TWITCH_ANIMATION).triggerableAnim("summon_twitch_animation", COMBAT_SUMMON_TWITCH_ANIMATION).triggerableAnim("spike_line_twitch_animation", COMBAT_SPIKE_TWITCH).triggerableAnim("spike_radial_twitch_animation", COMBAT_SPIKE_RADIAL_TWITCH).triggerableAnim("bubble_twitch_animation", COMBAT_BUBBLE_TWITCH);

    public SculkEndermanEntity(EntityType<? extends SculkEndermanEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_274367_(1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.bossEvent = this.createBossEvent();
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
    }

    public SculkEndermanEntity(Level level, BlockPos pos) {
        this((EntityType<? extends SculkEndermanEntity>)((EntityType)ModEntities.SCULK_ENDERMAN.get()), level);
        this.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22282_, 5.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22279_, (double)0.4f).m_22268_(Attributes.f_22278_, 1.0);
    }

    public boolean isSpecialAttackOnCooldown() {
        return this.ticksSinceLastSpecialAttack < this.SPECIAL_ATTACK_COOLDOWN;
    }

    public void incrementSpecialAttackCooldown() {
        ++this.ticksSinceLastSpecialAttack;
    }

    public void resetSpecialAttackCooldown() {
        this.ticksSinceLastSpecialAttack = 0;
    }

    @Override
    public boolean isIdle() {
        return this.m_5448_() == null;
    }

    @Override
    public SquadHandler getSquad() {
        return null;
    }

    @Override
    public boolean isParticipatingInRaid() {
        return this.isParticipatingInRaid;
    }

    @Override
    public void setParticipatingInRaid(boolean isParticipatingInRaidIn) {
        this.isParticipatingInRaid = isParticipatingInRaidIn;
    }

    public boolean isScouting() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SCOUTING);
    }

    public void setScouting(boolean value) {
        this.f_19804_.m_135381_(DATA_SCOUTING, (Object)value);
    }

    public boolean isAggro() {
        return (Boolean)this.f_19804_.m_135370_(DATA_AGGRO);
    }

    public void setAggro() {
        this.f_19804_.m_135381_(DATA_AGGRO, (Object)true);
    }

    @Override
    public TargetParameters getTargetParameters() {
        return this.TARGET_PARAMETERS;
    }

    public boolean isTeleportCooldownOver() {
        if (this.m_5448_() != null) {
            return this.ticksSinceLastTeleport >= this.TELEPORT_COOLDOWN / 8;
        }
        return this.ticksSinceLastTeleport >= this.TELEPORT_COOLDOWN;
    }

    public void m_6043_() {
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ChaosRiftAttackGoal((PathfinderMob)this, TickUnits.convertSecondsToTicks(3)));
        this.f_21345_.m_25352_(1, (Goal)new SculkSpineSpikeRadialAttack((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new SummonSkeletonsAttackUnits((PathfinderMob)this, TickUnits.convertSecondsToTicks(3)));
        this.f_21345_.m_25352_(1, (Goal)new RangedSonicBoomAttackGoal((PathfinderMob)this, TickUnits.convertSecondsToTicks(1)));
        this.f_21345_.m_25352_(2, (Goal)new SummonRandomAttackUnits((PathfinderMob)this, TickUnits.convertSecondsToTicks(3)));
        this.f_21345_.m_25352_(2, (Goal)new SummonMitesAttackUnits((PathfinderMob)this, TickUnits.convertSecondsToTicks(3)));
        this.f_21345_.m_25352_(1, (Goal)new RainDragonBallAttackGoal((PathfinderMob)this, TickUnits.convertSecondsToTicks(5)));
        this.f_21345_.m_25352_(1, (Goal)new EnderBubbleAttackGoal((PathfinderMob)this, TickUnits.convertSecondsToTicks(10)));
        this.f_21345_.m_25352_(2, (Goal)new SummonCreepersAttackUnits((PathfinderMob)this, TickUnits.convertSecondsToTicks(5)));
        this.f_21345_.m_25352_(3, (Goal)new AttackGoal());
        this.f_21345_.m_25352_(4, new PathFindToRaidLocation<SculkEndermanEntity>(this));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 1.0, 20.0f));
        this.f_21345_.m_25352_(6, (Goal)new ImprovedRandomStrollGoal((PathfinderMob)this, 1.0).setToAvoidWater(true));
        this.f_21346_.m_25352_(0, (Goal)new InvalidateTargetGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new TargetAttacker((Mob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new NearestLivingEntityTargetGoal((Mob)this, false, false));
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        boolean isIndirectMagicDamageType = damageSource.m_276093_(DamageTypes.f_268530_);
        if (isIndirectMagicDamageType) {
            return false;
        }
        if (this.f_19796_.m_188503_(2) == 0) {
            this.teleportRandomly(32);
        }
        this.setAggro();
        return super.m_6469_(damageSource, amount);
    }

    public void m_8107_() {
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            }
        }
        if (this.m_5448_() != null && !this.TARGET_PARAMETERS.canSeeTarget()) {
            this.teleportBehindEntity((Entity)this.m_5448_());
        }
        if (this.m_5448_() != null && !this.m_5448_().m_20096_()) {
            this.stayInSpecificRangeOfTarget(16, 32);
        }
        this.f_20899_ = false;
        super.m_8107_();
    }

    private boolean isWithinRaidLocation() {
        return BlockAlgorithms.getBlockDistance(RaidHandler.raidData.getRaidLocation(), this.m_20183_()) <= 32.0f;
    }

    private void teleportToRaidLocationIfOutside() {
        this.teleport(RaidHandler.raidData.getRaidLocation().m_123341_(), RaidHandler.raidData.getRaidLocation().m_123342_(), RaidHandler.raidData.getRaidLocation().m_123343_());
    }

    public void stayInSpecificRangeOfTarget(int min, int max) {
        if (this.m_5448_() == null) {
            return;
        }
        if (!this.isTeleportCooldownOver()) {
            return;
        }
        if (this.m_20270_((Entity)this.m_5448_()) > (float)max) {
            this.teleportTowardsEntity((Entity)this.m_5448_());
        } else if (this.m_20270_((Entity)this.m_5448_()) < (float)min) {
            this.teleportAwayFromEntity((Entity)this.m_5448_());
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        ++this.ticksSinceLastTeleport;
        this.incrementSpecialAttackCooldown();
        if (!SculkHorde.raidHandler.isRaidInactive() && !this.isWithinRaidLocation() && this.isScouting() && this.isTeleportCooldownOver()) {
            this.teleportToRaidLocationIfOutside();
        }
        if (SculkHorde.raidHandler.isRaidInactive() && this.isScouting()) {
            this.m_146870_();
        }
    }

    protected void teleportRandomly(int distance) {
        if (this.m_9236_().m_5776_() || !this.m_6084_() || !this.canTeleport) {
            return;
        }
        double d0 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)distance;
        double d1 = this.m_20186_() + (double)((int)(this.f_19796_.m_188500_() - 0.5) * distance);
        double d2 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)distance;
        this.teleport(d0, d1, d2);
    }

    public void teleportTowardsEntity(Entity entity) {
        if (!this.canTeleport || !this.isTeleportCooldownOver()) {
            return;
        }
        this.ticksSinceLastTeleport = 0;
        Vec3 vec3 = new Vec3(this.m_20185_() - entity.m_20185_(), this.m_20227_(0.5) - entity.m_20188_(), this.m_20189_() - entity.m_20189_());
        vec3 = vec3.m_82541_();
        double teleportDistance = 8.0;
        double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82479_ * teleportDistance;
        double d2 = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8) - vec3.f_82480_ * teleportDistance;
        double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82481_ * teleportDistance;
        this.teleport(d1, d2, d3);
    }

    protected boolean teleportTowardsPos(BlockPos pos) {
        if (!this.canTeleport) {
            return false;
        }
        Vec3 vec3 = new Vec3(this.m_20185_() - (double)pos.m_123341_(), this.m_20227_(0.5), this.m_20189_() - (double)pos.m_123343_());
        vec3 = vec3.m_82541_();
        double teleportDistance = 8.0;
        double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82479_ * teleportDistance;
        double d2 = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8) - vec3.f_82480_ * teleportDistance;
        double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82481_ * teleportDistance;
        return this.teleport(d1, d2, d3);
    }

    public boolean teleportAwayFromEntity(Entity entity) {
        if (!this.canTeleport) {
            return false;
        }
        Vec3 vec3 = new Vec3(this.m_20185_() - entity.m_20185_(), this.m_20227_(0.5) - entity.m_20188_(), this.m_20189_() - entity.m_20189_());
        vec3 = vec3.m_82541_();
        double teleportDistance = 8.0;
        double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 + vec3.f_82479_ * teleportDistance;
        double d2 = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8) + vec3.f_82480_ * teleportDistance;
        double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 + vec3.f_82481_ * teleportDistance;
        return this.teleport(d1, d2, d3);
    }

    protected void teleportBehindEntity(Entity entity) {
        if (!this.canTeleport) {
            return;
        }
        this.teleport(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
    }

    protected boolean teleport(double x, double y, double z) {
        if (!this.canTeleport) {
            return false;
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(x, y, z);
        while (blockpos$mutableblockpos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos).m_280555_()) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean isMotionBlockFlag = false;
        blockstate.m_280555_();
        boolean isWaterFlag = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (!isWaterFlag) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)x, (double)y, (double)z);
            if (event.isCanceled()) {
                return false;
            }
            Vec3 vec3 = this.m_20182_();
            boolean ifCanRandomTeleport = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (ifCanRandomTeleport) {
                this.m_9236_().m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)this));
                if (!this.m_20067_()) {
                    this.m_9236_().m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                    this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                    this.ticksSinceLastTeleport = 0;
                }
            }
            return ifCanRandomTeleport;
        }
        return false;
    }

    protected ServerBossEvent createBossEvent() {
        ServerBossEvent event = new ServerBossEvent((Component)Component.m_237113_((String)"Sculk Enderman"), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS);
        return event;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossEvent.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossEvent.m_6539_(player);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_AGGRO, (Object)false);
        this.f_19804_.m_135372_(DATA_SCOUTING, (Object)false);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_(this.DATA_IS_SCOUTING_IDENTIFIER, ((Boolean)this.f_19804_.m_135370_(DATA_SCOUTING)).booleanValue());
        nbt.m_128379_(this.DATA_IS_AGGRO_IDENTIFIER, ((Boolean)this.f_19804_.m_135370_(DATA_AGGRO)).booleanValue());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.f_19804_.m_135381_(DATA_SCOUTING, (Object)nbt.m_128471_(this.DATA_IS_SCOUTING_IDENTIFIER));
        this.f_19804_.m_135381_(DATA_AGGRO, (Object)nbt.m_128471_(this.DATA_IS_AGGRO_IDENTIFIER));
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_269533_(DamageTypeTags.f_268484_);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "walk_cycle", 5, this::poseWalk), new AnimationController((GeoAnimatable)this, "twitch", 5, this::poseTwitch), new AnimationController((GeoAnimatable)this, "tendrils", 5, this::poseTendrils), this.COMBAT_ATTACK_ANIMATION_CONTROLLER});
    }

    protected PlayState poseWalk(AnimationState<SculkEndermanEntity> state2) {
        if (state2.isMoving() && ((SculkEndermanEntity)state2.getAnimatable()).isAggro()) {
            state2.setAnimation(RUN_ANIMATION);
        } else if (state2.isMoving()) {
            state2.setAnimation(WALK_ANIMATION);
        } else {
            state2.setAnimation(IDLE_BODY_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    protected PlayState poseTwitch(AnimationState<SculkEndermanEntity> state2) {
        state2.setAnimation(IDLE_TWITCH_ANIMATION);
        return PlayState.CONTINUE;
    }

    protected PlayState poseTendrils(AnimationState<SculkEndermanEntity> state2) {
        state2.setAnimation(IDLE_TENDRILS_ANIMATION);
        return PlayState.CONTINUE;
    }

    protected float m_6431_(Pose p_32517_, EntityDimensions p_32518_) {
        return 2.55f;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11899_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11849_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11900_;
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(SoundEvents.f_12614_, 0.15f, 1.0f);
    }

    public boolean m_213854_() {
        return true;
    }

    class AttackGoal
    extends CustomMeleeAttackGoal {
        public AttackGoal() {
            super((PathfinderMob)SculkEndermanEntity.this, 1.0, true, 17);
        }

        @Override
        protected double getAttackReachSqr(LivingEntity pAttackTarget) {
            return 6.0;
        }

        @Override
        protected float getMinimumDistanceToTarget() {
            return 0.5f;
        }

        @Override
        protected void triggerAnimation() {
            int random = new Random().nextInt(3);
            if (random == 0) {
                ((SculkEndermanEntity)this.mob).triggerAnim("attack_controller", "melee_attack_animation_1");
            } else if (random == 1) {
                ((SculkEndermanEntity)this.mob).triggerAnim("attack_controller", "melee_attack_animation_2");
            } else {
                ((SculkEndermanEntity)this.mob).triggerAnim("attack_controller", "melee_attack_animation_3");
            }
        }
    }
}

