/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.boss.sculk_enderman;

import com.github.sculkhorde.common.entity.boss.SpecialEffectEntity;
import com.github.sculkhorde.common.entity.boss.sculk_enderman.SculkEndermanEntity;
import com.github.sculkhorde.core.ModEntities;
import com.github.sculkhorde.util.EntityAlgorithms;
import com.github.sculkhorde.util.TickUnits;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EnderBubbleAttackEntity
extends SpecialEffectEntity
implements GeoEntity {
    public static int LIFE_TIME = TickUnits.convertSecondsToTicks(10);
    public int currentLifeTicks = 0;
    private double pushUpStrength = 0.1;
    private double orbitStrength = 0.5;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public EnderBubbleAttackEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public EnderBubbleAttackEntity(Level level) {
        super((EntityType)ModEntities.ENDER_BUBBLE_ATTACK.get(), level);
    }

    public EnderBubbleAttackEntity(EntityType<?> entityType, Level level, LivingEntity sourceEntity) {
        super(entityType, level);
    }

    public EnderBubbleAttackEntity enableDeleteAfterTime(int ticks) {
        LIFE_TIME = ticks;
        return this;
    }

    private void pullInEntities(double range) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        Predicate<Entity> predicate = entity -> {
            if (entity == null) {
                return false;
            }
            if (entity instanceof Player) {
                Player p = (Player)entity;
                return false;
            }
            if (entity instanceof SculkEndermanEntity) {
                return false;
            }
            boolean entityIsPushable = !entity.f_19794_;
            return entityIsPushable;
        };
        List<Entity> pushAwayList = EntityAlgorithms.getEntitiesInBoundingBox((ServerLevel)this.m_9236_(), this.m_20191_().m_82377_(range, range, range), predicate);
        for (Entity entity2 : pushAwayList) {
            float pushAwayStrength = 0.01f;
            Vec3 vector = this.m_20182_().m_82546_(entity2.m_20182_()).m_82541_();
            entity2.m_5997_(vector.f_82479_ * (double)pushAwayStrength, vector.f_82480_ * (double)pushAwayStrength, vector.f_82481_ * (double)pushAwayStrength);
            double dx = entity2.m_20185_() - this.m_20185_();
            double dy = entity2.m_20186_() - this.m_20186_();
            double dz = entity2.m_20189_() - this.m_20189_();
            double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            entity2.m_5997_(0.0, this.pushUpStrength, 0.0);
            double ox = -(dz /= distance);
            double oy = dy /= distance;
            double oz = dx /= distance;
            entity2.m_5997_(ox * this.orbitStrength, oy * this.orbitStrength, oz * this.orbitStrength);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.currentLifeTicks;
        if (this.currentLifeTicks >= LIFE_TIME && LIFE_TIME != -1) {
            this.m_146870_();
        }
        this.pullInEntities(20.0);
        List<LivingEntity> damageHitList = this.getEntitiesNearbyCube(LivingEntity.class, 3.0);
        for (LivingEntity entity : damageHitList) {
            if (this.getOwner() != null && this.getOwner().equals((Object)entity)) continue;
            if (this.getOwner() != null) {
                entity.m_6469_(this.m_269291_().m_269104_((Entity)entity, (Entity)this.getOwner()), 5.0f);
                continue;
            }
            entity.m_6469_(this.m_269291_().m_269104_((Entity)entity, (Entity)this), 5.0f);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericIdleController((GeoAnimatable)this)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

