/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.boss.sculk_enderman;

import com.github.sculkhorde.common.entity.boss.SpecialEffectEntity;
import com.github.sculkhorde.common.entity.boss.sculk_enderman.ChaosTeleporationRiftEntity;
import com.github.sculkhorde.common.entity.boss.sculk_enderman.SculkEndermanEntity;
import com.github.sculkhorde.core.ModEntities;
import com.github.sculkhorde.util.BlockAlgorithms;
import com.github.sculkhorde.util.TickUnits;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;

public class ChaosRiftAttackGoal
extends MeleeAttackGoal {
    protected int maxAttackDuration = 0;
    protected int elapsedAttackDuration = 0;
    protected final int executionCooldown;
    protected int ticksElapsed = this.executionCooldown = TickUnits.convertSecondsToTicks(10);
    private Predicate<BlockPos> isValidSpawn = pos -> {
        if (this.f_25540_.m_9236_().m_8055_(pos).m_60795_() || this.f_25540_.m_9236_().m_8055_(pos).m_60819_().m_76170_()) {
            return false;
        }
        if (!this.f_25540_.m_9236_().m_8055_(pos.m_7494_()).m_247087_() || this.f_25540_.m_9236_().m_8055_(pos.m_7494_()).m_60819_().m_76170_()) {
            return false;
        }
        return this.f_25540_.m_9236_().m_8055_(pos.m_7494_().m_7494_()).m_247087_() && !this.f_25540_.m_9236_().m_8055_(pos.m_7494_().m_7494_()).m_60819_().m_76170_();
    };

    public ChaosRiftAttackGoal(PathfinderMob mob, int durationInTicks) {
        super(mob, 0.0, true);
        this.maxAttackDuration = durationInTicks;
    }

    private SculkEndermanEntity getSculkEnderman() {
        return (SculkEndermanEntity)this.f_25540_;
    }

    public boolean m_8036_() {
        ++this.ticksElapsed;
        if (this.getSculkEnderman().isSpecialAttackOnCooldown() || this.f_25540_.m_5448_() == null) {
            return false;
        }
        if (!this.f_25540_.m_19950_((Entity)this.f_25540_.m_5448_(), 5.0) || !this.f_25540_.m_5448_().m_20096_()) {
            return false;
        }
        return this.ticksElapsed >= this.executionCooldown;
    }

    public boolean m_8045_() {
        return this.elapsedAttackDuration < this.maxAttackDuration;
    }

    public void m_8056_() {
        super.m_8056_();
        this.getSculkEnderman().triggerAnim("attack_controller", "rifts_summon_animation");
        this.f_25540_.m_21573_().m_26573_();
        this.getSculkEnderman().canTeleport = false;
        this.getSculkEnderman().teleportAwayFromEntity((Entity)this.f_25540_.m_5448_());
        ArrayList<BlockPos> possibleSpawns = BlockAlgorithms.getBlocksInAreaWithBlockPosPredicate((ServerLevel)this.f_25540_.m_9236_(), this.f_25540_.m_20183_(), this.isValidSpawn, 10);
        Collections.shuffle(possibleSpawns);
        for (int i = 0; i < 20 && i < possibleSpawns.size(); ++i) {
            BlockPos spawnPos = possibleSpawns.get(i);
            SpecialEffectEntity entity = ChaosTeleporationRiftEntity.spawn(this.f_25540_.m_9236_(), (LivingEntity)this.f_25540_, spawnPos.m_7494_().m_7494_(), (EntityType)ModEntities.CHAOS_TELEPORATION_RIFT.get());
            entity.setOwner((LivingEntity)this.f_25540_);
        }
    }

    public void m_8037_() {
        super.m_8037_();
        ++this.elapsedAttackDuration;
    }

    public void m_8041_() {
        super.m_8041_();
        this.getSculkEnderman().resetSpecialAttackCooldown();
        this.elapsedAttackDuration = 0;
        this.ticksElapsed = 0;
        this.getSculkEnderman().canTeleport = true;
    }
}

