/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity;

import com.github.sculkhorde.common.entity.ISculkSmartEntity;
import com.github.sculkhorde.common.entity.SculkPhantomCorpseEntity;
import com.github.sculkhorde.common.entity.components.ImprovedFlyingNavigator;
import com.github.sculkhorde.common.entity.goal.DespawnAfterTime;
import com.github.sculkhorde.common.entity.goal.InvalidateTargetGoal;
import com.github.sculkhorde.common.entity.goal.NearestLivingEntityTargetGoal;
import com.github.sculkhorde.common.entity.goal.SculkPhantomGoToAnchor;
import com.github.sculkhorde.common.entity.goal.SculkPhantomWanderGoal;
import com.github.sculkhorde.common.entity.goal.TargetAttacker;
import com.github.sculkhorde.core.ModEntities;
import com.github.sculkhorde.core.ModMobEffects;
import com.github.sculkhorde.util.BlockAlgorithms;
import com.github.sculkhorde.util.ChunkLoading.EntityChunkLoaderHelper;
import com.github.sculkhorde.util.EntityAlgorithms;
import com.github.sculkhorde.util.SquadHandler;
import com.github.sculkhorde.util.TargetParameters;
import com.github.sculkhorde.util.TickUnits;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SculkPhantomEntity
extends FlyingMob
implements GeoEntity,
ISculkSmartEntity {
    public static final float MAX_HEALTH = 15.0f;
    public static final float ARMOR = 1.0f;
    public static final float ATTACK_DAMAGE = 3.0f;
    public static final float ATTACK_KNOCKBACK = 2.0f;
    public static final float FOLLOW_RANGE = 32.0f;
    public static final float MOVEMENT_SPEED = 0.35f;
    protected final TargetParameters TARGET_PARAMETERS = new TargetParameters((Mob)this).enableTargetPassives().enableTargetHostiles().ignoreTargetBelow50PercentHealth().disableTargetingEntitiesInWater();
    protected BlockPos anchorPoint = BlockPos.f_121853_;
    public static final int TICKS_PER_FLAP = Mth.m_14167_((float)24.166098f);
    Vec3 moveTargetPoint = new Vec3((double)this.anchorPoint.m_123341_(), (double)this.anchorPoint.m_123342_(), (double)this.anchorPoint.m_123343_());
    ArrayList<BlockPos> searchPositions = new ArrayList();
    Vec3 spawnPoint = null;
    protected boolean isScouter = false;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation TUMOR_IDLE_ANIMATION = RawAnimation.begin().thenLoop("tumor");

    public SculkPhantomEntity(EntityType<? extends SculkPhantomEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
    }

    public static void spawnPhantom(Level worldIn, BlockPos spawnPos, boolean isScouter) {
        SculkPhantomEntity phantom = (SculkPhantomEntity)((EntityType)ModEntities.SCULK_PHANTOM.get()).m_20615_(worldIn);
        assert (phantom != null);
        phantom.setScouter(isScouter);
        phantom.m_6034_(spawnPos.m_123341_(), spawnPos.m_123342_(), spawnPos.m_123343_());
        phantom.spawnPoint = new Vec3((double)spawnPos.m_123341_(), (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_());
        worldIn.m_7967_((Entity)phantom);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22284_, 1.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22282_, 2.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22280_, 3.0).m_22268_((Attribute)ForgeMod.ENTITY_GRAVITY.get(), 0.0);
    }

    public void m_8099_() {
        Goal[] goalSelectorPayload = this.goalSelectorPayload();
        for (int priority = 0; priority < goalSelectorPayload.length; ++priority) {
            this.f_21345_.m_25352_(priority, goalSelectorPayload[priority]);
        }
        Goal[] targetSelectorPayload = this.targetSelectorPayload();
        for (int priority = 0; priority < targetSelectorPayload.length; ++priority) {
            this.f_21346_.m_25352_(priority, targetSelectorPayload[priority]);
        }
    }

    public Goal[] goalSelectorPayload() {
        return new Goal[]{new FallToGroundAfterTime(this, TickUnits.convertMinutesToTicks(15)), new FallToTheGroundIfMobsUnder(), new SweepAttackGoal(), new selectRandomLocationToVisit(), new SculkPhantomGoToAnchor(this), new SculkPhantomWanderGoal(this, 1.0, TickUnits.convertSecondsToTicks(3), 10)};
    }

    public Goal[] targetSelectorPayload() {
        return new Goal[]{new InvalidateTargetGoal(this), new TargetAttacker((Mob)this, new Class[0]), new NearestLivingEntityTargetGoal((Mob)this, true, false)};
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        ImprovedFlyingNavigator flyingpathnavigation = new ImprovedFlyingNavigator((Mob)this, level);
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public Vec3 getAnchorPoint() {
        return this.anchorPoint.m_252807_();
    }

    @Override
    public SquadHandler getSquad() {
        return null;
    }

    @Override
    public boolean isParticipatingInRaid() {
        return false;
    }

    @Override
    public void setParticipatingInRaid(boolean isParticipatingInRaidIn) {
    }

    @Override
    public TargetParameters getTargetParameters() {
        return this.TARGET_PARAMETERS;
    }

    public double m_6048_() {
        return this.m_20192_();
    }

    @Override
    public boolean isIdle() {
        return this.m_5448_() == null;
    }

    public boolean isScouter() {
        return this.isScouter;
    }

    public void setScouter(boolean isScouter) {
        this.isScouter = isScouter;
    }

    public boolean m_6000_(double cameraX, double cameraY, double cameraZ) {
        double deltaX = this.m_20185_() - cameraX;
        double deltaY = this.m_20186_() - cameraY;
        double deltaZ = this.m_20189_() - cameraZ;
        double squaredDistance = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        return this.m_6783_(squaredDistance);
    }

    public boolean m_6783_(double squaredDistance) {
        double size = this.m_20191_().m_82309_();
        if (Double.isNaN(size)) {
            size = 1.0;
        }
        return squaredDistance < (size *= 64.0 * SculkPhantomEntity.m_20150_()) * size * size;
    }

    public void m_6043_() {
    }

    public boolean m_21532_() {
        return true;
    }

    public boolean m_213854_() {
        return true;
    }

    public boolean m_142039_() {
        return (this.getUniqueFlapTickOffset() + this.f_19797_) % TICKS_PER_FLAP == 0;
    }

    protected float m_6431_(@NotNull Pose p_33136_, EntityDimensions p_33137_) {
        return p_33137_.f_20378_ * 0.35f;
    }

    public int getUniqueFlapTickOffset() {
        return this.m_19879_() * 3;
    }

    public void m_7023_(@NotNull Vec3 direction) {
        if (this.m_6109_()) {
            this.m_19920_(this.m_5448_() == null ? 0.04f : 0.05f, direction);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            if (this.m_20069_()) {
                this.m_20256_(this.m_20184_().m_82490_((double)0.9f));
            } else if (this.m_20077_()) {
                this.m_20256_(this.m_20184_().m_82490_((double)0.6f));
            } else {
                this.m_20256_(this.m_20184_().m_82490_((double)0.95f));
            }
        }
        this.m_267651_(false);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            float f = Mth.m_14089_((float)((float)(this.getUniqueFlapTickOffset() + this.f_19797_) * 7.448451f * ((float)Math.PI / 180) + (float)Math.PI));
            float f1 = Mth.m_14089_((float)((float)(this.getUniqueFlapTickOffset() + this.f_19797_ + 1) * 7.448451f * ((float)Math.PI / 180) + (float)Math.PI));
            if (f > 0.0f && f1 <= 0.0f) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12230_, this.m_5720_(), 0.95f + this.f_19796_.m_188501_() * 0.05f, 0.95f + this.f_19796_.m_188501_() * 0.05f, false);
            }
            float f2 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 1.51f;
            float f3 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 1.51f;
            float f4 = (0.3f + f * 0.45f) * 1.2f;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123757_, this.m_20185_() + (double)f2, this.m_20186_() + (double)f4, this.m_20189_() + (double)f3, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123757_, this.m_20185_() - (double)f2, this.m_20186_() + (double)f4, this.m_20189_() - (double)f3, 0.0, 0.0, 0.0);
            return;
        }
        if (this.spawnPoint == null) {
            this.spawnPoint = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.isScouter()) {
            EntityChunkLoaderHelper.getEntityChunkLoaderHelper().createChunkLoadRequestSquareForEntityIfAbsent((Entity)this, 2, 3, TickUnits.convertMinutesToTicks(1));
        }
    }

    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor p_33126_, @NotNull DifficultyInstance p_33127_, @NotNull MobSpawnType p_33128_, @Nullable SpawnGroupData p_33129_, @Nullable CompoundTag p_33130_) {
        this.anchorPoint = this.m_20183_().m_6630_(5);
        return super.m_6518_(p_33126_, p_33127_, p_33128_, p_33129_, p_33130_);
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new PhantomBodyRotationControl((Mob)this);
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("AX")) {
            this.anchorPoint = new BlockPos(tag.m_128451_("AX"), tag.m_128451_("AY"), tag.m_128451_("AZ"));
        }
        this.isScouter = tag.m_128471_("scouter");
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("AX", this.anchorPoint.m_123341_());
        tag.m_128405_("AY", this.anchorPoint.m_123342_());
        tag.m_128405_("AZ", this.anchorPoint.m_123343_());
        tag.m_128379_("scouter", this.isScouter);
    }

    protected PlayState poseTumorCycle(AnimationState<SculkPhantomEntity> state2) {
        state2.setAnimation(TUMOR_IDLE_ANIMATION);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkIdleController((GeoAnimatable)this).transitionLength(5)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "blob_idle", 5, this::poseTumorCycle)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return SoundEvents.f_12231_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12229_;
    }

    protected void dieAndSpawnCorpse() {
        this.m_146870_();
        SculkPhantomCorpseEntity corpse = new SculkPhantomCorpseEntity((EntityType<? extends SculkPhantomCorpseEntity>)((EntityType)ModEntities.SCULK_PHANTOM_CORPSE.get()), this.m_9236_());
        corpse.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_9236_().m_7967_((Entity)corpse);
        corpse.m_7292_(new MobEffectInstance(MobEffects.f_19591_, TickUnits.convertSecondsToTicks(20), 1));
    }

    public boolean isAnchorPosValid(BlockPos pos) {
        boolean isThereIsNoFluid = this.m_9236_().m_6425_(pos).m_76178_() && this.m_9236_().m_6425_(pos.m_7495_()).m_76178_();
        boolean isItFarEnoughAway = this.m_20238_(Vec3.m_82512_((Vec3i)pos)) > 30.0;
        return isThereIsNoFluid && isItFarEnoughAway;
    }

    class FallToGroundAfterTime
    extends DespawnAfterTime {
        public FallToGroundAfterTime(ISculkSmartEntity mob, int ticksThreshold) {
            super(mob, ticksThreshold);
        }

        @Override
        public void m_8056_() {
            SculkPhantomEntity.this.dieAndSpawnCorpse();
        }
    }

    protected class FallToTheGroundIfMobsUnder
    extends Goal {
        protected long lastTimeOfCheck = 0L;
        protected long checkCooldown = TickUnits.convertSecondsToTicks(15);
        protected final int mobCheckRadius = 32;

        protected FallToTheGroundIfMobsUnder() {
        }

        public boolean m_8036_() {
            boolean spawnPointIsNull;
            boolean cooldownNotMet = SculkPhantomEntity.this.m_9236_().m_46467_() - this.lastTimeOfCheck < this.checkCooldown;
            boolean isNotScouter = !SculkPhantomEntity.this.isScouter();
            boolean bl = spawnPointIsNull = SculkPhantomEntity.this.spawnPoint == null;
            if (cooldownNotMet || isNotScouter || spawnPointIsNull) {
                return false;
            }
            if (BlockAlgorithms.getBlockDistanceXZ(SculkPhantomEntity.this.m_20183_(), BlockPos.m_274446_((Position)SculkPhantomEntity.this.spawnPoint)) < 100.0f) {
                return false;
            }
            this.lastTimeOfCheck = SculkPhantomEntity.this.m_9236_().m_46467_();
            BlockPos groundBlockPos = BlockAlgorithms.getGroundBlockPos(SculkPhantomEntity.this.m_9236_(), SculkPhantomEntity.this.m_20183_(), SculkPhantomEntity.this.m_9236_().m_151558_());
            List<LivingEntity> nearbyMobs = EntityAlgorithms.getNonSculkEntitiesAtBlockPos((ServerLevel)SculkPhantomEntity.this.m_9236_(), groundBlockPos, 32);
            for (LivingEntity mob : nearbyMobs) {
                boolean isValidTarget = SculkPhantomEntity.this.getTargetParameters().isEntityValidTarget(mob, false);
                if (!isValidTarget) continue;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            SculkPhantomEntity.this.dieAndSpawnCorpse();
        }
    }

    class SweepAttackGoal
    extends MoveTargetGoal {
        private long lastTimeOfAttack = 0L;
        private final int COOLDOWN = TickUnits.convertSecondsToTicks(0);

        SweepAttackGoal() {
        }

        public boolean m_8036_() {
            if (SculkPhantomEntity.this.m_9236_().m_46467_() - this.lastTimeOfAttack < (long)this.COOLDOWN) {
                return false;
            }
            return SculkPhantomEntity.this.m_5448_() != null;
        }

        public boolean m_8045_() {
            LivingEntity target = SculkPhantomEntity.this.m_5448_();
            if (target == null) {
                return false;
            }
            if (!target.m_6084_()) {
                return false;
            }
            return this.m_8036_();
        }

        public void m_8041_() {
            SculkPhantomEntity.this.m_6710_(null);
        }

        public void m_8037_() {
            boolean doesPhantomIntersectTarget;
            boolean isPhantomNull;
            LivingEntity target = SculkPhantomEntity.this.m_5448_();
            boolean bl = isPhantomNull = target == null;
            if (isPhantomNull) {
                return;
            }
            SculkPhantomEntity.this.m_21573_().m_5624_((Entity)target, 2.0);
            float attackReach = SculkPhantomEntity.this.m_20205_() / 2.0f + 2.0f;
            boolean bl2 = doesPhantomIntersectTarget = SculkPhantomEntity.this.m_20270_((Entity)target) <= attackReach;
            if (doesPhantomIntersectTarget) {
                SculkPhantomEntity.this.m_7327_((Entity)target);
                EntityAlgorithms.reducePurityEffectDuration(target, TickUnits.convertMinutesToTicks(5));
                EntityAlgorithms.applyDebuffEffect(target, (MobEffect)ModMobEffects.DISEASED_CYSTS.get(), TickUnits.convertSecondsToTicks(30), 0);
                this.lastTimeOfAttack = SculkPhantomEntity.this.m_9236_().m_46467_();
                return;
            }
            if (SculkPhantomEntity.this.f_19862_ || SculkPhantomEntity.this.f_20916_ > 0) {
                this.lastTimeOfAttack = SculkPhantomEntity.this.m_9236_().m_46467_();
            }
        }
    }

    protected class selectRandomLocationToVisit
    extends Goal {
        protected long lastTimeOfExecution = 0L;
        protected boolean hasExecutedOnce = false;
        protected int circleRadiusVariance = 50;
        protected final int BASE_CIRCLE_RADIUS = 200;
        protected final int CIRCLE_RADIUS_INCREASE = 100;
        protected int currentCircleRadius = 200 + this.circleRadiusVariance;
        protected long gameTimeOfFirstEnteringAreaOfAnchor = 0L;
        protected final long TIME_TO_WAIT_BEFORE_MOVING_ON = TickUnits.convertSecondsToTicks(60);

        protected selectRandomLocationToVisit() {
        }

        public boolean m_8036_() {
            boolean isItTimeToMoveOn;
            boolean isNotScouter = !SculkPhantomEntity.this.isScouter();
            boolean hasTarget = SculkPhantomEntity.this.m_5448_() != null;
            boolean isWithin100BlocksOfAnchor = SculkPhantomEntity.this.m_20238_(Vec3.m_82512_((Vec3i)SculkPhantomEntity.this.anchorPoint)) <= 100.0;
            boolean bl = isItTimeToMoveOn = SculkPhantomEntity.this.m_9236_().m_46467_() - this.gameTimeOfFirstEnteringAreaOfAnchor > this.TIME_TO_WAIT_BEFORE_MOVING_ON && this.gameTimeOfFirstEnteringAreaOfAnchor != 0L;
            if (isNotScouter) {
                return false;
            }
            if (isWithin100BlocksOfAnchor && this.gameTimeOfFirstEnteringAreaOfAnchor == 0L) {
                this.gameTimeOfFirstEnteringAreaOfAnchor = SculkPhantomEntity.this.m_9236_().m_46467_();
            }
            if ((!isItTimeToMoveOn || hasTarget) && this.hasExecutedOnce) {
                return false;
            }
            return SculkPhantomEntity.this.m_9236_().m_45527_(SculkPhantomEntity.this.m_20183_().m_7494_());
        }

        public boolean m_8045_() {
            return false;
        }

        public Vec3 getRandomTravelLocationVec3() {
            block2: {
                Iterator<BlockPos> iterator;
                int MAX_ATTEMPTS = 5;
                if (SculkPhantomEntity.this.searchPositions.isEmpty()) {
                    SculkPhantomEntity.this.searchPositions = BlockAlgorithms.getPointsOnCircumference(SculkPhantomEntity.this.m_20183_(), MAX_ATTEMPTS, this.currentCircleRadius);
                    Collections.shuffle(SculkPhantomEntity.this.searchPositions);
                    this.currentCircleRadius += 100;
                }
                if (!(iterator = SculkPhantomEntity.this.searchPositions.iterator()).hasNext()) break block2;
                BlockPos searchPos = iterator.next();
                BlockPos groundBlockPos = BlockAlgorithms.getGroundBlockPos(SculkPhantomEntity.this.m_9236_(), searchPos, SculkPhantomEntity.this.m_9236_().m_151558_());
                BlockPos potentialNewAnchorPoint = groundBlockPos.m_6630_(20);
                if (SculkPhantomEntity.this.isAnchorPosValid(potentialNewAnchorPoint)) {
                    this.gameTimeOfFirstEnteringAreaOfAnchor = 0L;
                    return potentialNewAnchorPoint.m_252807_();
                }
                SculkPhantomEntity.this.searchPositions.remove(searchPos);
            }
            return SculkPhantomEntity.this.moveTargetPoint;
        }

        public void m_8056_() {
            this.lastTimeOfExecution = SculkPhantomEntity.this.m_9236_().m_46467_();
            SculkPhantomEntity.this.moveTargetPoint = this.getRandomTravelLocationVec3();
            SculkPhantomEntity.this.anchorPoint = BlockPos.m_274446_((Position)SculkPhantomEntity.this.moveTargetPoint);
            this.hasExecutedOnce = true;
        }
    }

    class PhantomBodyRotationControl
    extends BodyRotationControl {
        public PhantomBodyRotationControl(Mob p_33216_) {
            super(p_33216_);
        }

        public void m_8121_() {
            SculkPhantomEntity.this.f_20885_ = SculkPhantomEntity.this.f_20883_;
            SculkPhantomEntity.this.f_20883_ = SculkPhantomEntity.this.m_146908_();
        }
    }

    static abstract class MoveTargetGoal
    extends Goal {
        public MoveTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }
    }
}

