/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity;

import com.github.sculkhorde.common.entity.ISculkSmartEntity;
import com.github.sculkhorde.common.entity.boss.sculk_enderman.SculkEndermanEntity;
import com.github.sculkhorde.common.entity.goal.TargetAttacker;
import com.github.sculkhorde.common.entity.infection.CursorSurfaceInfectorEntity;
import com.github.sculkhorde.core.ModConfig;
import com.github.sculkhorde.core.ModEntities;
import com.github.sculkhorde.core.ModMobEffects;
import com.github.sculkhorde.core.ModParticles;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.EntityAlgorithms;
import com.github.sculkhorde.util.SquadHandler;
import com.github.sculkhorde.util.TargetParameters;
import com.github.sculkhorde.util.TickUnits;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SculkPhantomCorpseEntity
extends Monster
implements GeoEntity,
ISculkSmartEntity {
    public static final float MAX_HEALTH = 40.0f;
    public static final float ARMOR = 10.0f;
    public static final float ATTACK_DAMAGE = 0.0f;
    public static final float ATTACK_KNOCKBACK = 0.0f;
    public static final float FOLLOW_RANGE = 0.0f;
    public static final float MOVEMENT_SPEED = 0.0f;
    private TargetParameters TARGET_PARAMETERS = new TargetParameters((Mob)this).enableTargetPassives().enableTargetHostiles();
    private CursorSurfaceInfectorEntity cursor;
    private long INFECTION_INTERVAL_TICKS = TickUnits.convertSecondsToTicks(2);
    private long lastInfectionTime = 0L;
    public static final EntityDataAccessor<Integer> DATA_TICKS_ALIVE = SynchedEntityData.m_135353_(SculkEndermanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean isParticipatingInRaid = false;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation CORPSE_IDLE_ANIMATION = RawAnimation.begin().thenLoop("corpse");
    private static final RawAnimation SPREAD_ANIMATION = RawAnimation.begin().thenPlay("corpse.spread");
    private final AnimationController<SculkPhantomCorpseEntity> SPREAD_ANIMATION_CONTROLLER = new AnimationController((GeoAnimatable)this, "spread_controller", state2 -> PlayState.STOP).triggerableAnim("spread_animation", SPREAD_ANIMATION).transitionLength(5);
    String DATA_TICKS_ALIVE_IDENTIFIER = "ticks_alive";

    public SculkPhantomCorpseEntity(EntityType<? extends SculkPhantomCorpseEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public SculkPhantomCorpseEntity(Level worldIn) {
        super((EntityType)ModEntities.SCULK_SPORE_SPEWER.get(), worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22277_, 0.0).m_22268_(Attributes.f_22279_, 0.0);
    }

    public void m_6043_() {
    }

    @Override
    public boolean isIdle() {
        return false;
    }

    @Override
    public SquadHandler getSquad() {
        return null;
    }

    @Override
    public boolean isParticipatingInRaid() {
        return this.isParticipatingInRaid;
    }

    @Override
    public void setParticipatingInRaid(boolean isParticipatingInRaidIn) {
        this.isParticipatingInRaid = isParticipatingInRaidIn;
    }

    @Override
    public TargetParameters getTargetParameters() {
        return this.TARGET_PARAMETERS;
    }

    public void m_8099_() {
        Goal[] goalSelectorPayload = this.goalSelectorPayload();
        for (int priority = 0; priority < goalSelectorPayload.length; ++priority) {
            this.f_21345_.m_25352_(priority, goalSelectorPayload[priority]);
        }
        Goal[] targetSelectorPayload = this.targetSelectorPayload();
        for (int priority = 0; priority < targetSelectorPayload.length; ++priority) {
            this.f_21346_.m_25352_(priority, targetSelectorPayload[priority]);
        }
    }

    public Goal[] goalSelectorPayload() {
        Goal[] goals = new Goal[]{new DestroyLeavesTouchingHitBoxGoal(this), new dieAfterTimeGoal(this)};
        return goals;
    }

    public Goal[] targetSelectorPayload() {
        Goal[] goals = new Goal[]{new TargetAttacker((Mob)this, new Class[0]).setAlertAllies(new Class[0])};
        return goals;
    }

    public void m_8107_() {
        boolean canSpawnCursor;
        super.m_8107_();
        if (this.m_9236_().f_46443_) {
            Random random = new Random();
            Vec3 randomPos = new Vec3(this.m_20182_().f_82479_ + (double)random.nextFloat(0.5f), this.m_20182_().f_82480_ + (double)random.nextFloat(0.5f), this.m_20182_().f_82481_ + (double)random.nextFloat(0.5f));
            for (int i = 0; i < 1; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ModParticles.SCULK_CRUST_PARTICLE.get(), randomPos.f_82479_, randomPos.f_82480_, randomPos.f_82481_, (random.nextDouble() - 0.5) * 3.0, (random.nextDouble() - 0.5) * 3.0, (random.nextDouble() - 0.5) * 3.0);
            }
            return;
        }
        Random random = new Random();
        boolean passRandomChance = random.nextInt(100) == 0;
        boolean isCursorNullOrDead = this.cursor == null || !this.cursor.m_6084_();
        boolean isBlockInfestationEnabled = (Boolean)ModConfig.SERVER.block_infestation_enabled.get();
        boolean isTheHordeNotDefeated = !SculkHorde.savedData.isHordeDefeated();
        boolean bl = canSpawnCursor = passRandomChance && isCursorNullOrDead && isBlockInfestationEnabled && isTheHordeNotDefeated;
        if (canSpawnCursor) {
            this.cursor = new CursorSurfaceInfectorEntity(this.m_9236_());
            this.cursor.m_6034_(this.m_20183_().m_123341_(), this.m_20183_().m_123342_() - 1, this.m_20183_().m_123343_());
            this.cursor.setMaxTransformations(100);
            this.cursor.setMaxRange(100);
            this.cursor.setTickIntervalMilliseconds(50L);
            this.cursor.setSearchIterationsPerTick(1);
            this.m_9236_().m_7967_((Entity)this.cursor);
            this.triggerAnim("spread_controller", "spread_animation");
        }
        if (this.m_9236_().m_46467_() - this.lastInfectionTime > this.INFECTION_INTERVAL_TICKS) {
            this.lastInfectionTime = this.m_9236_().m_46467_();
            ArrayList entities = (ArrayList)EntityAlgorithms.getNonSculkEntitiesAtBlockPos((ServerLevel)this.m_9236_(), this.m_20183_(), 10);
            for (LivingEntity victim : entities) {
                if (!this.getTargetParameters().isEntityValidTarget(victim, false)) {
                    return;
                }
                EntityAlgorithms.reducePurityEffectDuration(victim, TickUnits.convertMinutesToTicks(1));
                EntityAlgorithms.applyDebuffEffect(victim, (MobEffect)ModMobEffects.SCULK_INFECTION.get(), TickUnits.convertSecondsToTicks(15), 0);
                EntityAlgorithms.applyDebuffEffect(victim, (MobEffect)ModMobEffects.SCULK_LURE.get(), TickUnits.convertMinutesToTicks(10), 0);
            }
        }
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12231_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12229_;
    }

    protected PlayState pose(AnimationState<SculkPhantomCorpseEntity> state2) {
        state2.setAnimation(CORPSE_IDLE_ANIMATION);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "body", 5, this::pose)});
        controllers.add(new AnimationController[]{this.SPREAD_ANIMATION_CONTROLLER});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_213854_() {
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TICKS_ALIVE, (Object)0);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_(this.DATA_TICKS_ALIVE_IDENTIFIER, ((Integer)this.f_19804_.m_135370_(DATA_TICKS_ALIVE)).intValue());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.f_19804_.m_135381_(DATA_TICKS_ALIVE, (Object)nbt.m_128451_(this.DATA_TICKS_ALIVE_IDENTIFIER));
    }

    private class DestroyLeavesTouchingHitBoxGoal
    extends Goal {
        private final SculkPhantomCorpseEntity entity;
        private final long EXECUTION_COOLDOWN = TickUnits.convertSecondsToTicks(5);
        private long lastExecutionTime = 0L;
        TagKey<Block> isLeaves = BlockTags.f_13035_;

        public DestroyLeavesTouchingHitBoxGoal(SculkPhantomCorpseEntity entity) {
            this.entity = entity;
        }

        public boolean m_8036_() {
            return this.entity.m_9236_().m_46467_() - this.lastExecutionTime > this.EXECUTION_COOLDOWN;
        }

        public void m_8056_() {
            AABB hitBox = this.entity.m_20191_().m_82400_(1.0);
            int x = (int)hitBox.f_82288_;
            while ((double)x < hitBox.f_82291_) {
                int y = (int)hitBox.f_82289_;
                while ((double)y < hitBox.f_82292_) {
                    int z = (int)hitBox.f_82290_;
                    while ((double)z < hitBox.f_82293_) {
                        BlockPos pos = new BlockPos(x, y, z);
                        BlockState blockAtPosition = this.entity.m_9236_().m_8055_(pos);
                        if (blockAtPosition.m_204336_(this.isLeaves)) {
                            this.entity.m_9236_().m_46961_(pos, false);
                            this.lastExecutionTime = this.entity.m_9236_().m_46467_();
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }

        public boolean m_8045_() {
            return false;
        }
    }

    private class dieAfterTimeGoal
    extends Goal {
        private final SculkPhantomCorpseEntity entity;

        public dieAfterTimeGoal(SculkPhantomCorpseEntity entity) {
            this.entity = entity;
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8056_() {
        }

        public void m_8037_() {
            if (SculkPhantomCorpseEntity.this.m_9236_().m_5776_()) {
                return;
            }
            SculkPhantomCorpseEntity.this.f_19804_.m_135381_(DATA_TICKS_ALIVE, (Object)((Integer)SculkPhantomCorpseEntity.this.f_19804_.m_135370_(DATA_TICKS_ALIVE) + 1));
            int ticksAlive = (Integer)SculkPhantomCorpseEntity.this.f_19804_.m_135370_(DATA_TICKS_ALIVE);
            if (ticksAlive > TickUnits.convertMinutesToTicks(15)) {
                this.entity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }
}

