/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity;

import com.github.sculkhorde.common.entity.ISculkSmartEntity;
import com.github.sculkhorde.common.entity.goal.DespawnAfterTime;
import com.github.sculkhorde.common.entity.goal.DespawnWhenIdle;
import com.github.sculkhorde.common.entity.goal.FocusSquadTarget;
import com.github.sculkhorde.common.entity.goal.FollowSquadLeader;
import com.github.sculkhorde.common.entity.goal.ImprovedRandomStrollGoal;
import com.github.sculkhorde.common.entity.goal.InvalidateTargetGoal;
import com.github.sculkhorde.common.entity.goal.NearestLivingEntityTargetGoal;
import com.github.sculkhorde.common.entity.goal.SculkMiteInfectGoal;
import com.github.sculkhorde.common.entity.goal.SquadHandlingGoal;
import com.github.sculkhorde.common.entity.goal.TargetAttacker;
import com.github.sculkhorde.core.ModConfig;
import com.github.sculkhorde.core.ModMobEffects;
import com.github.sculkhorde.util.SquadHandler;
import com.github.sculkhorde.util.TargetParameters;
import com.github.sculkhorde.util.TickUnits;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SculkMiteEntity
extends Monster
implements GeoEntity,
ISculkSmartEntity {
    public static final float MAX_HEALTH = 5.0f;
    public static final float ARMOR = 1.0f;
    public static final float ATTACK_DAMAGE = 1.0f;
    public static final float ATTACK_KNOCKBACK = 1.0f;
    public static final float FOLLOW_RANGE = 30.0f;
    public static final float MOVEMENT_SPEED = 0.3f;
    private TargetParameters TARGET_PARAMETERS = new TargetParameters((Mob)this).enableTargetPassives().enableTargetHostiles().enableMustReachTarget();
    private SquadHandler squad = new SquadHandler(this);
    public static int INFECT_RANGE = 2;
    public static MobEffect INFECT_EFFECT = (MobEffect)ModMobEffects.SCULK_INFECTION.get();
    public static int INFECT_DURATION = 500;
    public static int INFECT_LEVEL = 1;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean isParticipatingInRaid = false;

    public SculkMiteEntity(EntityType<? extends SculkMiteEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22284_, 1.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22279_, (double)0.3f);
    }

    public void m_6043_() {
    }

    @Override
    public boolean isIdle() {
        return this.m_5448_() == null;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12419_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12421_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12420_;
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(SoundEvents.f_12422_, 0.15f, 1.0f);
    }

    public boolean m_21532_() {
        return true;
    }

    public static boolean additionalSpawnCheck(EntityType<? extends PathfinderMob> config, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        if (world.m_46791_() == Difficulty.PEACEFUL) {
            return false;
        }
        if (world.m_45517_(LightLayer.BLOCK, pos) > 8) {
            return false;
        }
        if (world.m_45517_(LightLayer.SKY, pos) > 8) {
            return false;
        }
        if (pos.m_123342_() > 50) {
            return false;
        }
        return !world.m_204166_(pos).m_203565_(Biomes.f_220594_) || (Boolean)ModConfig.SERVER.should_sculk_mites_spawn_in_deep_dark.get() != false;
    }

    public void m_8099_() {
        Goal[] goalSelectorPayload = this.goalSelectorPayload();
        for (int priority = 0; priority < goalSelectorPayload.length; ++priority) {
            this.f_21345_.m_25352_(priority, goalSelectorPayload[priority]);
        }
        Goal[] targetSelectorPayload = this.targetSelectorPayload();
        for (int priority = 0; priority < targetSelectorPayload.length; ++priority) {
            this.f_21346_.m_25352_(priority, targetSelectorPayload[priority]);
        }
    }

    public Goal[] goalSelectorPayload() {
        Goal[] goals = new Goal[]{new DespawnAfterTime(this, TickUnits.convertMinutesToTicks(15)), new DespawnWhenIdle(this, TimeUnit.MINUTES.toSeconds(1L)), new FloatGoal((Mob)this), new SquadHandlingGoal(this), new SculkMiteInfectGoal(this, 1.0, true), new FollowSquadLeader(this), new MoveTowardsTargetGoal((PathfinderMob)this, (double)0.8f, 20.0f), new ImprovedRandomStrollGoal((PathfinderMob)this, 1.0).setToAvoidWater(true), new LookAtPlayerGoal((Mob)this, Pig.class, 8.0f), new RandomLookAroundGoal((Mob)this)};
        return goals;
    }

    public Goal[] targetSelectorPayload() {
        Goal[] goals = new Goal[]{new InvalidateTargetGoal(this), new TargetAttacker((Mob)this, new Class[0]), new FocusSquadTarget((Mob)this), new NearestLivingEntityTargetGoal((Mob)this, true, true)};
        return goals;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public SquadHandler getSquad() {
        return this.squad;
    }

    @Override
    public boolean isParticipatingInRaid() {
        return false;
    }

    @Override
    public void setParticipatingInRaid(boolean isParticipatingInRaidIn) {
        this.isParticipatingInRaid = isParticipatingInRaidIn;
    }

    @Override
    public TargetParameters getTargetParameters() {
        return this.TARGET_PARAMETERS;
    }

    public boolean m_213854_() {
        return true;
    }
}

