/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity;

import com.github.sculkhorde.common.entity.ISculkSmartEntity;
import com.github.sculkhorde.common.entity.goal.BlowUpPriorityBlockGoal;
import com.github.sculkhorde.common.entity.goal.DespawnAfterTime;
import com.github.sculkhorde.common.entity.goal.DespawnWhenIdle;
import com.github.sculkhorde.common.entity.goal.ImprovedRandomStrollGoal;
import com.github.sculkhorde.common.entity.goal.NearestLivingEntityTargetGoal;
import com.github.sculkhorde.common.entity.goal.PathFindToRaidLocation;
import com.github.sculkhorde.common.entity.goal.TargetAttacker;
import com.github.sculkhorde.common.entity.infection.CursorSurfaceInfectorEntity;
import com.github.sculkhorde.core.ModConfig;
import com.github.sculkhorde.core.ModEntities;
import com.github.sculkhorde.core.ModMobEffects;
import com.github.sculkhorde.util.EntityAlgorithms;
import com.github.sculkhorde.util.SquadHandler;
import com.github.sculkhorde.util.TargetParameters;
import com.github.sculkhorde.util.TickUnits;
import java.util.concurrent.TimeUnit;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.SwellGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SculkCreeperEntity
extends Creeper
implements ISculkSmartEntity,
GeoEntity {
    private boolean isParticipatingInRaid = false;
    private TargetParameters TARGET_PARAMETERS = new TargetParameters((Mob)this).enableTargetHostiles().enableMustReachTarget();
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation CREEPER_IDLE_ANIMATION = RawAnimation.begin().thenLoop("sculk_creeper.idle");
    private static final RawAnimation BLOB_IDLE_ANIMATION = RawAnimation.begin().thenLoop("sculk_blob.idle");
    private static final RawAnimation CREEPER_WALK_ANIMATION = RawAnimation.begin().thenLoop("sculk_creeper.walk");
    private static final RawAnimation CREEPER_SWELL_ANIMATION = RawAnimation.begin().thenPlay("sculk_creeper.attack");
    private static final RawAnimation CREEPER_DESWELL_ANIMATION = RawAnimation.begin().thenPlay("sculk_creeper.attack.cancel");

    public SculkCreeperEntity(EntityType<? extends Creeper> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new DespawnAfterTime(this, TickUnits.convertMinutesToTicks(15)));
        this.f_21345_.m_25352_(0, (Goal)new DespawnWhenIdle(this, TimeUnit.MINUTES.toSeconds(5L)));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SwellGoal((Creeper)this));
        this.f_21345_.m_25352_(2, (Goal)new BlowUpPriorityBlockGoal(this, 1.0, 3, 4, 5));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(4, new PathFindToRaidLocation<SculkCreeperEntity>(this));
        this.f_21345_.m_25352_(5, (Goal)new ImprovedRandomStrollGoal((PathfinderMob)this, 1.0).setToAvoidWater(true));
        this.f_21346_.m_25352_(1, new NearestLivingEntityTargetGoal((Mob)this, true, true));
        this.f_21346_.m_25352_(2, (Goal)new TargetAttacker((Mob)this, new Class[0]).setAlertAllies(new Class[0]));
    }

    public void m_6043_() {
    }

    @Override
    public SquadHandler getSquad() {
        return null;
    }

    @Override
    public boolean isParticipatingInRaid() {
        return this.isParticipatingInRaid;
    }

    @Override
    public void setParticipatingInRaid(boolean isParticipatingInRaidIn) {
        this.isParticipatingInRaid = isParticipatingInRaidIn;
    }

    @Override
    public TargetParameters getTargetParameters() {
        return this.TARGET_PARAMETERS;
    }

    @Override
    public boolean isIdle() {
        return this.m_5448_() == null;
    }

    public void spawnInfectors() {
        int numToSpawn = 15;
        int spawnRange = 5;
        for (int i = 0; i < numToSpawn; ++i) {
            double x = this.m_20185_() + this.m_217043_().m_188500_() * (double)spawnRange - (double)(spawnRange / 2);
            double z = this.m_20189_() + this.m_217043_().m_188500_() * (double)spawnRange - (double)(spawnRange / 2);
            double y = this.m_20186_() + this.m_217043_().m_188500_() * (double)spawnRange / 2.0 - (double)(spawnRange / 4);
            CursorSurfaceInfectorEntity infector = new CursorSurfaceInfectorEntity((EntityType)ModEntities.CURSOR_SURFACE_INFECTOR.get(), this.m_9236_());
            infector.m_6034_(x, y, z);
            infector.setTickIntervalMilliseconds(3L);
            infector.setMaxTransformations(10);
            infector.setMaxRange(10);
            this.m_9236_().m_7967_((Entity)infector);
        }
    }

    public void infectEntitiesAroundMe() {
        AABB aabb = this.m_20191_().m_82400_(5.0);
        this.m_9236_().m_45976_(LivingEntity.class, aabb).forEach(victim -> {
            if (!this.getTargetParameters().isEntityValidTarget((LivingEntity)victim, false)) {
                return;
            }
            EntityAlgorithms.reducePurityEffectDuration(victim, TickUnits.convertMinutesToTicks(5));
            EntityAlgorithms.applyDebuffEffect(victim, (MobEffect)ModMobEffects.DISEASED_CYSTS.get(), TickUnits.convertSecondsToTicks(60), 0);
        });
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if ((double)this.m_32320_(1.0f) >= 1.0) {
            this.infectEntitiesAroundMe();
            this.explodeSculkCreeper();
        }
    }

    public void explodeSculkCreeper() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (!this.isParticipatingInRaid()) {
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0f, Level.ExplosionInteraction.NONE);
            if (((Boolean)ModConfig.SERVER.block_infestation_enabled.get()).booleanValue()) {
                this.spawnInfectors();
            }
        } else {
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0f, Level.ExplosionInteraction.MOB);
        }
        this.f_20890_ = true;
        this.m_146870_();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "walk_cycle", 5, this::poseWalkCycle), new AnimationController((GeoAnimatable)this, "attack_cycle", 5, this::poseAttackCycle), new AnimationController((GeoAnimatable)this, "blob_idle", 5, this::poseBlobIdleCycle)});
    }

    protected PlayState poseBlobIdleCycle(AnimationState<SculkCreeperEntity> state2) {
        state2.setAnimation(BLOB_IDLE_ANIMATION);
        return PlayState.CONTINUE;
    }

    protected PlayState poseWalkCycle(AnimationState<SculkCreeperEntity> state2) {
        if (!state2.isMoving()) {
            state2.setAnimation(CREEPER_IDLE_ANIMATION);
        } else {
            state2.setAnimation(CREEPER_WALK_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    protected PlayState poseAttackCycle(AnimationState<SculkCreeperEntity> state2) {
        float swellValue = this.m_32320_(1.0f);
        if (this.m_32310_() > 0 && swellValue < 28.0f) {
            state2.setAnimation(CREEPER_SWELL_ANIMATION);
            return PlayState.CONTINUE;
        }
        state2.setAnimation(CREEPER_DESWELL_ANIMATION);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

