/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.command;

import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.core.gravemind.entity_factory.ReinforcementRequest;
import com.github.sculkhorde.util.BlockAlgorithms;
import com.github.sculkhorde.util.TargetParameters;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

public class SummonReinforcementsCommand
implements Command<CommandSourceStack> {
    private final TargetParameters hostileTargetParameters = new TargetParameters().enableTargetHostiles().enableTargetInfected();
    private final TargetParameters infectableTargetParameters = new TargetParameters().enableTargetPassives();

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        return Commands.m_82127_((String)"summon_reinforcements").executes((Command)new SummonReinforcementsCommand());
    }

    public int run(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Reinforcement Request Received."), false);
        Vec3 reinforcementPosition = ((CommandSourceStack)context.getSource()).m_81371_();
        this.summonReinforcement(((CommandSourceStack)context.getSource()).m_81372_(), BlockPos.m_274446_((Position)reinforcementPosition));
        return 0;
    }

    private void summonReinforcement(ServerLevel level, BlockPos blockPos) {
        level.m_8767_((ParticleOptions)ParticleTypes.f_235898_, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 1.15, (double)blockPos.m_123343_() + 0.5, 2, 0.2, 0.0, 0.2, 0.0);
        level.m_5594_((Player)null, blockPos, SoundEvents.f_215740_, SoundSource.BLOCKS, 2.0f, 1.6f);
        ArrayList<BlockPos> possibleSpawnPositions = this.getSpawnPositionsInCube(level, blockPos, 5, 10);
        BlockPos[] finalizedSpawnPositions = new BlockPos[10];
        for (int iterations = 0; iterations < possibleSpawnPositions.size(); ++iterations) {
            finalizedSpawnPositions[iterations] = possibleSpawnPositions.get(iterations);
        }
        if (possibleSpawnPositions.isEmpty()) {
            finalizedSpawnPositions[0] = blockPos.m_7494_();
        }
        ReinforcementRequest request = new ReinforcementRequest(level, finalizedSpawnPositions);
        request.sender = ReinforcementRequest.senderType.Summoner;
        request.is_aggressor_nearby = true;
        SculkHorde.entityFactory.createReinforcementRequestFromSummoner((Level)level, blockPos, false, request);
    }

    public boolean isValidSpawnPosition(ServerLevel worldIn, BlockPos pos) {
        boolean isBlockBelowSolid = BlockAlgorithms.isSolid(worldIn, pos.m_7495_());
        boolean isBaseBlockReplaceable = worldIn.m_8055_(pos).m_60722_((Fluid)Fluids.f_76193_);
        boolean isBlockAboveReplaceable = worldIn.m_8055_(pos.m_7494_()).m_60722_((Fluid)Fluids.f_76193_);
        return isBlockBelowSolid && isBaseBlockReplaceable && isBlockAboveReplaceable;
    }

    public ArrayList<BlockPos> getSpawnPositionsInCube(ServerLevel worldIn, BlockPos origin, int length, int amountOfPositions) {
        ArrayList<BlockPos> listOfPossibleSpawns = this.getSpawnPositions(worldIn, origin, length);
        ArrayList<BlockPos> finalList = new ArrayList<BlockPos>();
        Random rng = new Random();
        for (int count = 0; count < amountOfPositions && listOfPossibleSpawns.size() > 0; ++count) {
            int randomIndex = rng.nextInt(listOfPossibleSpawns.size());
            finalList.add(listOfPossibleSpawns.get(randomIndex));
            listOfPossibleSpawns.remove(randomIndex);
        }
        return finalList;
    }

    public ArrayList<BlockPos> getSpawnPositions(ServerLevel worldIn, BlockPos origin, double pDistance) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        int i = 0;
        while ((double)i <= pDistance) {
            int j = 0;
            while ((double)j < pDistance) {
                int k = 0;
                while (k <= j) {
                    int l;
                    int n = l = k < j && k > -j ? j : 0;
                    while (l <= j) {
                        BlockPos temp = new BlockPos(origin.m_123341_() + k, origin.m_123342_() + i - 1, origin.m_123343_() + l);
                        if (origin.m_123314_((Vec3i)temp, pDistance) && this.isValidSpawnPosition(worldIn, temp)) {
                            list.add(temp);
                        }
                        l = l > 0 ? -l : 1 - l;
                    }
                    k = k > 0 ? -k : 1 - k;
                }
                ++j;
            }
            i = i > 0 ? -i : 1 - i;
        }
        return list;
    }
}

