/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.blockentity;

import com.github.sculkhorde.common.advancement.SoulHarvesterTrigger;
import com.github.sculkhorde.common.block.SoulHarvesterBlock;
import com.github.sculkhorde.common.recipe.SoulHarvestingRecipe;
import com.github.sculkhorde.common.screen.SoulHarvesterMenu;
import com.github.sculkhorde.core.ModBlockEntities;
import com.github.sculkhorde.util.AdvancementUtil;
import com.github.sculkhorde.util.EntityAlgorithms;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SoulHarvesterBlockEntity
extends BlockEntity
implements MenuProvider,
GeoBlockEntity,
GameEventListener.Holder<SoulHarvesterListener> {
    private final SoulHarvesterListener soulHarvesterListener;
    private AABB searchArea;
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private final ItemStackHandler itemHandler = new ItemStackHandler(2);
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data;
    private int progress = 0;
    private int maxProgress = 300;
    private int healthHarvested = 0;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenPlayAndHold("idle");
    private static final RawAnimation READYUP_ANIMATION = RawAnimation.begin().thenPlayAndHold("item_inside");
    private static final RawAnimation ACTIVE_ANIMATION = RawAnimation.begin().thenLoop("active");

    public SoulHarvesterBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.SOUL_HARVESTER_BLOCK_ENTITY.get(), blockPos, blockState);
        this.soulHarvesterListener = new SoulHarvesterListener(blockState, (PositionSource)new BlockPositionSource(blockPos));
        this.searchArea = EntityAlgorithms.getSearchAreaRectangle(this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_(), 10.0, 5.0, 10.0);
        this.data = new ContainerData(){

            public int m_6413_(int pIndex) {
                return switch (pIndex) {
                    case 0 -> SoulHarvesterBlockEntity.this.progress;
                    case 1 -> SoulHarvesterBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void m_8050_(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        SoulHarvesterBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        SoulHarvesterBlockEntity.this.maxProgress = pValue;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    public boolean isPrepared() {
        return (Boolean)this.m_58900_().m_61143_((Property)SoulHarvesterBlock.IS_PREPARED);
    }

    public void setPrepared(boolean active) {
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)SoulHarvesterBlock.IS_PREPARED, (Comparable)Boolean.valueOf(active)), 3);
    }

    public boolean isActive() {
        return (Boolean)this.m_58900_().m_61143_((Property)SoulHarvesterBlock.IS_ACTIVE);
    }

    public void setActive(boolean active) {
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)SoulHarvesterBlock.IS_ACTIVE, (Comparable)Boolean.valueOf(active)), 3);
    }

    public int getHealthHarvested() {
        return this.healthHarvested;
    }

    public void setHealthHarvested(int amount) {
        int newTotal;
        this.healthHarvested = newTotal = Math.min(amount, 1000);
    }

    public void increaseHealthHarvested(int amount) {
        int newTotal = Math.min(this.getHealthHarvested() + amount, 1000);
        this.setHealthHarvested(newTotal);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.sculkhorde.soul_harvester");
    }

    private boolean canStartCrafting() {
        boolean isExperienceMaxed = this.getHealthHarvested() >= 1000;
        Optional<SoulHarvestingRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack result = recipe.get().m_8043_(null);
        return recipe.isPresent() && this.canInsertAmountIntoOutputSlot(result.m_41613_()) && this.canInsertItemIntoOutputSlot(result.m_41720_()) && isExperienceMaxed;
    }

    private Optional<SoulHarvestingRecipe> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)SoulHarvestingRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
    }

    private boolean canInsertItemIntoOutputSlot(Item item) {
        return this.itemHandler.getStackInSlot(1).m_41619_() || this.itemHandler.getStackInSlot(1).m_150930_(item);
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        return this.itemHandler.getStackInSlot(1).m_41613_() + count <= this.itemHandler.getStackInSlot(1).m_41741_();
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new SoulHarvesterMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public boolean isAnyItemInInputSlot() {
        return !this.itemHandler.getStackInSlot(0).m_41619_();
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, SoulHarvesterBlockEntity pBlockEntity) {
        if (pBlockEntity.isAnyItemInInputSlot()) {
            pBlockEntity.setPrepared(true);
        } else {
            pBlockEntity.setPrepared(false);
        }
        if (pBlockEntity.canStartCrafting()) {
            pBlockEntity.setActive(true);
            pBlockEntity.increaseCraftingProgress();
            SoulHarvesterBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            if (pBlockEntity.hasProgressFinished()) {
                pBlockEntity.craftItem();
                pBlockEntity.resetProgress();
            }
        } else {
            pBlockEntity.setActive(false);
            pBlockEntity.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        Optional<SoulHarvestingRecipe> recipe = this.getCurrentRecipe();
        ItemStack result = recipe.get().m_8043_(null);
        this.itemHandler.extractItem(0, 1, false);
        this.itemHandler.setStackInSlot(1, new ItemStack((ItemLike)result.m_41720_(), this.itemHandler.getStackInSlot(1).m_41613_() + result.m_41613_()));
        this.setHealthHarvested(0);
    }

    public SoulHarvesterListener getListener() {
        return this.soulHarvesterListener;
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("soul_harvester.progress", this.progress);
        pTag.m_128405_("soul_harvester.progress", this.progress);
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.progress = pTag.m_128451_("soul_harvester.progress");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, state2 -> {
            BlockState blockState = ((SoulHarvesterBlockEntity)state2.getAnimatable()).m_58904_().m_8055_(((SoulHarvesterBlockEntity)state2.getAnimatable()).f_58858_);
            if (this.f_58857_.m_7702_(this.f_58858_) == null || this.f_58857_.m_7702_(this.f_58858_).m_58903_() != ModBlockEntities.SOUL_HARVESTER_BLOCK_ENTITY.get()) {
                return null;
            }
            if (((Boolean)blockState.m_61143_((Property)SoulHarvesterBlock.IS_ACTIVE)).booleanValue()) {
                return state2.setAndContinue(ACTIVE_ANIMATION);
            }
            if (((Boolean)blockState.m_61143_((Property)SoulHarvesterBlock.IS_PREPARED)).booleanValue()) {
                return state2.setAndContinue(READYUP_ANIMATION);
            }
            return state2.setAndContinue(IDLE_ANIMATION);
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static class SoulHarvesterListener
    implements GameEventListener {
        private final BlockState blockState;
        private final PositionSource positionSource;

        public SoulHarvesterListener(BlockState blockStateIn, PositionSource positionSourceIn) {
            this.blockState = blockStateIn;
            this.positionSource = positionSourceIn;
        }

        public PositionSource m_142460_() {
            return this.positionSource;
        }

        public int m_142078_() {
            return 8;
        }

        public GameEventListener.DeliveryMode m_247514_() {
            return GameEventListener.DeliveryMode.BY_DISTANCE;
        }

        public boolean m_214068_(ServerLevel ServerLevelIn, GameEvent gameEventIn, GameEvent.Context contextIn, Vec3 sourcePosition) {
            if (gameEventIn != GameEvent.f_223707_) {
                return false;
            }
            Entity killedEntitiy = contextIn.f_223711_();
            if (!(killedEntitiy instanceof LivingEntity)) {
                return false;
            }
            if (EntityAlgorithms.isSculkLivingEntity.test((LivingEntity)killedEntitiy)) {
                return false;
            }
            LivingEntity livingentity = (LivingEntity)killedEntitiy;
            int healthHarvested = (int)livingentity.m_21233_();
            SoulHarvesterBlockEntity blockEntity = (SoulHarvesterBlockEntity)ServerLevelIn.m_7702_(BlockPos.m_274446_((Position)((Position)this.positionSource.m_142502_((Level)ServerLevelIn).get())));
            blockEntity.increaseHealthHarvested(healthHarvested);
            livingentity.m_217045_();
            this.positionSource.m_142502_((Level)ServerLevelIn).ifPresent(positionVec3 -> this.spawnCoolParticles(ServerLevelIn, BlockPos.m_274446_((Position)positionVec3), this.blockState, ServerLevelIn.m_213780_()));
            this.tryAwardAdvancement((Level)ServerLevelIn, livingentity);
            return true;
        }

        private void spawnCoolParticles(ServerLevel p_281501_, BlockPos p_281448_, BlockState p_281966_, RandomSource p_283606_) {
            p_281501_.m_8767_((ParticleOptions)ParticleTypes.f_235898_, (double)p_281448_.m_123341_() + 0.5, (double)p_281448_.m_123342_() + 1.15, (double)p_281448_.m_123343_() + 0.5, 2, 0.2, 0.0, 0.2, 0.0);
            p_281501_.m_5594_((Player)null, p_281448_, SoundEvents.f_215740_, SoundSource.BLOCKS, 2.0f, 0.6f + p_283606_.m_188501_() * 0.4f);
        }

        private void tryAwardAdvancement(Level levelIn, LivingEntity livingEntityIn) {
            LivingEntity livingentity = livingEntityIn.m_21188_();
            if (livingentity instanceof ServerPlayer) {
                ServerPlayer serverplayer = (ServerPlayer)livingentity;
                AdvancementUtil.giveAdvancementToPlayer(serverplayer, SoulHarvesterTrigger.INSTANCE);
            }
        }
    }
}

