/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.blockentity;

import com.github.sculkhorde.common.block.SculkSummonerBlock;
import com.github.sculkhorde.core.ModBlockEntities;
import com.github.sculkhorde.core.ModBlocks;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.core.gravemind.entity_factory.ReinforcementRequest;
import com.github.sculkhorde.util.BlockInfestationHelper;
import com.github.sculkhorde.util.EntityAlgorithms;
import com.github.sculkhorde.util.TargetParameters;
import com.github.sculkhorde.util.TickUnits;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import org.slf4j.Logger;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SculkSummonerBlockEntity
extends BlockEntity
implements GameEventListener.Holder<VibrationSystem.Listener>,
VibrationSystem,
GeoBlockEntity {
    AABB searchArea;
    private final int ACTIVATION_DISTANCE = 32;
    private List<LivingEntity> possibleLivingEntityTargets;
    private List<LivingEntity> possibleAggressorTargets;
    private long lastGameTimeOfVibrationRecieve = 0L;
    private final int MAX_SPAWNED_ENTITIES = 4;
    ReinforcementRequest request;
    private final TargetParameters hostileTargetParameters = new TargetParameters().enableTargetHostiles().enableTargetInfected();
    private final TargetParameters infectableTargetParameters = new TargetParameters().enableTargetPassives();
    private final VibrationSystem.User vibrationUser = new VibrationUser(this);
    private VibrationSystem.Data vibrationData = new VibrationSystem.Data();
    private final VibrationSystem.Listener vibrationListener = new VibrationSystem.Listener((VibrationSystem)this);
    private final Predicate<BlockPos> VALID_SPAWN_BLOCKS = blockPos -> this.isValidSpawnPosition((ServerLevel)this.f_58857_, (BlockPos)blockPos);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation SCULK_SUMMONER_COOLDOWN_ANIMATION = RawAnimation.begin().thenPlayAndHold("cooldown");
    private static final RawAnimation SCULK_SUMMONER_READY_ANIMATION = RawAnimation.begin().thenPlay("powerup").thenLoop("idle");

    public SculkSummonerBlockEntity(BlockPos blockPos2, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.SCULK_SUMMONER_BLOCK_ENTITY.get(), blockPos2, blockState);
        this.searchArea = EntityAlgorithms.getSearchAreaRectangle(this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_(), 32.0, 5.0, 32.0);
        this.possibleLivingEntityTargets = new ArrayList<LivingEntity>();
        this.possibleAggressorTargets = new ArrayList<LivingEntity>();
    }

    private boolean isVibrationCooldownOver() {
        return this.f_58857_.m_46467_() - this.lastGameTimeOfVibrationRecieve > (long)TickUnits.convertSecondsToTicks(15);
    }

    private boolean isBlockStateVibrationCooldownTrue() {
        return (Boolean)this.m_58900_().m_61143_((Property)SculkSummonerBlock.VIBRATION_COOLDOWN);
    }

    private void setVibrationCooldown(boolean value) {
        assert (this.f_58857_ != null);
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)SculkSummonerBlock.VIBRATION_COOLDOWN, (Comparable)Boolean.valueOf(value)));
    }

    private boolean areAllReinforcementsDead() {
        if (this.request == null) {
            return true;
        }
        for (LivingEntity entity : this.request.spawnedEntities) {
            if (entity == null || !entity.m_6084_()) continue;
            return false;
        }
        return true;
    }

    private boolean areAnyTargetsNearBy(BlockPos blockPos, SculkSummonerBlockEntity blockEntity) {
        blockEntity.searchArea = EntityAlgorithms.createBoundingBoxRectableAtBlockPos(blockPos.m_252807_(), blockEntity.ACTIVATION_DISTANCE, 10, blockEntity.ACTIVATION_DISTANCE);
        blockEntity.possibleAggressorTargets = blockEntity.f_58857_.m_6443_(LivingEntity.class, blockEntity.searchArea, blockEntity.hostileTargetParameters.isPossibleNewTargetValid);
        blockEntity.possibleLivingEntityTargets = blockEntity.f_58857_.m_6443_(LivingEntity.class, blockEntity.searchArea, blockEntity.infectableTargetParameters.isPossibleNewTargetValid);
        return blockEntity.possibleAggressorTargets.size() != 0 || blockEntity.possibleLivingEntityTargets.size() != 0;
    }

    public void spawnReinforcements() {
        ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_235898_, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 1.15, (double)this.m_58899_().m_123343_() + 0.5, 2, 0.2, 0.0, 0.2, 0.0);
        ((ServerLevel)this.f_58857_).m_5594_((Player)null, this.m_58899_(), SoundEvents.f_215740_, SoundSource.BLOCKS, 2.0f, 1.6f);
        ArrayList<BlockPos> possibleSpawnPositions = this.getSpawnPositionsInCube((ServerLevel)this.f_58857_, this.m_58899_(), 5, this.MAX_SPAWNED_ENTITIES);
        BlockPos[] finalizedSpawnPositions = new BlockPos[this.MAX_SPAWNED_ENTITIES];
        for (int iterations = 0; iterations < possibleSpawnPositions.size(); ++iterations) {
            finalizedSpawnPositions[iterations] = possibleSpawnPositions.get(iterations);
        }
        if (possibleSpawnPositions.isEmpty()) {
            finalizedSpawnPositions[0] = this.m_58899_().m_7494_();
        }
        this.request = new ReinforcementRequest((ServerLevel)this.m_58904_(), finalizedSpawnPositions);
        this.request.sender = ReinforcementRequest.senderType.Summoner;
        if (this.possibleAggressorTargets.size() != 0) {
            this.request.is_aggressor_nearby = true;
        }
        if (this.possibleLivingEntityTargets.size() != 0) {
            this.request.is_non_sculk_mob_nearby = true;
        }
        if (this.request.is_non_sculk_mob_nearby || this.request.is_aggressor_nearby) {
            SculkHorde.entityFactory.createReinforcementRequestFromSummoner(this.f_58857_, this.m_58899_(), false, this.request);
        }
    }

    public static void recieveVibrationTick(Level level, BlockPos vibrationSource, BlockState blockState, SculkSummonerBlockEntity blockEntity, Entity entity) {
        if (level == null || level.f_46443_) {
            return;
        }
        blockEntity.setVibrationCooldown(true);
        blockEntity.lastGameTimeOfVibrationRecieve = level.m_46467_();
        if (!blockEntity.areAllReinforcementsDead()) {
            return;
        }
        if (blockEntity.areAnyTargetsNearBy(blockEntity.f_58858_, blockEntity)) {
            blockEntity.spawnReinforcements();
            level.m_46796_(3007, blockEntity.f_58858_, 0);
            level.m_220407_(GameEvent.f_223701_, blockEntity.f_58858_, GameEvent.Context.m_223717_((Entity)entity));
        }
    }

    public static void tickOnCoolDown(Level level, BlockPos blockPos, BlockState blockState, SculkSummonerBlockEntity blockEntity) {
        if (level == null || level.f_46443_) {
            return;
        }
        if (blockEntity.isVibrationCooldownOver()) {
            blockEntity.setVibrationCooldown(false);
        }
    }

    public ArrayList<BlockPos> getSpawnPositionsInCube(ServerLevel worldIn, BlockPos origin, int length, int amountOfPositions) {
        ArrayList<BlockPos> listOfPossibleSpawns = SculkSummonerBlockEntity.getSpawnPositions(worldIn, origin, this.VALID_SPAWN_BLOCKS, length);
        ArrayList<BlockPos> finalList = new ArrayList<BlockPos>();
        Random rng = new Random();
        for (int count = 0; count < amountOfPositions && listOfPossibleSpawns.size() > 0; ++count) {
            int randomIndex = rng.nextInt(listOfPossibleSpawns.size());
            finalList.add(listOfPossibleSpawns.get(randomIndex));
            listOfPossibleSpawns.remove(randomIndex);
        }
        return finalList;
    }

    public boolean isValidSpawnPosition(ServerLevel worldIn, BlockPos pos) {
        boolean isBlockBleowCurable = BlockInfestationHelper.isCurable(worldIn, pos.m_7495_());
        boolean isBaseBlockReplaceable = worldIn.m_8055_(pos).m_60722_((Fluid)Fluids.f_76193_);
        boolean isBlockAboveReplaceable = worldIn.m_8055_(pos.m_7494_()).m_60722_((Fluid)Fluids.f_76193_);
        return isBlockBleowCurable && isBaseBlockReplaceable && isBlockAboveReplaceable;
    }

    public static ArrayList<BlockPos> getSpawnPositions(ServerLevel worldIn, BlockPos origin, Predicate<BlockPos> predicateIn, double pDistance) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        int i = 0;
        while ((double)i <= pDistance) {
            int j = 0;
            while ((double)j < pDistance) {
                int k = 0;
                while (k <= j) {
                    int l;
                    int n = l = k < j && k > -j ? j : 0;
                    while (l <= j) {
                        BlockPos temp = new BlockPos(origin.m_123341_() + k, origin.m_123342_() + i - 1, origin.m_123343_() + l);
                        if (origin.m_123314_((Vec3i)temp, pDistance) && predicateIn.test(temp)) {
                            list.add(temp);
                        }
                        l = l > 0 ? -l : 1 - l;
                    }
                    k = k > 0 ? -k : 1 - k;
                }
                ++j;
            }
            i = i > 0 ? -i : 1 - i;
        }
        return list;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128425_("listener", 10)) {
            VibrationSystem.Data.f_279637_.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)nbt.m_128469_("listener"))).resultOrPartial(arg_0 -> ((Logger)SculkHorde.LOGGER).error(arg_0)).ifPresent(data -> {
                this.vibrationData = data;
            });
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        VibrationSystem.Data.f_279637_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.vibrationData).resultOrPartial(arg_0 -> ((Logger)SculkHorde.LOGGER).error(arg_0)).ifPresent(p_222871_ -> nbt.m_128365_("listener", p_222871_));
    }

    public VibrationSystem.Listener getListener() {
        return this.vibrationListener;
    }

    public VibrationSystem.Data m_280002_() {
        return this.vibrationData;
    }

    public VibrationSystem.User m_280445_() {
        return this.vibrationUser;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, state2 -> {
            BlockState blockState = ((SculkSummonerBlockEntity)state2.getAnimatable()).m_58904_().m_8055_(((SculkSummonerBlockEntity)state2.getAnimatable()).f_58858_);
            if (blockState.m_60713_((Block)ModBlocks.SCULK_SUMMONER_BLOCK.get()) && ((Boolean)((SculkSummonerBlockEntity)state2.getAnimatable()).m_58904_().m_8055_(((SculkSummonerBlockEntity)state2.getAnimatable()).f_58858_).m_61143_((Property)SculkSummonerBlock.VIBRATION_COOLDOWN)).booleanValue()) {
                return state2.setAndContinue(SCULK_SUMMONER_COOLDOWN_ANIMATION);
            }
            return state2.setAndContinue(SCULK_SUMMONER_READY_ANIMATION);
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    class VibrationUser
    implements VibrationSystem.User {
        private static final int LISTENER_RADIUS = 24;
        private final PositionSource positionSource;
        private SculkSummonerBlockEntity summoner;

        public VibrationUser(SculkSummonerBlockEntity summoner) {
            this.positionSource = new BlockPositionSource(SculkSummonerBlockEntity.this.f_58858_);
            this.summoner = summoner;
        }

        public int m_280351_() {
            return 24;
        }

        public PositionSource m_280010_() {
            return this.positionSource;
        }

        public TagKey<GameEvent> m_280028_() {
            return GameEventTags.f_215854_;
        }

        public boolean m_280080_(ServerLevel level, BlockPos pos, GameEvent event, GameEvent.Context context) {
            return !SculkSummonerBlockEntity.this.isBlockStateVibrationCooldownTrue();
        }

        public void m_280271_(ServerLevel level, BlockPos blockPos, GameEvent gameEvent, @Nullable Entity entity, @Nullable Entity entity1, float power) {
            SculkSummonerBlockEntity.recieveVibrationTick((Level)level, blockPos, SculkSummonerBlockEntity.this.m_58900_(), this.summoner, entity);
        }

        public void m_280022_() {
            SculkSummonerBlockEntity.this.m_6596_();
        }

        public boolean m_280215_() {
            return true;
        }
    }
}

