/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.block;

import com.github.sculkhorde.core.ModBlocks;
import com.github.sculkhorde.util.BlockInfestationHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeBlock;

public class TendrilsBlock
extends VineBlock
implements IForgeBlock {
    public TendrilsBlock(BlockBehaviour.Properties prop) {
        super(prop);
    }

    public TendrilsBlock() {
        this(TendrilsBlock.getProperties());
    }

    public static BlockBehaviour.Properties getProperties() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50191_).m_284180_(MapColor.f_283908_).m_60955_().m_60910_();
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockState northBlock = pLevel.m_8055_(pPos.m_122012_());
        BlockState eastBlock = pLevel.m_8055_(pPos.m_122029_());
        BlockState southBlock = pLevel.m_8055_(pPos.m_122019_());
        BlockState westBlock = pLevel.m_8055_(pPos.m_122024_());
        if (pState.m_60734_().equals(ModBlocks.TENDRILS.get())) {
            if (((Boolean)pState.m_61143_((Property)f_57834_)).booleanValue() && this.isValidFace(pLevel, northBlock, pPos, Direction.SOUTH)) {
                return true;
            }
            if (((Boolean)pState.m_61143_((Property)f_57835_)).booleanValue() && this.isValidFace(pLevel, eastBlock, pPos, Direction.WEST)) {
                return true;
            }
            if (((Boolean)pState.m_61143_((Property)f_57836_)).booleanValue() && this.isValidFace(pLevel, southBlock, pPos, Direction.NORTH)) {
                return true;
            }
            if (((Boolean)pState.m_61143_((Property)f_57837_)).booleanValue() && this.isValidFace(pLevel, westBlock, pPos, Direction.EAST)) {
                return true;
            }
        } else if (this.isValidFace(pLevel, northBlock, pPos, Direction.SOUTH) || this.isValidFace(pLevel, eastBlock, pPos, Direction.WEST) || this.isValidFace(pLevel, southBlock, pPos, Direction.NORTH) || this.isValidFace(pLevel, westBlock, pPos, Direction.EAST)) {
            return true;
        }
        return false;
    }

    public void placeBlock(Level worldIn, BlockPos blockPosIn) {
        if (!worldIn.m_8055_(blockPosIn).m_60795_()) {
            return;
        }
        if (!this.m_7898_(worldIn.m_8055_(blockPosIn), (LevelReader)worldIn, blockPosIn)) {
            return;
        }
        Block vein = (Block)ModBlocks.TENDRILS.get();
        BlockState northBlock = worldIn.m_8055_(blockPosIn.m_122012_());
        BlockState eastBlock = worldIn.m_8055_(blockPosIn.m_122029_());
        BlockState southBlock = worldIn.m_8055_(blockPosIn.m_122019_());
        BlockState westBlock = worldIn.m_8055_(blockPosIn.m_122024_());
        if (this.isValidFace((LevelReader)worldIn, northBlock, blockPosIn, Direction.SOUTH)) {
            worldIn.m_46597_(blockPosIn, (BlockState)vein.m_49966_().m_61124_((Property)f_57834_, (Comparable)Boolean.valueOf(true)));
        } else if (this.isValidFace((LevelReader)worldIn, eastBlock, blockPosIn, Direction.WEST)) {
            worldIn.m_46597_(blockPosIn, (BlockState)vein.m_49966_().m_61124_((Property)f_57835_, (Comparable)Boolean.valueOf(true)));
        } else if (this.isValidFace((LevelReader)worldIn, southBlock, blockPosIn, Direction.NORTH)) {
            worldIn.m_46597_(blockPosIn, (BlockState)vein.m_49966_().m_61124_((Property)f_57836_, (Comparable)Boolean.valueOf(true)));
        } else if (this.isValidFace((LevelReader)worldIn, westBlock, blockPosIn, Direction.EAST)) {
            worldIn.m_46597_(blockPosIn, (BlockState)vein.m_49966_().m_61124_((Property)f_57837_, (Comparable)Boolean.valueOf(true)));
        }
    }

    public boolean isValidFace(LevelReader worldIn, BlockState blockState, BlockPos blockPosIn, Direction direction) {
        if (!blockState.m_60783_((BlockGetter)worldIn, blockPosIn, direction)) {
            return false;
        }
        if (BlockInfestationHelper.isCurable((ServerLevel)worldIn, blockPosIn)) {
            return false;
        }
        if (blockState.m_60713_((Block)ModBlocks.SCULK_BEE_NEST_BLOCK.get())) {
            return false;
        }
        if (blockState.m_60713_((Block)ModBlocks.SCULK_SUMMONER_BLOCK.get())) {
            return false;
        }
        if (blockState.m_60713_((Block)ModBlocks.SCULK_LIVING_ROCK_BLOCK.get())) {
            return false;
        }
        if (blockState.m_60713_((Block)ModBlocks.SCULK_NODE_BLOCK.get())) {
            return false;
        }
        return !blockState.m_60713_((Block)ModBlocks.INFESTED_STONE.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter iBlockReader, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, iBlockReader, tooltip, flagIn);
        tooltip.add((Component)Component.m_237115_((String)"tooltip.sculkhorde.tendrils"));
    }
}

