/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.block;

import com.github.sculkhorde.common.blockentity.SoulHarvesterBlockEntity;
import com.github.sculkhorde.common.entity.infection.CursorSurfaceInfectorEntity;
import com.github.sculkhorde.core.ModBlockEntities;
import com.github.sculkhorde.util.BlockAlgorithms;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeBlock;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class SoulHarvesterBlock
extends BaseEntityBlock
implements IForgeBlock {
    public static float HARDNESS = 0.6f;
    public static float BLAST_RESISTANCE = 0.5f;
    public static final BooleanProperty IS_PREPARED = BooleanProperty.m_61465_((String)"is_prepared");
    public static final BooleanProperty IS_ACTIVE = BooleanProperty.m_61465_((String)"is_active");
    public static final int MAX_HEALTH = 1000;

    public SoulHarvesterBlock(BlockBehaviour.Properties prop) {
        super(prop);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)IS_PREPARED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)IS_ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public SoulHarvesterBlock() {
        this(SoulHarvesterBlock.getProperties());
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)IS_PREPARED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)IS_ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{IS_PREPARED}).m_61104_(new Property[]{IS_ACTIVE});
    }

    public static BlockBehaviour.Properties getProperties() {
        BlockBehaviour.Properties prop = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_220858_).m_60913_(HARDNESS, BLAST_RESISTANCE).m_60955_().m_60918_(SoundType.f_222472_);
        return prop;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (pState.m_60734_() != pNewState.m_60734_() && (blockEntity = pLevel.m_7702_(pPos)) instanceof SoulHarvesterBlockEntity) {
            ((SoulHarvesterBlockEntity)blockEntity).drops();
            int healthHarvested = ((SoulHarvesterBlockEntity)blockEntity).getHealthHarvested();
            int massPerCursor = healthHarvested / 10;
            BlockPos groundPosition = BlockAlgorithms.getGroundBlockPos(pLevel, pPos, pPos.m_123342_());
            for (int i = 0; i < 10; ++i) {
                Vec3 randomParticlePosition = new Vec3((double)groundPosition.m_123341_() + pLevel.m_213780_().m_188500_(), (double)groundPosition.m_123342_() + pLevel.m_213780_().m_188500_(), (double)groundPosition.m_123343_() + pLevel.m_213780_().m_188500_());
                ((ServerLevel)pLevel).m_8767_((ParticleOptions)ParticleTypes.f_235898_, randomParticlePosition.f_82479_, randomParticlePosition.f_82480_, randomParticlePosition.f_82481_, 2, 0.2, 0.0, 0.2, 0.0);
                pLevel.m_5594_(null, pPos, SoundEvents.f_215740_, SoundSource.BLOCKS, 2.0f, 0.6f + pLevel.m_213780_().m_188501_() * 0.4f);
                CursorSurfaceInfectorEntity cursor = new CursorSurfaceInfectorEntity(pLevel);
                cursor.setMaxRange(100);
                cursor.setMaxTransformations(massPerCursor);
                cursor.setTickIntervalMilliseconds(100L);
                cursor.m_6034_(groundPosition.m_123341_(), groundPosition.m_123342_(), groundPosition.m_123343_());
                pLevel.m_7967_((Entity)cursor);
            }
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.m_5776_()) {
            return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
        }
        BlockEntity entity = pLevel.m_7702_(pPos);
        if (!(entity instanceof SoulHarvesterBlockEntity)) {
            throw new IllegalStateException("Our Container provider is missing!");
        }
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)((SoulHarvesterBlockEntity)entity), (BlockPos)pPos);
        return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @javax.annotation.Nullable BlockGetter iBlockReader, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, iBlockReader, tooltip, flagIn);
        tooltip.add((Component)Component.m_237115_((String)"tooltip.sculkhorde.soul_harvester"));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState state2) {
        return new SoulHarvesterBlockEntity(blockPos, state2);
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level levelIn, BlockState blockStateIn, BlockEntityType<T> blockEntityTypeIn) {
        if (levelIn.m_5776_()) {
            return null;
        }
        return SoulHarvesterBlock.m_152132_(blockEntityTypeIn, (BlockEntityType)((BlockEntityType)ModBlockEntities.SOUL_HARVESTER_BLOCK_ENTITY.get()), SoulHarvesterBlockEntity::serverTick);
    }

    public RenderShape m_7514_(BlockState state2) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }
}

