/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.block;

import com.github.sculkhorde.common.blockentity.SculkNodeBlockEntity;
import com.github.sculkhorde.common.entity.SculkPhantomEntity;
import com.github.sculkhorde.core.ModBlockEntities;
import com.github.sculkhorde.core.ModBlocks;
import com.github.sculkhorde.core.ModSavedData;
import com.github.sculkhorde.core.ModSounds;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.BlockAlgorithms;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeBlock;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public class SculkNodeBlock
extends BaseEntityBlock
implements IForgeBlock {
    public static float HARDNESS = 50.0f;
    public static float BLAST_RESISTANCE = 10.0f;
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");

    public SculkNodeBlock(BlockBehaviour.Properties prop) {
        super(prop);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
    }

    public SculkNodeBlock() {
        this(SculkNodeBlock.getProperties());
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{ACTIVE});
    }

    public static void tryPlaceSculkNode(ServerLevel worldIn, BlockPos targetPos, boolean forcePlace) {
        boolean doNotSpawnNode;
        boolean isSavedDataNull;
        int SPAWN_NODE_COST = 3000;
        int SPAWN_NODE_BUFFER = 1000;
        boolean failRandomChance = new Random().nextInt(1000) > 1;
        boolean bl = isSavedDataNull = SculkHorde.savedData == null;
        if (isSavedDataNull) {
            SculkHorde.LOGGER.error("Tried to place Node. SculkHorde.savedData is null");
            return;
        }
        if (forcePlace) {
            SculkNodeBlock.PlaceNode(worldIn, targetPos);
            return;
        }
        if (failRandomChance) {
            return;
        }
        boolean isTheHordeDefeated = SculkHorde.savedData.isHordeDefeated();
        boolean isNodeSpawnOnCooldown = !SculkHorde.savedData.isNodeSpawnCooldownOver();
        boolean isNotValidPositionForSculkNode = !SculkNodeBlock.isValidPositionForSculkNode(worldIn, targetPos);
        boolean isNotEnoughMass = SculkHorde.savedData.getSculkAccumulatedMass() < 4000;
        boolean bl2 = doNotSpawnNode = isTheHordeDefeated || isNodeSpawnOnCooldown || isNotValidPositionForSculkNode || isNotEnoughMass;
        if (doNotSpawnNode) {
            return;
        }
        SculkNodeBlock.PlaceNode(worldIn, targetPos);
        SculkHorde.savedData.subtractSculkAccumulatedMass(3000);
    }

    public static boolean isValidPositionForSculkNode(ServerLevel worldIn, BlockPos positionIn) {
        if (SculkHorde.savedData == null) {
            return false;
        }
        if (SculkHorde.savedData.getNodeEntries().size() >= SculkHorde.gravemind.sculk_node_limit) {
            return false;
        }
        if (worldIn.equals(ServerLifecycleHooks.getCurrentServer().m_129783_()) && BlockAlgorithms.getBlockDistanceXZ(positionIn, BlockPos.f_121853_) < 300.0f) {
            return false;
        }
        for (ModSavedData.NodeEntry entry : SculkHorde.savedData.getNodeEntries()) {
            int distanceFromPotentialToCurrentNode;
            if (!entry.isEntryValid() || !BlockAlgorithms.areTheseDimensionsEqual((ResourceKey<Level>)entry.getDimension().m_46472_(), (ResourceKey<Level>)worldIn.m_46472_()) || (distanceFromPotentialToCurrentNode = (int)BlockAlgorithms.getBlockDistance(positionIn, entry.getPosition())) >= 300) continue;
            return false;
        }
        return !BlockAlgorithms.isNearFluid(worldIn, positionIn, 5);
    }

    public static void PlaceNode(ServerLevel level, BlockPos blockPos) {
        BlockPos newOrigin = new BlockPos(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
        level.m_46597_(newOrigin, ((SculkNodeBlock)((Object)ModBlocks.SCULK_NODE_BLOCK.get())).m_49966_());
        SculkHorde.savedData.addNodeToMemory(level, newOrigin);
        SculkHorde.savedData.resetNoNodeSpawningTicksElapsed();
        EntityType.f_20465_.m_262496_(level, newOrigin, MobSpawnType.SPAWNER);
        level.m_6907_().forEach(player -> player.m_5661_((Component)Component.m_237113_((String)"A Sculk Node has spawned!"), true));
        level.m_6907_().forEach(player -> level.m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.NODE_SPAWN_SOUND.get(), SoundSource.HOSTILE, 1.0f, 1.0f));
        SculkNodeBlock.spawnSculkPhantomsAtTopOfWorld(level, newOrigin, 10);
    }

    private static void spawnSculkPhantomsAtTopOfWorld(ServerLevel level, BlockPos origin, int amount) {
        int spawnRange = 100;
        int minimumSpawnRange = 50;
        Random rng = new Random();
        for (int i = 0; i < amount; ++i) {
            int x = minimumSpawnRange + rng.nextInt(spawnRange) - spawnRange / 2;
            int z = minimumSpawnRange + rng.nextInt(spawnRange) - spawnRange / 2;
            int y = level.m_151558_();
            BlockPos spawnPosition = new BlockPos(origin.m_123341_() + x, y, origin.m_123343_() + z);
            SculkPhantomEntity.spawnPhantom((Level)level, spawnPosition, true);
        }
    }

    public void m_6402_(Level world, BlockPos bp, BlockState blockState, @javax.annotation.Nullable LivingEntity entity, ItemStack itemStack) {
        super.m_6402_(world, bp, blockState, entity, itemStack);
        if (world.m_5776_()) {
            return;
        }
        if (!world.m_5776_()) {
            SculkHorde.savedData.addNodeToMemory((ServerLevel)world, bp);
        }
    }

    public boolean m_6724_(BlockState blockState) {
        return false;
    }

    public static BlockBehaviour.Properties getProperties() {
        BlockBehaviour.Properties prop = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283743_).m_60913_(HARDNESS, BLAST_RESISTANCE).m_60918_(SoundType.f_56740_);
        return prop;
    }

    public void m_6807_(BlockState state2, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (worldIn.m_5776_()) {
            for (Player player : worldIn.m_6907_()) {
                player.m_5661_((Component)Component.m_237115_((String)"message.sculk_horde.node_placed"), true);
            }
        }
    }

    public void m_6810_(BlockState state2, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.m_60734_() == this) {
            return;
        }
        if (worldIn.m_5776_()) {
            return;
        }
        SculkHorde.savedData.removeNodeFromMemory(pos);
        int subtractAmount = (int)((double)SculkHorde.savedData.getSculkAccumulatedMass() * 0.1);
        SculkHorde.savedData.subtractSculkAccumulatedMass(subtractAmount);
        worldIn.m_6907_().forEach(player -> player.m_5661_((Component)Component.m_237113_((String)("A Sculk Node has been Destroyed! " + subtractAmount + " Mass has been removed from the Horde.")), true));
        worldIn.m_6907_().forEach(player -> worldIn.m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.NODE_DESTROY_SOUND.get(), SoundSource.HOSTILE, 0.7f, 1.0f));
        super.m_6810_(state2, worldIn, pos, newState, isMoving);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @javax.annotation.Nullable BlockGetter iBlockReader, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, iBlockReader, tooltip, flagIn);
        tooltip.add((Component)Component.m_237115_((String)"tooltip.sculkhorde.sculk_node"));
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return SculkNodeBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.SCULK_NODE_BLOCK_ENTITY.get()), SculkNodeBlockEntity::tick);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState state2) {
        return new SculkNodeBlockEntity(blockPos, state2);
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }
}

