/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.block;

import com.github.sculkhorde.common.blockentity.SculkMassBlockEntity;
import com.github.sculkhorde.core.ModBlockEntities;
import com.github.sculkhorde.core.SculkHorde;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.extensions.IForgeBlock;
import org.jetbrains.annotations.Nullable;

public class SculkMassBlock
extends BaseEntityBlock
implements IForgeBlock {
    public static float HARDNESS = 0.6f;
    public static float BLAST_RESISTANCE = 0.5f;
    public static final float SCULK_HOARD_MASS_TAX = 0.33333334f;
    public static double HEALTH_ABSORB_MULTIPLIER = 3.0;

    public SculkMassBlock(BlockBehaviour.Properties prop) {
        super(prop);
    }

    public SculkMassBlock() {
        this(SculkMassBlock.getProperties());
    }

    public static BlockBehaviour.Properties getProperties() {
        return BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283744_).m_60913_(HARDNESS, BLAST_RESISTANCE).m_60918_(SoundType.f_56750_).m_60955_();
    }

    public void spawn(Level world, BlockPos originPos, float victimHealth) {
        int attempts;
        BlockPos placementPos = originPos.m_7494_();
        int MAX_ATTEMPTS = 64;
        for (attempts = 0; world.m_8055_(placementPos.m_7495_()).m_60722_((Fluid)Fluids.f_76193_) && attempts <= MAX_ATTEMPTS; ++attempts) {
            placementPos = placementPos.m_7495_();
        }
        if (attempts < MAX_ATTEMPTS && !world.m_8055_(placementPos).equals(this.m_49966_())) {
            world.m_46597_(placementPos, this.m_49966_());
            SculkMassBlockEntity thisTile = this.getTileEntity(world, placementPos);
            int totalMassPreTax = (int)((double)victimHealth * HEALTH_ABSORB_MULTIPLIER);
            int totalMassTax = (int)((float)totalMassPreTax * 0.33333334f);
            int totalRemainingMass = totalMassPreTax - totalMassTax;
            thisTile.setStoredSculkMass(totalRemainingMass);
            if (SculkHorde.savedData != null) {
                SculkHorde.savedData.addSculkAccumulatedMass(totalMassTax);
            }
            if (SculkHorde.statisticsData != null) {
                SculkHorde.statisticsData.addTotalMassFromBurrowed(totalMassTax);
            }
        }
    }

    public boolean m_6724_(BlockState blockState) {
        return false;
    }

    public SculkMassBlockEntity getTileEntity(Level world, BlockPos thisBlockPos) {
        SculkMassBlockEntity thisTile = null;
        try {
            thisTile = (SculkMassBlockEntity)world.m_7702_(thisBlockPos);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return thisTile;
    }

    public boolean m_7420_(BlockState p_49928_, BlockGetter p_49929_, BlockPos p_49930_) {
        return true;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter iBlockReader, BlockPos blockPos, CollisionContext iSelectionContext) {
        return Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0);
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : SculkMassBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.SCULK_MASS_BLOCK_ENTITY.get()), SculkMassBlockEntity::tick);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState state2) {
        return new SculkMassBlockEntity(blockPos, state2);
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }
}

